/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.console;

import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.console.LineAgeInfo;
import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.dbt.diagram.DbtLineageNode;
import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006J\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0018\u00010\"2\u0006\u0010 \u001a\u00020\u0006J*\u0010%\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00062\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010'\u001a\u00020\u001fJ\u0016\u0010(\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/dbt/console/DbtConsoleService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "graphsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/dbt/console/LineAgeInfo;", "isLineageVisible", "", "project", "Lcom/intellij/openapi/project/Project;", "isDbtToolwindowCreated", "showConsoleViewContent", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "showComponent", "component", "Ljavax/swing/JComponent;", "findLineageContent", "Lcom/intellij/ui/content/Content;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createContent", "handler", "command", "Lcom/intellij/dbt/console/commands/DbtCommand;", "getToolWindow", "dispose", "getGraphHash", "", "module", "getGraphHandle", "Lcom/intellij/diagram/v2/handles/GraphChartHandle;", "Lcom/intellij/dbt/diagram/DbtLineageNode;", "", "setLineageInfo", "graphHandle", "hash", "setGraphHash", "value", "Companion", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtConsoleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtConsoleService.kt\ncom/intellij/dbt/console/DbtConsoleService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,144:1\n1310#2,2:145\n*S KotlinDebug\n*F\n+ 1 DbtConsoleService.kt\ncom/intellij/dbt/console/DbtConsoleService\n*L\n80#1:145,2\n*E\n"})
public final class DbtConsoleService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Module, LineAgeInfo> graphsMap = new ConcurrentHashMap();
    @NotNull
    private static final String DBT_CONSOLE_TOOLWINDOW_ID = "DBT Console";

    public final boolean isLineageVisible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(DBT_CONSOLE_TOOLWINDOW_ID);
        if (toolWindow == null || !toolWindow.isVisible()) {
            return false;
        }
        Content content = this.findLineageContent(toolWindow);
        if (content == null) {
            return false;
        }
        Content lineageContent = content;
        return Intrinsics.areEqual((Object)toolWindow.getContentManager().getSelectedContent(), (Object)lineageContent);
    }

    public final boolean isDbtToolwindowCreated(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow(DBT_CONSOLE_TOOLWINDOW_ID) != null;
    }

    public final void showConsoleViewContent(@NotNull Project project, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.createContent(project, processHandler, DbtCommand.COMPILE);
        processHandler.startNotify();
    }

    public final void showComponent(@NotNull Project project, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ToolWindow toolWindow = this.getToolWindow(project);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content lineageContent = this.findLineageContent(toolWindow);
        if (lineageContent != null) {
            contentManager2.removeContent(lineageContent, true);
        }
        RunnerLayoutUi runnerLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("DbtRunner", "", "", (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi, (String)"create(...)");
        RunnerLayoutUi ui = runnerLayoutUi;
        Content content = ui.createContent("DbtLineage", component, DbtBundle.message("dbt.lineage.title", new Object[0]), null, component);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        ui.addContent(content2);
        contentManager2.addContent(content2);
        contentManager2.setSelectedContent(content2);
        toolWindow.show();
        toolWindow.getComponent().requestFocus();
    }

    private final Content findLineageContent(ToolWindow toolWindow) {
        Object object;
        block1: {
            Content[] contentArray = toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserData(ViewImpl.ID), (Object)"DbtLineage")) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    private final void createContent(Project project, ProcessHandler handler, DbtCommand command) {
        ToolWindow toolWindow = this.getToolWindow(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        ConsoleViewImpl console = new ConsoleViewImpl(project, globalSearchScope, true, true);
        RunnerLayoutUi runnerLayoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("DbtRunner", "", "", (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi, (String)"create(...)");
        RunnerLayoutUi ui = runnerLayoutUi;
        Content content = ui.createContent("DbtRunner", console.getComponent(), command.getCommandName(), null, console.getPreferredFocusableComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content consoleContent = content;
        console.attachToProcess(handler);
        ui.addContent(consoleContent);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.addContent(consoleContent);
        contentManager2.setSelectedContent(consoleContent);
        toolWindow.show();
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(DBT_CONSOLE_TOOLWINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
            Icon icon = AllIcons.Toolwindows.ToolWindowDataView;
            Supplier<String> supplier = DbtConsoleService::getToolWindow$lambda$1;
            toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(DBT_CONSOLE_TOOLWINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, icon, supplier, 236, null));
        }
        return toolWindow;
    }

    public void dispose() {
        this.graphsMap.clear();
    }

    public final int getGraphHash(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LineAgeInfo lineAgeInfo = this.graphsMap.get(module);
        return lineAgeInfo != null ? lineAgeInfo.getHash() : 0;
    }

    @Nullable
    public final GraphChartHandle<DbtLineageNode, Object> getGraphHandle(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LineAgeInfo lineAgeInfo = this.graphsMap.get(module);
        return lineAgeInfo != null ? lineAgeInfo.getGraphHandle() : null;
    }

    public final void setLineageInfo(@NotNull Module module, @NotNull GraphChartHandle<DbtLineageNode, Object> graphHandle, int hash) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(graphHandle, (String)"graphHandle");
        ((Map)this.graphsMap).put(module, new LineAgeInfo(graphHandle, hash));
    }

    public final void setGraphHash(@NotNull Module module, int value) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LineAgeInfo lineAgeInfo = this.graphsMap.get(module);
        if (lineAgeInfo != null) {
            lineAgeInfo.setHash(value);
        } else {
            ((Map)this.graphsMap).put(module, new LineAgeInfo(null, value));
        }
    }

    private static final String getToolWindow$lambda$1() {
        return DbtBundle.message("toolwindow.title.DbtConsole", new Object[0]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/dbt/console/DbtConsoleService$Companion;", "", "<init>", "()V", "DBT_CONSOLE_TOOLWINDOW_ID", "", "intellij.dbt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

