		opt nolist
;
; Device type defintions for PIC16F688
;

__progmem_size		equ	4096
__data_eeprom_size	equ	256

__config		set	0x3fff

			set_pic_type	"PIC16F688", "14-bit"

__do_config	macro	; keyword, value
		if streqcase("\1", "osc") | streqcase("\1", "fosc")
			if streqcase("\2", "lp")
__config			set __config & 0xfff8
				exitm
			endif
			if streqcase("\2", "xt")
__config			set (__config & 0xfff8) | 0x01
				exitm
			endif
			if streqcase("\2", "hs")
__config			set (__config & 0xfff8) | 0x02
				exitm
			endif
			if streqcase("\2", "ec")
__config			set (__config & 0xfff8) | 0x03
				exitm
			endif
			if streqcase("\2", "intoscio") | streqcase("\2", "intrcio")
__config			set (__config & 0xfff8) | 0x04
				exitm
			endif
			if streqcase("\2", "intosc") | streqcase("\2", "intrc")
__config			set (__config & 0xfff8) | 0x05
				exitm
			endif
			if streqcase("\2", "extrcio")
__config			set (__config & 0xfff8) | 0x06
				exitm
			endif
			if streqcase("\2", "extrc")
__config			set (__config & 0xfff8) | 0x07
				exitm
			endif
			error	"Invalid oscillator setting"
			exitm
		endif
		if streqcase("\1", "wdt") | streqcase("\1", "wdte")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0x0008
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0xfff7
				exitm
			endif
			error "Invalid WDT setting"
			exitm
		endif
		if streqcase("\1", "pwrt") | streqcase("\1", "pwrte")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0xffef
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0x0010
				exitm
			endif
			error "Invalid PWRT setting"
			exitm
		endif
		if streqcase("\1", "mclr") | streqcase("\1", "mclre")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0x0020
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0xffdf
				exitm
			endif
			error "Invalid MCLR setting"
			exitm
		endif
		if streqcase("\1", "cp")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0xffbf
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0x0040
				exitm
			endif
			error "Invalid CP setting"
			exitm
		endif
		if streqcase("\1", "cpd")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0xff7f
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0x0080
				exitm
			endif
			error "Invalid CPD setting"
			exitm
		endif
		if streqcase("\1", "boden")
			if streqcase("\2", "no") | streqcase("\2", "off")
__config			set (__config & 0xfcff)
				exitm
			endif
			if ((\2) >= 0) & ((\2) <= 3)
__config			set (__config & 0xfcff) | ((\2) << 8)
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "ieso")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0x0400
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0xfbff
				exitm
			endif
			error "Invalid IESO setting"
			exitm
		endif
		if streqcase("\1", "fcmen")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0x0800
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0xf7ff
				exitm
			endif
			error "Invalid FCMEN setting"
			exitm
		endif
		error "Invalid config keyword"
		endm

		opt list
