#ifndef ATL_dGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,172,320,468,616,653,690,727,764,801,838,875,912,949,986,1023,1060,1134,1208,1245,1282,1319,1356,1430,1504,1652,1800,1948,2096,2244,2392,3576,4760
 * N : 25,172,320,468,616,653,690,727,764,801,838,875,912,949,986,1023,1060,1134,1208,1245,1282,1319,1356,1430,1504,1652,1800,1948,2096,2244,2392,3576,4760
 * NB : 1,2,2,2,7,19,23,24,27,28,30,30,31,32,33,33,34,34,35,83,91,92,99,98,115,118,131,128,146,132,216,264,425
 */
#define ATL_dGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 98) (nb_) = 1; \
   else if ((n_) < 542) (nb_) = 2; \
   else if ((n_) < 634) (nb_) = 7; \
   else if ((n_) < 671) (nb_) = 19; \
   else if ((n_) < 708) (nb_) = 23; \
   else if ((n_) < 745) (nb_) = 24; \
   else if ((n_) < 782) (nb_) = 27; \
   else if ((n_) < 819) (nb_) = 28; \
   else if ((n_) < 893) (nb_) = 30; \
   else if ((n_) < 930) (nb_) = 31; \
   else if ((n_) < 967) (nb_) = 32; \
   else if ((n_) < 1041) (nb_) = 33; \
   else if ((n_) < 1171) (nb_) = 34; \
   else if ((n_) < 1226) (nb_) = 35; \
   else if ((n_) < 1263) (nb_) = 83; \
   else if ((n_) < 1300) (nb_) = 91; \
   else if ((n_) < 1337) (nb_) = 92; \
   else if ((n_) < 1393) (nb_) = 99; \
   else if ((n_) < 1467) (nb_) = 98; \
   else if ((n_) < 1578) (nb_) = 115; \
   else if ((n_) < 1726) (nb_) = 118; \
   else if ((n_) < 1874) (nb_) = 131; \
   else if ((n_) < 2022) (nb_) = 128; \
   else if ((n_) < 2170) (nb_) = 146; \
   else if ((n_) < 2318) (nb_) = 132; \
   else if ((n_) < 2984) (nb_) = 216; \
   else if ((n_) < 4168) (nb_) = 264; \
   else (nb_) = 425; \
}


#endif    /* end ifndef ATL_dGetNB_geqrf */
