#ifndef ATL_ctGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,180,336,375,414,453,492,570,648,959,1271,1426,1504,1582,1738,1894,2050,2206,2245,2284,2323,2362,2440,2518,2829,3141,3453,3765,4388,5012,5635,6259,7506,8753,10000
 * N : 25,180,336,375,414,453,492,570,648,959,1271,1426,1504,1582,1738,1894,2050,2206,2245,2284,2323,2362,2440,2518,2829,3141,3453,3765,4388,5012,5635,6259,7506,8753,10000
 * NB : 1,15,35,35,36,38,39,39,43,43,67,64,64,83,77,115,112,127,127,129,129,130,130,131,151,159,160,163,191,192,208,480,480,480,864
 */
#define ATL_ctGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 102) (nb_) = 1; \
   else if ((n_) < 258) (nb_) = 15; \
   else if ((n_) < 394) (nb_) = 35; \
   else if ((n_) < 433) (nb_) = 36; \
   else if ((n_) < 472) (nb_) = 38; \
   else if ((n_) < 609) (nb_) = 39; \
   else if ((n_) < 1115) (nb_) = 43; \
   else if ((n_) < 1348) (nb_) = 67; \
   else if ((n_) < 1543) (nb_) = 64; \
   else if ((n_) < 1660) (nb_) = 83; \
   else if ((n_) < 1816) (nb_) = 77; \
   else if ((n_) < 1972) (nb_) = 115; \
   else if ((n_) < 2128) (nb_) = 112; \
   else if ((n_) < 2264) (nb_) = 127; \
   else if ((n_) < 2342) (nb_) = 129; \
   else if ((n_) < 2479) (nb_) = 130; \
   else if ((n_) < 2673) (nb_) = 131; \
   else if ((n_) < 2985) (nb_) = 151; \
   else if ((n_) < 3297) (nb_) = 159; \
   else if ((n_) < 3609) (nb_) = 160; \
   else if ((n_) < 4076) (nb_) = 163; \
   else if ((n_) < 4700) (nb_) = 191; \
   else if ((n_) < 5323) (nb_) = 192; \
   else if ((n_) < 5947) (nb_) = 208; \
   else if ((n_) < 9376) (nb_) = 480; \
   else (nb_) = 864; \
}


#endif    /* end ifndef ATL_ctGetNB_geqrf */
