#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,87,149,211,273,335,397,521,1018,1266,1390,1515,2012,2136,2260,2509,2757,2881,3006,3130,3254,3503,3627,3751,3875,3937,4000
 * N : 25,87,149,211,273,335,397,521,1018,1266,1390,1515,2012,2136,2260,2509,2757,2881,3006,3130,3254,3503,3627,3751,3875,3937,4000
 * NB : 12,16,24,24,36,36,40,48,48,48,48,72,72,96,96,96,96,96,124,136,144,148,152,168,180,196,236
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 56) (nb_) = 12; \
   else if ((n_) < 118) (nb_) = 16; \
   else if ((n_) < 242) (nb_) = 24; \
   else if ((n_) < 366) (nb_) = 36; \
   else if ((n_) < 459) (nb_) = 40; \
   else if ((n_) < 1452) (nb_) = 48; \
   else if ((n_) < 2074) (nb_) = 72; \
   else if ((n_) < 2943) (nb_) = 96; \
   else if ((n_) < 3068) (nb_) = 124; \
   else if ((n_) < 3192) (nb_) = 136; \
   else if ((n_) < 3378) (nb_) = 144; \
   else if ((n_) < 3565) (nb_) = 148; \
   else if ((n_) < 3689) (nb_) = 152; \
   else if ((n_) < 3813) (nb_) = 168; \
   else if ((n_) < 3906) (nb_) = 180; \
   else if ((n_) < 3968) (nb_) = 196; \
   else (nb_) = 236; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
