/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GAME_H
#define GAME_H

typedef enum {
    SPEED_FASTEST = 1,
    SPEED_FAST,
    SPEED_NORMAL,
    SPEED_SLOW,
    SPEED_PAUSED
} game_speeds_t;

typedef enum {
    REASON_FIND_HOUSING,
    REASON_FIND_WORK,
    REASON_EMPLOYED,
    REASON_UNEMPLOYED,
    REASON_TAXES,
    REASON_ECONOMY,
    REASON_HOMELESS,
    REASON_NATURE,
    REASON_POLICE,
    REASON_FIRE,
    REASON_HOSPITAL,
    REASON_HOUSED,
    REASON_NOSCHOOL,
    REASON_NOBUY,
    REASON_SOCIAL,
    REASON_SCHOOLS,
    REASON_UNDEREMPLOYED,
    REASON_NOPOWER,
    REASON_NOWATER,
    REASON_GARBAGE,

    NUM_REASONS
} happy_reason_t;

enum labor_skill {
    LABOR_NOEDUCATION = 0,
    LABOR_UNSKILLED,
    LABOR_BLUECOLLAR,
    LABOR_PROFESSIONAL,
    LABOR_EXPERT,
    LABOR_NUMGROUPS
};

struct labor_group {
    enum labor_skill skill;
    char *name;
    char id;
    int edlevel;    
    int salary;
};

typedef struct labor_s {
    short workers[LABOR_NUMGROUPS];
} labor_t;

extern struct labor_group labor_table[];


#include "utils.h"
#include "mapspot.h"



typedef struct game_s {
    int active;

    int tax_rates[NUM_TAX_TYPES];
    int reasons[NUM_REASONS];
    int reasons_last[NUM_REASONS];
    int government_player;

    /* state of things. might not be exactly accurate */
    int vacancies;
    int homeless;
    labor_t jobsavail;
    labor_t needjobs;

    mapspot_list_t *schools_list;
    mapspot_list_t *avail_houses_list;
    mapspot_list_t *avail_job_list;

    int map_startx;
    int map_starty;

    /* population */
    int totalpop;
    float avghappy;

    int left_lastmonth;
    int popchange_lastmonth;
    int totalkids;
    int schoolless;

    int min_working_age;

    /* month things */
    int month_gdp;

    /* investment things */
    int total_to_invest;

    /* utilities */
    int power_numyes;
    int power_numno;
    int power_excess;

    int water_numyes;
    int water_numno;
    int water_excess;
    int water_capacity;

    int garbage_excess;

} game_t;

#endif /* GAME_H */
