/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "map_item.h"

struct map_item *map_items = NULL;
static mapobj_t g_emptyobj = MAPOBJ_INVALID;

extern mapobj_t
map_item_registerobj(char *name)
{
    int slot;

    if (!map_items) {
	int i;

	map_items = calloc(1, sizeof(struct map_item)*(MAX_MAPOBJ_NUM+1));

	for (i = 0; i < MAX_MAPOBJ_NUM; i++) {
	    map_items[i].num = MAPOBJ_INVALID;
	}
    }

    /*
     * Find an empty slot
     */
    for (slot = 0; slot < MAX_MAPOBJ_NUM; slot++) {
	if (map_items[slot].num == MAPOBJ_INVALID) {
	    break;
	}
    }

    /* didn't find slot */
    if (slot == MAX_MAPOBJ_NUM) {
	return MAPOBJ_INVALID;
    }

    /*
     * register it
     */
    map_items[slot].num = slot;
    map_items[slot].name = strdup(name);

    return slot;
}

extern maptype_t
map_item_parsetypestring(char *type)
{
    if (!strcasecmp(type,"Empty")) {
        return MAPTYPE_EMPTY;
    } else if (!strcasecmp(type,"House")) {
	return MAPTYPE_HOUSE;
    } else if (!strcasecmp(type,"Entertainment")) {
	return MAPTYPE_ENTERTAINMENT;
    } else if (!strcasecmp(type,"Commercial")) {
	return MAPTYPE_COMMERCIAL;
    } else if (!strcasecmp(type,"Office")) {
	return MAPTYPE_OFFICE;
    } else if (!strcasecmp(type,"Industrial")) {
	return MAPTYPE_INDUSTRIAL;
    } else if (!strcasecmp(type,"Farm")) {
	return MAPTYPE_FARM;
    } else if (!strcasecmp(type,"School")) {
	return MAPTYPE_SCHOOL;
    } else if (!strcasecmp(type,"Water")) {
	return MAPTYPE_WATER;
    } else if (!strcasecmp(type,"Zoning")) {
	return MAPTYPE_ZONING;
    } else if (!strcasecmp(type,"Police")) {
	return MAPTYPE_POLICE;
    } else if (!strcasecmp(type,"Fire")) {
	return MAPTYPE_FIRE;
    } else if (!strcasecmp(type,"Hospital")) {
	return MAPTYPE_HOSPITAL;
    } else if (!strcasecmp(type,"Road")) {
	return MAPTYPE_ROAD;
    } else if (!strcasecmp(type,"Power")) {
	return MAPTYPE_POWER;
    } else if (!strcasecmp(type,"WaterUtil")) {
	return MAPTYPE_WATERUTIL;
    } else if (!strcasecmp(type,"Landfill")) {
	return MAPTYPE_LANDFILL;
    } else {

	return -1;
    }
}

extern int
map_item_settype(mapobj_t obj, char *typestr)
{
    maptype_t type = map_item_parsetypestring(typestr);
    if (type == -1) return -1;

    map_items[obj].type = type;

    if ((type == MAPTYPE_EMPTY) && (g_emptyobj == MAPOBJ_INVALID)) {
	g_emptyobj = obj;
    }

    return 0;
}

extern maptype_t
map_item_gettype(mapobj_t obj)
{
    return map_items[obj].type;
}

extern char *
map_item_getname(mapobj_t obj)
{
    return map_items[obj].name;
}

extern mapobj_t
map_item_name2obj(char *name)
{
    int i;

    for (i = 0; i < MAX_MAPOBJ_NUM; i++) {
	if ((map_items[i].name) && (strcasecmp(map_items[i].name, name) == 0)) {
	    return i;
	}
    }

    return MAPOBJ_INVALID;
}

extern int
map_item_emptyland(mapobj_t obj)
{
    switch (map_items[obj].type) {
    case MAPTYPE_EMPTY:
    case MAPTYPE_ZONING:
	return 1;
    default:
	return 0;
    }
}

extern mapobj_t *
map_item_get_typelist(maptype_t type, 
		      int (*compar)(const void *, const void *),
		      int *len)
{
    int i = 0;
    int num = 0;
    mapobj_t *list1;

    list1 = malloc(sizeof(mapobj_t) * 100); /* xxx */
    if (!list1) return NULL;

    for (i = 0; i < MAX_MAPOBJ_NUM; i++) {
	if (map_items[i].type == type) {
	    list1[num++] = map_items[i].num;
	}
    }

    list1[num] = MAPOBJ_INVALID;

    if (compar) {
	qsort(list1, num, sizeof(mapobj_t), compar);
    }
    if (len) {
	*len = num;
    }

    return list1;
}

extern int
map_item_landfarmable(mapobj_t obj)
{
    return map_item_emptyland(obj);
}

extern mapobj_t
map_item_emptytype(void)
{
    return g_emptyobj;
}
