/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CONFIG_H
#define CONFIG_H

#include "global.h"

typedef struct{
	int screen_w;
	int screen_h;
	bool sound_enabled;
	bool video_enabled;
	bool ok;
	int language;
} config_data_t;

#include "XmlParser.h"

class Config{
	static int screen_w;
	static int screen_h;
	static bool initialized;
	static int future_screen_w;
	static int future_screen_h;
	static bool sound_enabled;
	static bool video_enabled;
	static int language;
 public:
  Config(void);
  ~Config();
  static int save(void);
  static int get_screen_w(void);
  static int get_screen_h(void);
  static bool is_sound_enabled(void);
  static bool is_video_enabled(void);
  static int get_language(void);
  static void set_sound_enabled(bool);
  static void set_video_enabled(bool);
  static void set_future_resolution(int,int);
  static void set_future_resolution(int);
  static void set_language(int);
  static int load(void);
  static int reload(void);
};
 
#endif
