/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef NOVIDEO

#include "MoviePlayer.h"
#include "Screen.h"

MoviePlayer::MoviePlayer(){}

#ifndef NOSOUND
void MoviePlayer::set_sound_player(SoundPlayer *sp){
	this->sp = sp;
}
#endif

MoviePlayer::~MoviePlayer(){
}

void update_screen(SDL_Surface * screen,
	    Sint32 x, Sint32 y,
	    Uint32 w, Uint32 h){
  SDL_UpdateRect(screen, x, y, w, h);
}

void MoviePlayer::play_video(int i, SDL_Surface *screen){
	SMPEG *mpeg = SMPEG_new(movie_names[i], &info, 0);
	SDL_Event event;
	bool escape = false;

	if(info.has_video){
		SMPEG_setdisplay(mpeg,screen,NULL,update_screen);
		SMPEG_scaleXY(mpeg,SCREEN_WIDTH,SCREEN_HEIGHT);
		SMPEG_setdisplayregion(mpeg,0,0,info.width,info.height);
		SMPEG_move(mpeg,SCREEN_MARGIN_W,SCREEN_MARGIN_H);

		SMPEG_play(mpeg);
	
		do{
			SDL_Delay(250);
			while(SDL_PollEvent(&event)) {
				switch (event.type) {
					case SDL_KEYDOWN:
						switch(event.key.keysym.sym){
							case SDLK_RETURN:	
							case SDLK_ESCAPE:
								escape = true;
							break;
							default:
							break;
						}
					break;
					default:
					break;
				}
			}
		}
		while (!SDL_QuitRequested() && SMPEG_status(mpeg) == SMPEG_PLAYING && !escape);		
	}
	SMPEG_delete(mpeg);
}

#else
; 

#endif

