// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

namespace System.Management.Automation
{
    /// <summary>
    /// Providers that want to specify OutputType can use these strings
    /// for the ProviderCmdlet parameter.
    /// </summary>
    public static class ProviderCmdlet
    {
        /// <summary>
        /// Add-Content cmdlet.
        /// </summary>
        public const string AddContent = "Add-Content";

        /// <summary>
        /// Clear-Content cmdlet.
        /// </summary>
        public const string ClearContent = "Clear-Content";

        /// <summary>
        /// Clear-Item cmdlet.
        /// </summary>
        public const string ClearItem = "Clear-Item";

        /// <summary>
        /// Clear-ItemProperty cmdlet.
        /// </summary>
        public const string ClearItemProperty = "Clear-ItemProperty";

        /// <summary>
        /// Convert-Path cmdlet.
        /// </summary>
        public const string ConvertPath = "Convert-Path";

        /// <summary>
        /// Copy-Item cmdlet.
        /// </summary>
        public const string CopyItem = "Copy-Item";

        /// <summary>
        /// Copy-ItemProperty cmdlet.
        /// </summary>
        public const string CopyItemProperty = "Copy-ItemProperty";

        /// <summary>
        /// Get-Acl cmdlet.
        /// </summary>
        public const string GetAcl = "Get-Acl";

        /// <summary>
        /// Get-ChildItem cmdlet.
        /// </summary>
        public const string GetChildItem = "Get-ChildItem";

        /// <summary>
        /// Get-Content cmdlet.
        /// </summary>
        public const string GetContent = "Get-Content";

        /// <summary>
        /// Get-Item cmdlet.
        /// </summary>
        public const string GetItem = "Get-Item";

        /// <summary>
        /// Get-ItemProperty cmdlet.
        /// </summary>
        public const string GetItemProperty = "Get-ItemProperty";

        /// <summary>
        /// Get-Location cmdlet.
        /// </summary>
        public const string GetLocation = "Get-Location";

        /// <summary>
        /// Get-PSDrive cmdlet.
        /// </summary>
        public const string GetPSDrive = "Get-PSDrive";

        /// <summary>
        /// Get-PSProvider cmdlet.
        /// </summary>
        public const string GetPSProvider = "Get-PSProvider";

        /// <summary>
        /// Invoke-Item cmdlet.
        /// </summary>
        public const string InvokeItem = "Invoke-Item";

        /// <summary>
        /// Join-Path cmdlet.
        /// </summary>
        public const string JoinPath = "Join-Path";

        /// <summary>
        /// Move-Item cmdlet.
        /// </summary>
        public const string MoveItem = "Move-Item";

        /// <summary>
        /// Move-ItemProperty cmdlet.
        /// </summary>
        public const string MoveItemProperty = "Move-ItemProperty";

        /// <summary>
        /// New-Item cmdlet.
        /// </summary>
        public const string NewItem = "New-Item";

        /// <summary>
        /// New-ItemProperty cmdlet.
        /// </summary>
        public const string NewItemProperty = "New-ItemProperty";

        /// <summary>
        /// New-PSDrive cmdlet.
        /// </summary>
        public const string NewPSDrive = "New-PSDrive";

        /// <summary>
        /// Pop-Location cmdlet.
        /// </summary>
        public const string PopLocation = "Pop-Location";

        /// <summary>
        /// Push-Location cmdlet.
        /// </summary>
        public const string PushLocation = "Push-Location";

        /// <summary>
        /// Remove-Item cmdlet.
        /// </summary>
        public const string RemoveItem = "Remove-Item";

        /// <summary>
        /// Remove-ItemProperty cmdlet.
        /// </summary>
        public const string RemoveItemProperty = "Remove-ItemProperty";

        /// <summary>
        /// Remove-PSDrive cmdlet.
        /// </summary>
        public const string RemovePSDrive = "Remove-PSDrive";

        /// <summary>
        /// Rename-Item cmdlet.
        /// </summary>
        public const string RenameItem = "Rename-Item";

        /// <summary>
        /// Rename-ItemProperty cmdlet.
        /// </summary>
        public const string RenameItemProperty = "Rename-ItemProperty";

        /// <summary>
        /// Resolve-Path cmdlet.
        /// </summary>
        public const string ResolvePath = "Resolve-Path";

        /// <summary>
        /// Set-Acl cmdlet.
        /// </summary>
        public const string SetAcl = "Set-Acl";

        /// <summary>
        /// Set-Content cmdlet.
        /// </summary>
        public const string SetContent = "Set-Content";

        /// <summary>
        /// Set-Item cmdlet.
        /// </summary>
        public const string SetItem = "Set-Item";

        /// <summary>
        /// Set-ItemProperty cmdlet.
        /// </summary>
        public const string SetItemProperty = "Set-ItemProperty";

        /// <summary>
        /// Set-Location cmdlet.
        /// </summary>
        public const string SetLocation = "Set-Location";

        /// <summary>
        /// Split-Path cmdlet.
        /// </summary>
        public const string SplitPath = "Split-Path";

        /// <summary>
        /// Test-Path cmdlet.
        /// </summary>
        public const string TestPath = "Test-Path";
    }
}
