
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "gamepick.h"
#include "read_line.h"
#include "click_game.h"
#include "icons.h"


const gchar* fragment (gamepick_info *info, const gchar *text)
{
  gchar *output;
  gint max_line, size, index, base, last_space;
  
  output = g_string_new (text)->str;
  max_line = info->max_line;
  size = strlen (text);
  base = 0;
  last_space = -1;
  
  for (index = 0; index < size; index++)
  {
    if (output [index] == ' ')
    {
      if (index - base > max_line)
      {
        if (last_space > base)
        {
          output [last_space] = '\n';
          base = last_space;
        }
        else
        {
          output [index] = '\n';
          base = index;
        }
      }
      last_space = index;
    }
  }

  if ((index - base > max_line) && (last_space > base))
    output [last_space] = '\n';
  
  return output;
}


void zero_game_entry (game_struct *game)
{
  game->name = g_string_new (NULL);
  game->start_dir = g_string_new (NULL);
  game->cmd = g_string_new (NULL);
  game->icon = g_string_new (NULL);
  game->fsaa = 0;
  game->aitf = 0;
  game->cmd_found = FALSE;
  game->syncvblank = FALSE;
  game->tab_pos = game->x_pos = game->y_pos = 0;
  game->icon_image = game->button = NULL;
}


gint add_tab (gamepick_info *info, const gchar* name)
{
  GtkWidget *label, *table;
  tab_struct *tab;
  
  label = gtk_label_new (name);
  gtk_widget_show (label);
  table = gtk_table_new (info->y_icons * 2, info->x_icons, FALSE);
  gtk_widget_show (table);
  gtk_container_set_border_width (GTK_CONTAINER (table), info->icon_spacing);
  gtk_table_set_row_spacings (GTK_TABLE (table), info->icon_spacing);
  gtk_table_set_col_spacings (GTK_TABLE (table), info->icon_spacing);

  gtk_notebook_append_page (GTK_NOTEBOOK (info->tabs), table, label);
  
  tab = g_malloc0 (sizeof (tab_struct));
  tab->tab_name = g_string_new (name);
  tab->box_widget = table;
  tab->game_list = NULL;
  tab->game_count = 0;
  info->tab_list = g_list_append (info->tab_list, tab);
  info->tab_count++;
  return info->tab_count - 1;
}


void pinup_game (gamepick_info *info, game_struct *game)
{
  GtkWidget *label;
  GString *icon_file;
  tab_struct *tab;
  gint x, y;
  gchar letter;

  icon_file = g_string_new (NULL);
  x = game->x_pos;
  y = game->y_pos;
  tab = (tab_struct*) g_list_nth (info->tab_list, game->tab_pos)->data;

  if (text_here (game->icon))
  {
    letter = game->icon->str [0];
    if ((letter == '/') || (letter == '.'))
      g_string_assign (icon_file, game->icon->str);
    else
      g_string_sprintf (icon_file, "%s/%s", info->icon_dir->str,
        game->icon->str);
    g_string_assign (game->icon, icon_file->str);
    game->icon_image = scaled_icon (icon_file->str, 48, 48);
    if (game->icon_image)
    {
      gtk_table_attach (GTK_TABLE (tab->box_widget), game->icon_image,
        x, x+1, y, y+1, GTK_SHRINK, GTK_SHRINK, 0, 0);
      gtk_widget_show (game->icon_image);
    }
  }
  else
    game->icon_image = NULL;
    
  game->button = gtk_button_new();
  label = gtk_label_new (fragment (info, game->name->str));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
  gtk_container_add (GTK_CONTAINER (game->button), label);
  gtk_widget_show (label);  
  gtk_button_set_relief (GTK_BUTTON (game->button), GTK_RELIEF_NONE);
  g_signal_connect (G_OBJECT (game->button), "clicked",
    G_CALLBACK (click_on_game), game); 
  gtk_table_attach (GTK_TABLE (tab->box_widget), game->button,
    x, x+1, y+1, y+2, GTK_SHRINK, GTK_SHRINK, 0, 0);
  gtk_widget_show (game->button);  
}


game_struct* add_game (gamepick_info *info, const game_struct *source, gint tab_number)
{
  game_struct *target;
  tab_struct *tab;
 
  tab = (tab_struct*) g_list_nth (info->tab_list, tab_number)->data;
  if (tab->game_count >= info->x_icons * info->y_icons)
  {
    g_print ("Too many games to add more to tab\n");
    return NULL;
  }
  
  target = g_malloc0 (sizeof (game_struct));
  target->info = info;
  target->name = g_string_new (source->name->str);
  target->start_dir = g_string_new (source->start_dir->str);
  target->cmd = g_string_new (source->cmd->str);
  target->icon = g_string_new (source->icon->str);
  target->fsaa = source->fsaa;
  target->aitf = source->aitf;
  target->syncvblank = source->syncvblank;
  target->tab_pos = tab_number;
  target->x_pos = tab->game_count % info->x_icons;
  target->y_pos = (tab->game_count / info->x_icons) * 2;
  
  pinup_game (info, target);
  tab->game_list = g_list_append (tab->game_list, target);
  tab->game_count++;
  return target;
}


void take_down_game (game_struct *game)
{
  if (game->icon_image)
    gtk_widget_destroy (game->icon_image);
  if (game->button)
    gtk_widget_destroy (game->button);
  game->icon_image = NULL;
  game->button = NULL;
}

