%%% Client for the multi-threaded server example
%%% Adapted from the sockets example
%%%

:- compiler_options([xpp_on]).
#include "socket_defs_xsb.h"
#include "char_defs.h"


:- import 
     socket/1, socket_connect/3,
     socket_close/1, socket_recv_term/2, socket_send_term/2  from hl_socket.
:- import socket_set_option/3
	from socket.

%% machine where server is running
%machine(localhost).
machine('127.0.0.1').
%% Try something else:
%%machine(compserv1).

%% Port on which the server is listening
%% Server must bind to this port
xsb_port(6500).

client :-
	writeln('started client...'),
	machine(IPAddrOrHostname),
	xsb_port(XSB_port),
	connect(Sockfd ,XSB_port, IPAddrOrHostname),
	client_loop(Sockfd).
      

client_loop(Sockfd) :-  
  nl, write('Please enter goal: g(X). or h(X).  Type e. to finish.'), 
  nl, write('Type exit. to stop the server. Goal: '), 
  read_canonical(Goal),
  ( Goal == exit ->
      socket_send_term(Sockfd, Goal), 
      socket_close(Sockfd),
      fail
  ; true
  ),
  ((Goal == 'e' ; Goal == end_of_file) ->
      !,
      socket_close(Sockfd),
      writeln('Exiting.'), true
  ;   
      nl,
      socket_send_term(Sockfd, Goal), 
      writeln('Answers: '),
      repeat,
      catch( socket_recv_term(Sockfd, Answer),
	     socket(_),
	     Answer=end_of_file
	   ),
      (Answer==end_of_file 
      -> !, true
      ;  (   Answer == 'end' 
	 ->  client_loop(Sockfd)
	 ;   
	      write('    '),
	      write(Answer), nl, 
	      fail
	  )
      )
   ).
client_loop(_).
 

 %% Open socket and connect
connect(Sockfd0,XSB_port,IPAddrOrHostname) :-
	 socket(Sockfd0),
	 socket_set_option(Sockfd0,linger,SOCK_NOLINGER),
	 socket_connect(Sockfd0, XSB_port, IPAddrOrHostname).
