/* File:      tetpitacount.P
** Author(s): Fabrizio Riguzzi and Terrance Swift
**
*/


/*

Use
:-main.
to execute the tests

*/
:-[pitacount].

epsilon(0.0001).


close_to(V,V).

main:-
	files(F),
	test_files(F),
	write('Test successful\n').
main:-
	write('Test unsuccessful.\n').

test_files([]).

test_files([H|T]) :-
	atom_concat('examples/',H,NH),
	load(NH),
	findall(f(Q,P),test(H,Q,P),L),
	test_all(H,L),
	test_files(T).

test_all(_F,[]).

test_all(F, [ f(Q,P) | T ]) :-
	fmt_write("File: %S, qeury: %S, expected explanations: %d\n",f(F,Q,P)),
	count(Q,Prob,TC,TW),!,
	fmt_write("Actual explanations: %d\nCPU time: %f Wall time: %f\n\n",f(Prob,TC,TW)),
	close_to(Prob,P),
	test_all(F,T).


files([coin2,alarm,light,mendel,hmm]).

test(alarm,alarm(t),4).

test(light,light,1).

test(hmm,hmm([a]),1).
test(hmm,hmm([a,a]),2).
test(hmm,hmm([a,a,a]),4).

test(mendel,cg(s,1,p),6).
test(mendel,cg(s,1,w),2).
test(mendel,cg(s,2,p),2).
test(mendel,cg(s,2,w),6).
test(mendel,cg(f,2,w),1).
test(mendel,cg(s,2,w),6).

test(coin2,heads(coin1),2).
test(coin2,heads(coin2),2).
test(coin2,tails(coin1),2).
test(coin2,tails(coin2),2).



