/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.util.internal.CollectionUtils;

public class DefaultBuildResult
implements BuildResult {
    private final String output;
    private final List<BuildTask> tasks;

    public DefaultBuildResult(String output, List<BuildTask> tasks) {
        this.output = output;
        this.tasks = tasks;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public List<BuildTask> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    @Override
    public List<BuildTask> tasks(final TaskOutcome outcome) {
        return Collections.unmodifiableList(CollectionUtils.filter(this.tasks, (Spec)new Spec<BuildTask>(){

            public boolean isSatisfiedBy(BuildTask element) {
                return element.getOutcome() == outcome;
            }
        }));
    }

    @Override
    public List<String> taskPaths(TaskOutcome outcome) {
        return Collections.unmodifiableList(CollectionUtils.collect(this.tasks(outcome), BuildTask::getPath));
    }

    @Override
    @Nullable
    public BuildTask task(String taskPath) {
        for (BuildTask task : this.tasks) {
            if (!task.getPath().equals(taskPath)) continue;
            return task;
        }
        return null;
    }
}

