/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.classpath.ClasspathFileHasher;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.internal.GFileUtils;

public class CopyingClasspathFileTransformer
implements ClasspathFileTransformer {
    private final GlobalCacheLocations globalCacheLocations;

    public CopyingClasspathFileTransformer(GlobalCacheLocations globalCacheLocations) {
        this.globalCacheLocations = globalCacheLocations;
    }

    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir, InstrumentingTypeRegistry typeRegistry) {
        if (sourceSnapshot.getType() != FileType.RegularFile) {
            return source;
        }
        if (this.globalCacheLocations.isInsideGlobalCache(source.getAbsolutePath())) {
            return source;
        }
        File cachedFile = new File(cacheDir, "o_" + sourceSnapshot.getHash().toString() + '/' + source.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile((File)source, (File)cachedFile);
        }
        return cachedFile;
    }

    @Override
    public ClasspathFileHasher getFileHasher() {
        return FileSystemLocationSnapshot::getHash;
    }
}

