/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.platform.win32.Wtsapi32;

public class Win32WindowDemo
implements WinUser.WindowProc {
    public Win32WindowDemo() {
        String windowClass = "MyWindowClass";
        WinDef.HMODULE hInst = Kernel32.INSTANCE.GetModuleHandle("");
        WinUser.WNDCLASSEX wClass = new WinUser.WNDCLASSEX();
        wClass.hInstance = hInst;
        wClass.lpfnWndProc = this;
        wClass.lpszClassName = windowClass;
        User32.INSTANCE.RegisterClassEx(wClass);
        this.getLastError();
        WinDef.HWND hWnd = User32.INSTANCE.CreateWindowEx(8, windowClass, "My hidden helper window, used only to catch the windows events", 0, 0, 0, 0, 0, null, null, hInst, null);
        this.getLastError();
        System.out.println("window sucessfully created! window hwnd: " + hWnd.getPointer().toString());
        Wtsapi32.INSTANCE.WTSRegisterSessionNotification(hWnd, 0);
        DBT.DEV_BROADCAST_DEVICEINTERFACE notificationFilter = new DBT.DEV_BROADCAST_DEVICEINTERFACE();
        notificationFilter.dbcc_size = notificationFilter.size();
        notificationFilter.dbcc_devicetype = 5;
        notificationFilter.dbcc_classguid = DBT.GUID_DEVINTERFACE_USB_DEVICE;
        WinUser.HDEVNOTIFY hDevNotify = User32.INSTANCE.RegisterDeviceNotification(hWnd, notificationFilter, 0);
        this.getLastError();
        if (hDevNotify != null) {
            System.out.println("RegisterDeviceNotification was sucessfully!");
        }
        WinUser.MSG msg = new WinUser.MSG();
        while (User32.INSTANCE.GetMessage(msg, hWnd, 0, 0) != 0) {
            User32.INSTANCE.TranslateMessage(msg);
            User32.INSTANCE.DispatchMessage(msg);
        }
        User32.INSTANCE.UnregisterDeviceNotification(hDevNotify);
        Wtsapi32.INSTANCE.WTSUnRegisterSessionNotification(hWnd);
        User32.INSTANCE.UnregisterClass(windowClass, hInst);
        User32.INSTANCE.DestroyWindow(hWnd);
        System.out.println("program exit!");
    }

    @Override
    public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 1: {
                this.onCreate(wParam, lParam);
                return new WinDef.LRESULT(0L);
            }
            case 2: {
                User32.INSTANCE.PostQuitMessage(0);
                return new WinDef.LRESULT(0L);
            }
            case 689: {
                this.onSessionChange(wParam, lParam);
                return new WinDef.LRESULT(0L);
            }
            case 537: {
                WinDef.LRESULT lResult = this.onDeviceChange(wParam, lParam);
                return lResult != null ? lResult : User32.INSTANCE.DefWindowProc(hwnd, uMsg, wParam, lParam);
            }
        }
        return User32.INSTANCE.DefWindowProc(hwnd, uMsg, wParam, lParam);
    }

    public final int getLastError() {
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 0) {
            System.out.println("error: " + rc);
        }
        return rc;
    }

    protected void onSessionChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 1: {
                this.onConsoleConnect(lParam.intValue());
                break;
            }
            case 2: {
                this.onConsoleDisconnect(lParam.intValue());
                break;
            }
            case 5: {
                this.onMachineLogon(lParam.intValue());
                break;
            }
            case 6: {
                this.onMachineLogoff(lParam.intValue());
                break;
            }
            case 7: {
                this.onMachineLocked(lParam.intValue());
                break;
            }
            case 8: {
                this.onMachineUnlocked(lParam.intValue());
            }
        }
    }

    protected void onConsoleConnect(int sessionId) {
        System.out.println("onConsoleConnect: " + sessionId);
    }

    protected void onConsoleDisconnect(int sessionId) {
        System.out.println("onConsoleDisconnect: " + sessionId);
    }

    protected void onMachineLocked(int sessionId) {
        System.out.println("onMachineLocked: " + sessionId);
    }

    protected void onMachineUnlocked(int sessionId) {
        System.out.println("onMachineUnlocked: " + sessionId);
    }

    protected void onMachineLogon(int sessionId) {
        System.out.println("onMachineLogon: " + sessionId);
    }

    protected void onMachineLogoff(int sessionId) {
        System.out.println("onMachineLogoff: " + sessionId);
    }

    protected WinDef.LRESULT onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 32768: {
                return this.onDeviceChangeArrival(lParam);
            }
            case 32772: {
                return this.onDeviceChangeRemoveComplete(lParam);
            }
            case 7: {
                return this.onDeviceChangeNodesChanged();
            }
        }
        System.out.println("Message WM_DEVICECHANGE message received, value unhandled.");
        return null;
    }

    protected WinDef.LRESULT onDeviceChangeArrivalOrRemoveComplete(WinDef.LPARAM lParam, String action) {
        DBT.DEV_BROADCAST_HDR bhdr = new DBT.DEV_BROADCAST_HDR(lParam.longValue());
        switch (bhdr.dbch_devicetype) {
            case 5: {
                DBT.DEV_BROADCAST_DEVICEINTERFACE bdif = new DBT.DEV_BROADCAST_DEVICEINTERFACE(bhdr.getPointer());
                System.out.println("BROADCAST_DEVICEINTERFACE: " + action);
                System.out.println("dbcc_devicetype: " + bdif.dbcc_devicetype);
                System.out.println("dbcc_name:       " + bdif.getDbcc_name());
                System.out.println("dbcc_classguid:  " + bdif.dbcc_classguid.toGuidString());
                break;
            }
            case 6: {
                DBT.DEV_BROADCAST_HANDLE bhd = new DBT.DEV_BROADCAST_HANDLE(bhdr.getPointer());
                System.out.println("BROADCAST_HANDLE: " + action);
                break;
            }
            case 0: {
                DBT.DEV_BROADCAST_OEM boem = new DBT.DEV_BROADCAST_OEM(bhdr.getPointer());
                System.out.println("BROADCAST_OEM: " + action);
                break;
            }
            case 3: {
                DBT.DEV_BROADCAST_PORT bpt = new DBT.DEV_BROADCAST_PORT(bhdr.getPointer());
                System.out.println("BROADCAST_PORT:  " + action);
                System.out.println("dbcp_devicetype: " + bpt.dbcp_devicetype);
                System.out.println("dbcp_name:       " + bpt.getDbcpName());
                break;
            }
            case 2: {
                DBT.DEV_BROADCAST_VOLUME bvl = new DBT.DEV_BROADCAST_VOLUME(bhdr.getPointer());
                int logicalDriveAffected = bvl.dbcv_unitmask;
                short flag = bvl.dbcv_flags;
                boolean isMediaNotPhysical = 0 != (flag & 1);
                boolean isNet = 0 != (flag & 2);
                System.out.println(action);
                int driveLetterIndex = 0;
                while (logicalDriveAffected != 0) {
                    if (0 != (logicalDriveAffected & 1)) {
                        System.out.println("Logical Drive Letter: " + (char)(65 + driveLetterIndex));
                    }
                    logicalDriveAffected >>>= 1;
                    ++driveLetterIndex;
                }
                System.out.println("isMediaNotPhysical:" + isMediaNotPhysical);
                System.out.println("isNet:" + isNet);
                break;
            }
            default: {
                return null;
            }
        }
        return new WinDef.LRESULT(1L);
    }

    protected WinDef.LRESULT onDeviceChangeArrival(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "Arrival");
    }

    protected WinDef.LRESULT onDeviceChangeRemoveComplete(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "Remove Complete");
    }

    protected WinDef.LRESULT onDeviceChangeNodesChanged() {
        System.out.println("Message DBT_DEVNODES_CHANGED");
        return new WinDef.LRESULT(1L);
    }

    protected void onCreate(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        System.out.println("onCreate: WM_CREATE");
    }

    public static void main(String[] args) {
        new Win32WindowDemo();
    }
}

