use lib '../lib';
use strict;
use Test::More tests => 9;

my $TJSIM = "../../tjsim";
my $PATH = "--path church/";
my $MODULE = "church";
my $code;
my $ans;


############################################
############################################
$code = <<'CODE';
cn 30 A, cn 87 B, plus P, (P A B) = X.

CODE
$ans = <<'ANS';

The answer substitution:
X = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
P = W1\ W2\ W3\ W4\ W1 W3 (W2 W3 W4)
B = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
$code = <<'CODE';
cn 12 A, mult M, X = (M A A).

CODE
$ans = <<'ANS';

The answer substitution:
X = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
M = W1\ W2\ W3\ W4\ W1 (W2 W3) W4
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
$code = <<'CODE';
cn 14 A, cn 17 B, cn 8 C, (P B (M A C)) = D.

CODE
$ans = <<'ANS';

The answer substitution:
D = P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))) (M (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))) (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))
M = M
P = P
C = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))
B = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################

$code = <<'CODE';
cn 70 A, cn 50 B, cn 60 C, (P A (P B (P A (P C B)))) = U.

CODE
$ans = <<'ANS';

The answer substitution:
U = P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))
P = P
C = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
B = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))


ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################

$code = <<'CODE';
cn 70 A, cn 50 B, cn 60 C, (M A (P B (P A (P C B)))) = U.

CODE
$ans = <<'ANS';

The answer substitution:
U = M (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))
P = P
M = M
C = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
B = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
$code = <<'CODE';
cn 39 N, plus P, X = (P N (P N N)).

CODE
$ans = <<'ANS';

The answer substitution:
X = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
P = W1\ W2\ W3\ W4\ W1 W3 (W2 W3 W4)
N = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))))))))))))))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
$code = <<'CODE';
cn 50 A, cn 5 B, cn 19 C, X = (M A (P C B)).

CODE
$ans = <<'ANS';

The answer substitution:
P = P
M = M
X = M (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))) (P (W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))) (W1\ W2\ W1 (W1 (W1 (W1 (W1 W2))))))
C = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2))))))))))))))))))
B = W1\ W2\ W1 (W1 (W1 (W1 (W1 W2))))
A = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
$code = <<'CODE';
mult M, cn 2 T, X = (M T (M T (M T (M T (M T (M T ( M T (M T T)))))))).

CODE
$ans = <<'ANS';

The answer substitution:
X = W1\ W2\ W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 (W1 W2)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
T = W1\ W2\ W1 (W1 W2)
M = W1\ W2\ W3\ W4\ W1 (W2 W3) W4

ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");

############################################
############################################
# the binding of variables are two large to be input into the test file

$code = <<'CODE';
test 9.

CODE
$ans = <<'ANS';
ANS
same_answers( `$TJSIM -b $PATH --solve "$code" $MODULE\n`, $ans,"test");
############################################
############################################