/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "coord.h"

coord coord::pc (int _x, int _y)
{
  return coord ((double)_x, (double)_y);
}

coord coord::tc (int _x, int _y)
{
  coord tmp ((double) (_x * TILE_WIDTH), (double) (_y*TILE_HEIGHT));
  return tmp;
}

coord::coord (double _x, double _y)
{
  x = _x;
  y = _y;
}

coord::coord()
{
  x = 0.0;
  y = 0.0;
}


coord::coord(const coord &c)
{
  x = c.x;
  y = c.y;
}

double coord::dist (const coord &c) const
{
  double dx = (x - c.x) * (x - c.x);
  double dy = (y - c.y) * (y - c.y);
  return sqrt (dx + dy);
}

double coord::len () const
{
  return sqrt ((x*x) + (y*y));
}

coord coord::operator- (const coord &c) const
{
  coord a(x-c.x, y-c.y);
  return a;
}

coord coord::operator+ (const coord &c) const
{
  coord a(x+c.x, y+c.y);
  return a;
}

coord& coord::operator-= (const coord &c)
{
  x -= c.x;
  y -= c.y;
  return *this;
}

coord& coord::operator+= (const coord &c)
{
  x += c.x;
  y += c.y;
  return *this;
}

coord& coord::operator= (const coord &c)
{
  x = c.x;
  y = c.y;
  return *this;
}

bool coord::operator== (const coord &c) const
{
  if (x != c.x) return false;
  if (y != c.y) return false;
  return true;
}

bool coord::operator!= (const coord &c) const
{
  return !operator==(c);
}


coord coord::operator/ (double scalar) const
{
  assert (scalar != 0.0);
  coord c (x / scalar, y / scalar);
  return c;
}

coord coord::operator* (double scalar) const
{
  coord c (x*scalar, y*scalar);
  return c;
}

coord& coord::operator*= (double am)
{
  x = x * am;
  y = y * am;
  return *this;
}

int coord::getPX() const
{
  return (int) x;
}

int coord::getPY() const
{
  return (int) y;
}

int coord::getTX() const
{
  return ((int)x )/ TILE_WIDTH;
}

int coord::getTY() const
{
  return ((int)y )/ TILE_HEIGHT;
}

void coord::setPX(int val)
{
  x = (double) val;
}

void coord::setPY(int val)
{
  y = (double) val;
}

void coord::setTX(int val)
{
  x = ((double) val) * TILE_WIDTH;
}

void coord::setTY(int val)
{
  y = ((double) val) * TILE_HEIGHT;
}

void coord::incTX()
{
  x += (double) TILE_WIDTH;
}
void coord::incTY()
{
  y += (double) TILE_HEIGHT;
}
void coord::decTX()
{
  x-= (double) TILE_WIDTH;
}
void coord::decTY()
{
  y -= (double) TILE_HEIGHT;
}

void coord::incPX()
{
  x++;
}
void coord::incPY()
{
  y++;
}
void coord::decPX()
{
  x--;
}
void coord::decPY()
{
  y--;
}


void coord::addPX(double am)
{
  x+=am;
}

void coord::addPY(double am)
{
  y+=am;
}
void coord::addTX(int am)
{
  x += (double) TILE_WIDTH * am;
}

void coord::addTY(int am)
{
  y += (double) TILE_HEIGHT*am;
}

void coord::subPX(double am)
{
  x -= am;
}
void coord::subPY(double am)
{
  y -= am;
}

void coord::subTX(int am)
{
  x -= (double) TILE_WIDTH*am;

}
void coord::subTY(int am)
{
  y -= (double) TILE_HEIGHT*am;
    
}

bool coord::tile_eq (const coord &ot)
{
  if (getTX() != ot.getTX()) return false;
  if (getTY() != ot.getTY()) return false;
  return true;
}
