/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gfx.h"

// Graphics for player_indexes 4 is for default (OWNER_NOONE)
const char* const gfx::tile_files[][NUM_TILES] = 
  {

  {
	"0castle.png",
	"0wall.png",
	"0cannon.png",
	"0big_cannon.png",
	"0conquered_grass.png",
	"0ammo.png",
	"0big_ammo.png",
	"0blockplacer.png",
	"0cannonplacer.png",
	"0big_cannonplacer.png",
	"0chooser.png",
	"0cursor.png",
	"0cannon_dest.png",
	"0big_cannon_dest.png",
	"0cursor_lock.png",
	"0face.png",
	"0cursor_ch.png"
  },
  {
	"1castle.png",
	"1wall.png",
	"1cannon.png",
	"1big_cannon.png",
	"1conquered_grass.png",
	"1ammo.png",
	"1big_ammo.png",
	"1blockplacer.png",
	"1cannonplacer.png",
	"1big_cannonplacer.png",
	"1chooser.png",
	"1cursor.png",
	"1cannon_dest.png",
	"1big_cannon_dest.png",
	"1cursor_lock.png",
	"1face.png",
	"1cursor_ch.png"
  },
  {
	"2castle.png",
	"2wall.png",
	"2cannon.png",
	"2big_cannon.png",
	"2conquered_grass.png",
	"2ammo.png",
	"2big_ammo.png",
	"2blockplacer.png",
	"2cannonplacer.png",
	"2big_cannonplacer.png",
	"2chooser.png",
	"2cursor.png",
	"2cannon_dest.png",
	"2big_cannon_dest.png",
	"2cursor_lock.png",
	"2face.png",
	"2cursor_ch.png"
  },
  {
	"3castle.png",
	"3wall.png",
	"3cannon.png",
	"3big_cannon.png",
	"3conquered_grass.png",
	"3ammo.png",
	"3big_ammo.png",
	"3blockplacer.png",
	"3cannonplacer.png",
	"3big_cannonplacer.png",
	"3chooser.png",
	"3cursor.png",
	"3cannon_dest.png",
	"3big_cannon_dest.png",
	"3cursor_lock.png",
	"3face.png",
	"3cursor_ch.png"
  },
  {
	"4castle.png",
	"4wall.png",
	"4cannon.png",
	"4big_cannon.png",
	"4conquered_grass.png",
	"4ammo.png",
	"4big_ammo.png",
	"4blockplacer.png",
	"4cannonplacer.png",
	"4big_cannonplacer.png",
	"4chooser.png",
	"4cursor.png",
	"4cannon_dest.png",
	"4big_cannon_dest.png",
	"4cursor_lock.png",
	"4face.png",
	"4cursor_ch.png"
  }
  };

gfx::~gfx()
{
  // free tiles
  for (int p=0; p<NUM_TILEPACKS;p++)
  {
    for (int i=0;i<NUM_TILES;i++)
	  SDL_FreeSurface (tiles[p][i]);
  }

  // free other surfaces
  SDL_FreeSurface (bg_image);
  SDL_FreeSurface (play_bg);

  delete lut;
  delete exp_anims;
  delete ammo_anims;
  delete big_ammo_anims;
}


gfx::gfx(SDL_Surface *_screen, TTF_Font *_font)
{
  font = _font;
  screen = _screen;

  // init lookup tables
  lut = new lookup();

  // init buffers to same size & type as screen
  bg_image = copy_surface (screen);
  play_bg = copy_surface (screen);

  // init explosion efects
  exp_anims = new exp_anim_container();
  //  printf ("Explosions initialised.\n");

  // load bg image & blit it to back buffer
  SDL_Surface * img = img_load (BG_IMAGE);
  
  if (!img)
	{
	  fprintf (stderr, "Error loading image: %s\n", BG_IMAGE);
	  exit (1);
	}

  // blit loaded img to given surf & free it
  SDL_BlitSurface (img, NULL, bg_image, NULL);
  SDL_FreeSurface (img);

  // load game tiles
  for(int p=0;p<NUM_TILEPACKS;p++)
  {
  for (int i=0;i<NUM_TILES;i++)
	{
	  //	  printf ("Loading tile %s\n", tile_files[p][i]);
	  SDL_Surface *s = img_load (tile_files[p][i]);
	  if (s == NULL)
	    {
	      fprintf (stderr, "Error loading image %s: %s\n", tile_files[p][i], IMG_GetError());
	      exit (1);
	    }
	  tiles[p][i] = s;
	}
  }
  //  printf ("Graphics tiles loaded\n");
  // init ammo animations
  SDL_Surface *ang[MAX_PLAYERS];
  for (int i=0;i<MAX_PLAYERS;i++)
    ang[i] = tiles[i][TILEINDEX_AMMO];

  ammo_anims = new ammo_anim_container(ang);

  //big ammo
  SDL_Surface *angg[MAX_PLAYERS];
  for (int i=0;i<MAX_PLAYERS;i++)
    angg[i] = tiles[i][TILEINDEX_BIG_AMMO];

  big_ammo_anims = new ammo_anim_container(angg);

  // show background .. NO WE DON't SHOW IT ANYMORE!
  //  SDL_BlitSurface (bg_image, NULL, screen, NULL);
  //SDL_Flip (screen);
  //  printf ("Background shown set\n");
}


void gfx::draw_bg (terrain *t, player *players)
{
  // first, draw the background image to play_bg
  SDL_BlitSurface (bg_image, NULL, play_bg, NULL);

  // then draw all the tiles TO IT
  for (int y=0;y<YTILES;y++)
	for (int x=0;x<XTILES;x++)
	  {
	    coord c=coord::tc (x,y);
	    tile ti  = t->get_tile (c);
	    
	    int owner=ti.owner;
	    if(owner==OWNER_NOONE)
	      {
		switch (ti.type)
		  {
		  case tile::TYPE_EMPTY:
		    if (ti.conquered)
		      draw_tile (tiles[owner][TILEINDEX_CONQGRASS], play_bg, c);
		    break;
		    break;
		  case tile::TYPE_CASTLE_A:
		    break;
		  case tile::TYPE_CASTLE_C:
		    // blit it!
		    draw_centered_to_tile (tiles[owner][TILEINDEX_CASTLE], play_bg, c);
		    break;
		  case tile::TYPE_WALL:
		    // blit it!
		    draw_tile(tiles[owner][TILEINDEX_WALL], play_bg, c);
		    break;
		  case tile::TYPE_CANNON_A:
		    break;
		  case tile::TYPE_BIG_CANNON_A:
		    break;
		  case tile::TYPE_CANNON_C:
		    draw_tile (tiles[owner][TILEINDEX_CANNON], play_bg, c);
		    break;
		  case tile::TYPE_CANNON_C_DEST:
		    draw_tile (tiles[owner][TILEINDEX_CANNON_DEST], play_bg, c);
		    break;
		  case tile::TYPE_BIG_CANNON_C:
		    draw_tile (tiles[owner][TILEINDEX_BIG_CANNON], play_bg, c);
		    break;
		  case tile::TYPE_BIG_CANNON_C_DEST:
		    draw_tile (tiles[owner][TILEINDEX_BIG_CANNON_DEST], play_bg, c);
		    break;
		  }
	      }
	    else
	      {
		
		switch (ti.type)
		  {
		  case tile::TYPE_EMPTY:
		    if (ti.conquered)
		      draw_tile (tiles[players[owner].get_character()][TILEINDEX_CONQGRASS], play_bg, c);
		    break;
		    break;
		  case tile::TYPE_CASTLE_A:
		    break;
		  case tile::TYPE_CASTLE_C:
		    // blit it!
		    draw_centered_to_tile (tiles[players[owner].get_character()][TILEINDEX_CASTLE], play_bg, c);
		    break;
		  case tile::TYPE_WALL:
		    // blit it!
		    draw_tile(tiles[players[owner].get_character()][TILEINDEX_WALL], play_bg, c);
		    break;
		  case tile::TYPE_CANNON_A:
		    break;
		  case tile::TYPE_CANNON_C:
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_CANNON], play_bg, c);
		    break;
		  case tile::TYPE_CANNON_C_DEST:
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_CANNON_DEST], play_bg, c);
		    break;
		  case tile::TYPE_BIG_CANNON_A:
		    break;
		  case tile::TYPE_BIG_CANNON_C:
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_BIG_CANNON], play_bg, c);
		    break;
		  case tile::TYPE_BIG_CANNON_C_DEST:
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_BIG_CANNON_DEST], play_bg, c);
		    break;
		  }
	      }
	  }
  clear_updates(t);
  // finally, blit the play_bg to screen

  draw_fademask(play_bg);
  SDL_BlitSurface (play_bg, NULL, screen, NULL);
}

void gfx::draw_fademask(SDL_Surface *s)
{
  // if fademask, draw it
  if (fademask)
    {
      SDL_Surface *tmps = copy_surface(screen);
      Uint32 col = fademask_towhite ? 0xFFFFFF : 0;
      SDL_FillRect (tmps, NULL, col);
      Uint8 am = (Uint8) (255.0 * fademask_intensity);
      SDL_SetAlpha (tmps, SDL_SRCALPHA | SDL_RLEACCEL, am);
      SDL_BlitSurface (tmps, NULL, s, NULL);
      SDL_FreeSurface(tmps);      
    }
}

void gfx::set_bg_fademask(bool towhite, double intensity)
{
  assert(intensity >= 0.0 && intensity <= 1.0);
  fademask = true;
  fademask_towhite = towhite;
  fademask_intensity = intensity;
}

void gfx::update()
{
  SDL_Flip(screen);
  // FROM NOW ON WE USE DOUBLE-BUFFERED SDL SCREEN DIRECTLY! -tommi / 14.7.2003
}
void gfx::draw_characters(int max_players)
{

  for (int i=0;i<max_players;i++)
    {
      //kasvokuvat on 80x80
      coord c = coord::tc(20+i*8,10);
	draw_centered_to_tile (tiles[i][TILEINDEX_FACE],screen, c);
    }
}
  
void gfx::draw_cursors(coord *curs, int max_players, bool* lock, int num_cannons,int  player_index, player *players)
{
  for (int i=0;i<max_players;i++)
	if (curs[i].getPX() >= 0)
	  {
	    if(lock[i]==true)
	      draw_centered_to_pixel (tiles[players[i].get_character()][TILEINDEX_CURSOR_LOCK], curs[i]);
	    else
	      draw_centered_to_pixel (tiles[players[i].get_character()][TILEINDEX_CURSOR], curs[i]);

	  //tss piirretn lukumr, muutetaan HUDiin, kun semmonen saadaan aikaan
	    if(player_index == i)
	      {
		coord co = coord::pc(10+curs[i].getPX(), curs[i].getPY());
		draw_hud(num_cannons,-1,co);
		/*
		char mess[10];
		sprintf(mess,"%i",num_cannons);
		draw_text_baseline (screen, font, mess,co);
		*/
	      }
	  }
}

void gfx::draw_centered_to_tile(SDL_Surface *surf, SDL_Surface *dsurf, coord &c)
{
  SDL_Rect r;

  r.x = c.getPX() + (Sint16) ((TILE_WIDTH*0.5f) - (surf->w / 2.0f));
  r.y = c.getPY() + (Sint16) ((TILE_HEIGHT*0.5f) - (surf->h / 2.0f));

  SDL_BlitSurface (surf, NULL, dsurf, &r);

  r.w = surf->w;
  r.h = surf->h;
}

void gfx::draw_castle_ownertext(player &pl, const coord &cc)
{
  coord d = cc;
  if (cc.getPX() <= SCR_WIDTH / 2 && cc.getPY() <= SCR_WIDTH / 2) // first quarter
    {
      d.addTX(2);
      d.addTY(2);
      SDL_Color col = pl.get_color();
      draw_text (screen, font, pl.get_name().c_str(), d, col);
    }
  else if (cc.getPX() <= SCR_WIDTH / 2) // 2nd
    {
      d.addTX(2);
      d.subTY(2);
      SDL_Color col = pl.get_color();
      draw_text_baseline (screen, font, pl.get_name().c_str(), d, col);
    }
  else if (cc.getPX() >= SCR_WIDTH / 2 && cc.getPY() >= SCR_WIDTH / 2) // 3rd
    {
      d.subTX(2);
      d.subTY(2);
      SDL_Color col = pl.get_color();
      draw_text_baseline (screen, font, pl.get_name().c_str(), d, col);
    }
  else
    {
      d.subTX(2);
      d.addTY(2);
      SDL_Color col = pl.get_color();
      draw_text (screen, font, pl.get_name().c_str(), d, col);
    }
}

void gfx::draw_castlechoosers (coord *centers, player *players, int max_num)
{
  for (int i=0;i<max_num;i++)
    {
      if (centers[i].getPX() < 0)
	continue;
      coord &cc = centers[i];
      draw_centered_to_tile (tiles[players[i].get_character()][TILEINDEX_CHOOSER], screen, cc);
      draw_castle_ownertext (players[i], cc);
    }
}

void gfx::draw_characterchoosers (coord *centers, player *players, int max_num, bool* lock)
{
  for (int i=0;i<max_num;i++)
    {
      if (centers[i].getPX() < 0)
	continue;
      coord &cc = centers[i];

      if(lock[i])
	{
	  draw_centered_to_tile (tiles[i][TILEINDEX_CURSOR_CH], screen, cc);
	  //SDL_Surface *surf = copy_surface(tiles[i][TILEINDEX_CURSOR_CH]);
	  SDL_Surface *surf=SDL_CreateRGBSurface(SDL_SWSURFACE, 80, 80, play_bg->format->BitsPerPixel, play_bg->format->Rmask, play_bg->format->Gmask, play_bg->format->Bmask, play_bg->format->Amask);


	  Uint8 red, green, blue;
	  red=0;
	  green=0;
	  blue=0;

	  Uint32 vari=SDL_MapRGB(surf->format,red,green,blue);

	  SDL_Rect r;
	  r.x = 0;
	  r.y = 0;
	  r.w=surf->w;
	  r.h=surf->h;
	  SDL_FillRect(surf,&r,vari);

	  
	  if(SDL_SetAlpha(surf, SDL_SRCALPHA,150)==-1)
	    printf("virhe alphan laitossa\n");
	  //SDL_BlitSurface(surf,NULL, screen, &r);
	  draw_centered_to_tile (surf, screen, cc);
	  SDL_FreeSurface(surf);
	}
      else
      draw_centered_to_tile (tiles[i][TILEINDEX_CURSOR_CH], screen, cc);
      //draw_castle_ownertext (players[i], cc);
    }
}

void gfx::draw_cannonplacers(terrain* t, coord* pcoord, int maxnum, player *players, int* c_size)
{
  for (int i=0;i<maxnum;i++)
	{
	  if (players[i].get_kredits() < 1)
		continue;
	  if(c_size[i]==NORMAL)
	    draw_tile (tiles[players[i].get_character()][TILEINDEX_CANNONPLACER], screen, pcoord[i]);
	  else
	    draw_tile (tiles[players[i].get_character()][TILEINDEX_BIG_CANNONPLACER], screen, pcoord[i]);

	  int cost = 0;
	  if(c_size[i]==NORMAL)
	    cost = CANNON_COST;
	  else
	    cost = BIG_CANNON_COST;


	  coord cc = coord::pc(20+pcoord[i].getPX(), 12+pcoord[i].getPY());
	  draw_hud(players[i].get_kredits(),cost,cc);

	  /*
	  //coorinate for kredits / cost txt
	  coord cc = coord::pc(20+pcoord[i].getPX(), 12+pcoord[i].getPY());

	  //adjust the text depending if the txt goes out of the screen	  
	  coord d = cc;
	  if (cc.getPX() > SCR_WIDTH - 120)
	    d.subTX(13);

	  char mess[20];
	  sprintf(mess,"%i / %i",players[i].get_kredits(),cost);
	  draw_text_baseline (screen, font, mess,d);
	  */
	  
	  
	  
	  
	  
	}
}

void gfx::draw_blockplacers (block *bp, int max_players, player *players)
{
  for (int i=0;i<max_players;i++)
	{
	  block &b = bp[i];
	  const coord &c = b.get_center();
	  if (c.getPX() <0) continue; // this blockplacer not in use.

	  const vector<coord> &t = b.get_tiles();
	  vector<coord>::const_iterator it = t.begin();

	  while (it != t.end())
		{
		  coord tc = *it + c;
		  draw_tile (tiles[players[i].get_character()][TILEINDEX_BLOCKPLACER], screen, tc);
		  it++;
		}


	  coord cc = coord::pc(20+c.getPX(), 12+c.getPY());
	  draw_hud(players[i].get_kredits(),BLOCK_COST,cc);

	  /*
	  //coorinate for kredits / cost txt
	  coord cc = coord::pc(20+c.getPX(), 12+c.getPY());

	  //adjust the text depending if the txt goes out of the screen	  
	  coord d = cc;
	  if (cc.getPX() > SCR_WIDTH - 120)
	    d.subTX(13);

	  char mess[20];
	  sprintf(mess,"%i / %i",players[i].get_kredits(),BLOCK_COST);
	  draw_text_baseline (screen, font, mess,d);
	  */
	}
}

void gfx::draw_hud (int n1, int n2, const coord &c)
{
  //fadebox width
  int wi = 27;
  if(n1>9)
    wi+=10;
  if(n1>99)
    wi+=10;
  if(n2==-1)
    wi-=17;
  if(n2>9)
    wi+=10;
  if(n2>99)
    wi+=10;

  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY()-13;
  r.w = wi;
  r.h = 13;
  
  draw_fadebox (0.75, &r, screen);

  if(n2 == -1)
    {
      char mess[10];
      sprintf(mess,"%i",n1);
      draw_text_baseline (screen, font, mess,c);
    }
  else
    {
      
      char mess[20];
      sprintf(mess,"%i / %i",n1,n2);
      draw_text_baseline (screen, font, mess,c);
    }
}


void gfx::draw_centered_to_pixel (SDL_Surface *surf, const coord &c)
{
  //assert (x >= 0 && y >= 0 && x < terrain::SCR_WIDTH && y < terrain::SCR_HEIGHT);
  // assert vrin
  SDL_Rect r;
  r.x = c.getPX() - (surf->w/2);
  r.y = c.getPY() - (surf->h/2);
  SDL_BlitSurface (surf, NULL, screen, &r);

  //  r.w = surf->w;
  //r.h = surf->h;

}

void gfx::draw_tile (SDL_Surface *surf, SDL_Surface *dest_surf, coord &c)
{
  //assert (c.x >= 0 && c.y >= 0 && c.x < XTILES && c.y < YTILES); // pzq 
  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY();
  SDL_BlitSurface (surf, NULL, dest_surf, &r);

  r.w = surf->w;
  r.h = surf->h;
}


void gfx::update_bg (terrain *terra, player *players,bool keep_castlegfx, bool keep_cannongfx)
{
  SDL_Rect sr;
  SDL_Rect dr;

  // draw tiles to background. also add to rects_to_update.
  vector<coord> tiles_to_update = terra->get_changed_tiles();
  vector<coord>::iterator it = tiles_to_update.begin();
  while (it != tiles_to_update.end())
	{
	  coord c = *it++;

	  tile ti = terra->get_tile (c);

	  int owner=ti.owner;
	  
	  // first, clear with BG img
	  if (ti.type == tile::TYPE_CANNON_C || ti.type == tile::TYPE_CANNON_C_DEST)
	    {
	      sr.x = c.getPX();
	      sr.y = c.getPY();
	      sr.w = TILE_WIDTH*2;
	      sr.h = TILE_HEIGHT*2;
	      
	      dr.x = sr.x;
	      dr.y = sr.y;
	    }
	  else if (ti.type == tile::TYPE_BIG_CANNON_C || ti.type == tile::TYPE_BIG_CANNON_C_DEST)
	    {
	      sr.x = c.getPX();
	      sr.y = c.getPY();
	      sr.w = TILE_WIDTH*3;
	      sr.h = TILE_HEIGHT*3;
	      
	      dr.x = sr.x;
	      dr.y = sr.y;
	    }
	  else if (ti.type == tile::TYPE_CASTLE_C)
	    {
	      sr.x = c.getPX()- TILE_WIDTH;
	      sr.y = c.getPY()- TILE_HEIGHT;
	      sr.w = TILE_WIDTH*3;
	      sr.h = TILE_HEIGHT*3;
	      
	      dr.x = sr.x;
	      dr.y = sr.y;
	    }
	  else
	    {
	      sr.x = c.getPX();
	      sr.y = c.getPY();
	      sr.w = TILE_WIDTH;
	      sr.h = TILE_HEIGHT;
	      
	      dr.x = sr.x;
	      dr.y = sr.y;
	    }

	  if (!(ti.type == tile::TYPE_CANNON_A ||  ti.type == tile::TYPE_CANNON_A_DEST ||
		ti.type == tile::TYPE_CASTLE_A || ti.type==tile::TYPE_BIG_CANNON_A || ti.type==tile::TYPE_BIG_CANNON_A_DEST || (ti.type==tile::TYPE_BIG_CANNON_C && keep_cannongfx) ||
		(ti.type == tile::TYPE_CANNON_C && keep_cannongfx) ||
		//		(ti.type == tile::TYPE_CANNON_C_DEST) ||
		(ti.type == tile::TYPE_CASTLE_C && keep_castlegfx && ti.owner == OWNER_NOONE)
		)
	      )
	    SDL_BlitSurface (bg_image, &sr, play_bg, &dr);

	  
	  if(owner==OWNER_NOONE)
	    {
	      switch (ti.type)
		{
		case tile::TYPE_EMPTY:
		  if (ti.conquered)
		    draw_tile (tiles[owner][TILEINDEX_CONQGRASS], play_bg, c);
		  break;
		case tile::TYPE_WALL:
		  draw_tile(tiles[owner][TILEINDEX_WALL], play_bg, c);
		  break;
		case tile::TYPE_CANNON_A:
		  break;
		case tile::TYPE_CANNON_C:
		  if (!keep_cannongfx)
		    draw_tile (tiles[owner][TILEINDEX_CANNON], play_bg, c);
		  break;
		case tile::TYPE_CANNON_A_DEST:
		  break;
		case tile::TYPE_CANNON_C_DEST:
		  draw_tile (tiles[owner][TILEINDEX_CANNON_DEST], play_bg, c);
		  break;
		case tile::TYPE_BIG_CANNON_A:
		  break;
		case tile::TYPE_BIG_CANNON_C:
		  if (!keep_cannongfx)
		    draw_tile (tiles[owner][TILEINDEX_BIG_CANNON], play_bg, c);
		  break;
		case tile::TYPE_BIG_CANNON_A_DEST:
		  break;
		case tile::TYPE_BIG_CANNON_C_DEST:
		  draw_tile (tiles[owner][TILEINDEX_BIG_CANNON_DEST], play_bg, c);
		  break;
		case tile::TYPE_CASTLE_A:
		  break;
		case tile::TYPE_CASTLE_C:
		  if (!keep_castlegfx || ti.owner != OWNER_NOONE)
		    draw_centered_to_tile (tiles[owner][TILEINDEX_CASTLE], play_bg, c);
		  break;
		}
	    }
	  else
	    {
	      switch (ti.type)
		{
		case tile::TYPE_EMPTY:
		  if (ti.conquered)
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_CONQGRASS], play_bg, c);
		  break;
		case tile::TYPE_WALL:
		  draw_tile(tiles[players[owner].get_character()][TILEINDEX_WALL], play_bg, c);
		  break;
		case tile::TYPE_CANNON_A:
		  break;
		case tile::TYPE_CANNON_C:
		  if (!keep_cannongfx)
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_CANNON], play_bg, c);
		  break;
		case tile::TYPE_CANNON_A_DEST:
		  break;
		case tile::TYPE_CANNON_C_DEST:
		  draw_tile (tiles[players[owner].get_character()][TILEINDEX_CANNON_DEST], play_bg, c);
		  break;
		case tile::TYPE_BIG_CANNON_A:
		  break;
		case tile::TYPE_BIG_CANNON_C:
		  if (!keep_cannongfx)
		    draw_tile (tiles[players[owner].get_character()][TILEINDEX_BIG_CANNON], play_bg, c);
		  break;
		case tile::TYPE_BIG_CANNON_A_DEST:
		  break;
		case tile::TYPE_BIG_CANNON_C_DEST:
		  draw_tile (tiles[players[owner].get_character()][TILEINDEX_BIG_CANNON_DEST], play_bg, c);
		  break;
		case tile::TYPE_CASTLE_A:
		  break;
		case tile::TYPE_CASTLE_C:
		  if (!keep_castlegfx || ti.owner != OWNER_NOONE)
		    draw_centered_to_tile (tiles[players[owner].get_character()][TILEINDEX_CASTLE], play_bg, c);
		  break;
		}
	    }
	}
  if (tiles_to_update.size() > 0)
    draw_fademask(play_bg);
  // finally, blit the play_bg to screen
  SDL_BlitSurface (play_bg, NULL, screen, NULL);
}

void gfx::unset_bg_fademask()
{
  fademask = false;
}

void gfx::clear_updates(terrain *terra)
{
  terra->get_changed_tiles();
}

void gfx::draw_player_statistics(player * players, vector<player_statistic*> *stats, const coord &from)
{
  char txt[NAME_MAXLEN+20];  
  coord pos = from;

  vector<coord> vc (MAX_PLAYERS);
  for (unsigned int i=0;i<MAX_PLAYERS;i++)
    vc[i] = coord::pc(0,0);

  for (unsigned int i=0;i<stats->size();i++)
    {
      player_statistic *p = stats->at(i);
      sprintf(txt, "%s:  ", players[p->get_id()].get_name().c_str());
      SDL_Color c = players[p->get_id()].get_color();
      SDL_Rect r = draw_text(screen, font, txt, pos, c);
      vc[p->get_id()] = pos + coord::pc(r.w, 0);
      pos += coord::pc(0, r.h);
    }
  pos = coord::pc(0,0);
  for (unsigned int i=0;i<vc.size();i++)
    {
      if (vc[i].getPX() > pos.getPX())
	pos = vc[i];
    }
  // draw shots  
  for (unsigned int i=0;i<stats->size();i++)
    {
      player_statistic *p = stats->at(i);
      pos.setPY(vc[p->get_id()].getPY());
      sprintf(txt, "shots: %d  ", p->get_all_shots());
      SDL_Color c = players[p->get_id()].get_color();
      SDL_Rect r = draw_text(screen, font, txt, pos, c);
      vc[p->get_id()] = pos + coord::pc(r.w, 0);
      pos+= coord::pc(0, r.h);
    }
  pos = coord::pc(0,0);
  for (unsigned int i=0;i<vc.size();i++)
    {
      if (vc[i].getPX() > pos.getPX())
	pos = vc[i];
    }
  // draw accuracy
  for (unsigned int i=0;i<stats->size();i++)
    {
      player_statistic *p = stats->at(i);
      pos.setPY(vc[p->get_id()].getPY());
      sprintf(txt, "accuracy: %.2f  ", p->get_hit_percent());
      SDL_Color c = players[p->get_id()].get_color();
      SDL_Rect r = draw_text(screen, font, txt, pos, c);
      vc[p->get_id()] = pos + coord::pc(r.w, 0);
      pos+= coord::pc(0, r.h);
    }
  pos = coord::pc(0,0);
  for (unsigned int i=0;i<vc.size();i++)
    {
      if (vc[i].getPX() > pos.getPX())
	pos = vc[i];
    }
  // draw cannon hits
  for (unsigned int i=0;i<stats->size();i++)
    {
      player_statistic *p = stats->at(i);
      pos.setPY(vc[p->get_id()].getPY());
      sprintf(txt, "cannon hits: %d  ", p->get_cannon_hits());
      SDL_Color c = players[p->get_id()].get_color();
      SDL_Rect r = draw_text(screen, font, txt, pos, c);
      vc[p->get_id()] = pos + coord::pc(r.w, 0);
      pos+= coord::pc(0, r.h);
    }
  pos = coord::pc(0,0);
  for (unsigned int i=0;i<vc.size();i++)
    {
      if (vc[i].getPX() > pos.getPX())
	pos = vc[i];
    }
  // draw destroyed cannons
  for (unsigned int i=0;i<stats->size();i++)
    {
      player_statistic *p = stats->at(i);
      pos.setPY(vc[p->get_id()].getPY());
      sprintf(txt, "destroyed cannons: %d", p->get_destroyed_cannons());
      SDL_Color c = players[p->get_id()].get_color();
      SDL_Rect r = draw_text(screen, font, txt, pos, c);
      //      vc[p->get_id()] = pos + coord::pc(r.w, 0);
      pos+= coord::pc(0, r.h);
    }
}


void gfx::draw_intro(coord &c, int kulma, const char* names[], int players)
{

  const char * mess2="Waiting for other players to connect";
  const char * mess3="Players connected:";

  const char * teksti1 = "Is this Castle Combat?...NO!!! This is Kajaani Kombat by team KK";

  char teksti2[30];
  sprintf (teksti2, "Kajaani Kombat %s", VERSION);

  char buf[2];
  buf[1] = 0;

  int xx=c.getPX();

  SDL_Color col, col2;
  col.r = 0xff;
  col.g = 0xff;
  col.b = 0xff;
  col2.r = 0xff;
  col2.g = 0x00;
  col2.b = 0x00;
  
  rotozoom rz (lut);
  
  float koko=1.0f;
  for(int x=0; x<(int) strlen(teksti1);x++)//teksti1
    {
      buf[0] = *(teksti1+x);
      coord ccx =coord::pc(xx+20*x, (int)((lut->sin(kulma+30*x)*30)+400));
      SDL_Surface *surf = TTF_RenderText_Blended (font, buf,col);
      
      //		if(((int)((lut->sin(kulma+30*(x+1))*30)+400)) >((int)((lut->sin(kulma+30*x)*30)+400)))
      //	koko=koko+0.1f;
      //if(((int)((lut->sin(kulma+30*(x+1))*30)+400)) < ((int)((lut->sin(kulma+30*x)*30)+400)))
      //	koko=koko-0.1f;
      
      koko = 1.0;
      rz.rotatescale_blit (koko, kulma , screen, surf, ccx);	      
      SDL_FreeSurface (surf);
    }
  
  
  for(int x=0; x<(int) strlen(teksti2);x++)//teksti2
    {
      buf[0] = *(teksti2+x);
      coord ccxx = coord::pc(220+x*10,(int)((lut->sin(kulma+30*x)*30)+300));
      SDL_Surface *surf2 = TTF_RenderText_Blended (font, buf,col2);
      //if(x==0 || x==1 || x==2 || x==3 || x==19 || x==20 || x==21)
      //	rz.rotatescale_blit (1.0f, kulma , screen, surf2, ccxx);
      //else
      rz.rotatescale_blit (1.0f, 0 , screen, surf2, ccxx);
      
      SDL_FreeSurface (surf2);
    }
  
  coord cc = coord::pc(200, 200);
  draw_text(screen, font, mess2, cc);
  
  draw_text(screen, font, mess3, coord::pc(20,20));
  //draw player names to screen
  for(int i=0;i<MAX_PLAYERS;i++)
    {
      if(strcmp(names[i],"")!=0)
	draw_text(screen, font, names[i],coord::pc(20,40+i*20));
    }
}

void gfx::draw_objects(vector<game_obj *> &objs, player *players)
{
  bool balloonshown[MAX_PLAYERS];
  for(int i=0;i<MAX_PLAYERS;i++)
    balloonshown[i]=false;

  vector<game_obj *>::iterator it = objs.begin();

  coord text_start = coord::pc(10, SCR_HEIGHT-5);

  while (it != objs.end())
    {
      game_obj *o = *it++;
      assert(o != NULL);
      
      if (typeid(*o) == typeid(ammo))
	{
	  ammo *a = dynamic_cast<ammo*>(o);
	  
	  int alt = a->get_alt();
	  if ( alt < 0) alt = 0;
	  coord c = a->get_position();
	  SDL_Surface *f;
	  if(a->get_size()==NORMAL)
	    f = const_cast<SDL_Surface *>(ammo_anims->get_frame(players[a->get_owner()].get_character(), alt));
	  else
	    f = const_cast<SDL_Surface *>(big_ammo_anims->get_frame(players[a->get_owner()].get_character(), alt));
	  draw_centered_to_pixel (f, c);
	}
      else if (typeid (*o) == typeid(explosion_efect))
	{
	  explosion_efect *e = dynamic_cast<explosion_efect*>(o);
	  e->draw(screen);
	}
      else if (typeid(*o) == typeid(starfield_efect))
	{
	  starfield_efect *s = dynamic_cast<starfield_efect*>(o);
	  s->draw(screen);
	}
      else if (typeid(*o) == typeid(anim_explosion_obj))
	{
	  anim_explosion_obj *ao = dynamic_cast<anim_explosion_obj *>(o);
	  draw_animation(*ao);
	}
      else if (typeid(*o) == typeid(balloon_object))
	{

	  balloon_object *bo = dynamic_cast<balloon_object *>(o);

	  if(!balloonshown[bo->get_owner()])
	    {
	      coord c = bo->get_position();
	      
	      int wi = bo->get_text().length() * 8; //8 pixels for letter
	      
	      int xcoord = c.getPX();
	      // if balloon goes over the screen
	      if(xcoord+wi+10>SCR_WIDTH)
		xcoord = xcoord - (xcoord+wi+10-SCR_WIDTH);
	      
	      SDL_Rect r;
	      r.x = xcoord;
	      r.y = c.getPY();
	      r.w = wi;
	      r.h = 30;
	      
	      draw_fadebox (0.5, &r, screen);
	      
	      coord sp = coord::pc(r.x-1,r.y-1);
	      coord dp = coord::pc(r.x+r.w+1,r.y+r.h+1);
	      
	      SDL_Color col = bo->get_color();
	      Uint32 bcol = SDL_MapRGB(screen->format, col.r, col.g, col.b);
	      
	      draw_rectangle(screen, sp, dp, bcol);
	      
	      coord tp = coord::pc (r.x + r.w/2, r.y-5);

	      tp.addPY (r.h/2+5);
	      //draw_text_baseline (screen, font, mess,d);
	      draw_text_centered (screen, font, bo->get_text().c_str(), tp);
	      //draw_text_centered(screen, font, txt.c_str(),tp);
	      balloonshown[bo->get_owner()]=true;
	    }
	  
	}
      else if (typeid(*o) == typeid(text_object))
	{
	  text_object *to = dynamic_cast<text_object *>(o);
	  if (to->has_unknown_position())
	    {
	      SDL_Rect ret = draw_text_baseline (screen, font, to->get_text().c_str(), text_start);
	      text_start.subPY(ret.h+2);
	    }
	  else
	    draw_text (screen, font, to->get_text().c_str(), to->get_position(), to->get_color());
	}
      
    }
}

void gfx::draw_objects(vector<game_obj *> &objs)//do not use this. Use the other one. This one is used only in gui.cpp line 112. Remember to fix that!!!
{
  vector<game_obj *>::iterator it = objs.begin();

  coord text_start = coord::pc(10, SCR_HEIGHT-5);

  while (it != objs.end())
    {
      game_obj *o = *it++;
      assert(o != NULL);
      
      if (typeid(*o) == typeid(ammo))
	{
	  ammo *a = dynamic_cast<ammo*>(o);
	  
	  int alt = a->get_alt();
	  if ( alt < 0) alt = 0;
	  coord c = a->get_position();
	  SDL_Surface *f = const_cast<SDL_Surface *>(ammo_anims->get_frame(a->get_owner(), alt));
	  draw_centered_to_pixel (f, c);
	}
      else if (typeid (*o) == typeid(explosion_efect))
	{
	  explosion_efect *e = dynamic_cast<explosion_efect*>(o);
	  e->draw(screen);
	}
      else if (typeid(*o) == typeid(starfield_efect))
	{
	  starfield_efect *s = dynamic_cast<starfield_efect*>(o);
	  s->draw(screen);
	}
      else if (typeid(*o) == typeid(anim_explosion_obj))
	{
	  anim_explosion_obj *ao = dynamic_cast<anim_explosion_obj *>(o);
	  draw_animation(*ao);
	}
      else if (typeid(*o) == typeid(text_object))
	{
	  text_object *to = dynamic_cast<text_object *>(o);
	  if (to->get_position().getPX() < 0)
	    {
	      SDL_Rect ret = draw_text_baseline (screen, font, to->get_text().c_str(), text_start);
	      text_start.subPY(ret.h+2);
	    }
	  else
	    draw_text (screen, font, to->get_text().c_str(), to->get_position(), to->get_color());
	}
      
    }
}

void gfx::draw_bar(float tleft, const char *modestr)
{
  char buf[100];
  if (SDL_MUSTLOCK(screen))
    SDL_LockSurface (screen);

  Uint32 *pix = (Uint32 *) screen->pixels;
  Uint32 w = screen->w;

  // draw line 
  for (unsigned int i=0;i<w;i++)
    pix[SCR_HEIGHT*w+i] = BAR_LINE_COL;

  if (SDL_MUSTLOCK(screen))
    SDL_UnlockSurface(screen);

  coord tpos= coord::pc (5, SCR_HEIGHT+BAR_HEIGHT-2);
  if (tleft >= 0.0)
    {
      sprintf (buf, "%.2f", tleft);
      SDL_Rect r = draw_text_baseline (screen, font, buf, tpos);
      tpos += coord::pc(40,0);
    }
  if (tleft >= 0.0)
    sprintf (buf, "seconds left: %s", modestr);
  else
    sprintf (buf, "%s", modestr);
  SDL_Rect r = draw_text_baseline (screen, font, buf, tpos);
  //  printf ("drawed bar %s to %d %d\n", buf, tpos.getPX(), tpos.getPY());

}

void gfx::draw_animation (anim_explosion_obj &a)
{
  int f = (int)((double) a.get_age() / 2000.0 * (double) exp_anims->get_frames());
  if (f > exp_anims->get_frames()) f = exp_anims->get_frames();
  //  printf ("frame %d drawn to %d %d\n", f, a.get_position().x, a.get_position().y);
  SDL_Surface *s = const_cast<SDL_Surface *>(exp_anims->get_frame(a.get_type(), f));
  draw_centered_to_pixel (s, a.get_position());

}

void gfx::draw_talkmode(bool talk, string txt, player &talker)
{
  if(talk)
    {
      SDL_Rect r;
      r.x = 100;
      r.y = SCR_HEIGHT / 2 - 15;
      r.w = SCR_WIDTH-200;
      r.h = 30;
      draw_fadebox (0.5, &r, screen);
      coord sp = coord::pc(r.x-1,r.y-1);
      coord dp = coord::pc(r.x+r.w+1,r.y+r.h+1);
      draw_rectangle(screen, sp, dp, BAR_LINE_COL);
      coord tp = coord::pc (r.x + r.w/2, r.y-5);
      SDL_Color pcol = talker.get_color();
      draw_text_baseline_centered(screen, font, talker.get_name().c_str(), tp, pcol);
      if(txt.length()>0)
	{
	  tp.addPY (r.h/2+5);
	  draw_text_centered(screen, font, txt.c_str(),tp);
	}
      
    }
}

void gfx::draw_fadebox(double inten, SDL_Rect *r, SDL_Surface *s)
{
  inten = 1.0 - inten;
  Uint8 am = (Uint8) (255.0 * inten);
  Uint32 col = 0x000000 | (am << 24);

  SDL_Surface *tmps = SDL_CreateRGBSurface (SDL_SWSURFACE, r->w, r->h, s->format->BitsPerPixel, s->format->Rmask,
			s->format->Gmask, s->format->Bmask, s->format->Amask);
  SDL_FillRect (tmps, NULL, col);
  SDL_SetAlpha (tmps, SDL_SRCALPHA | SDL_RLEACCEL, am);

  SDL_BlitSurface (tmps, NULL, s, r);
  SDL_FreeSurface (tmps);
}
