/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "rotozoom.h"

rotozoom::rotozoom (const lookup *_lut)
{
  lut = _lut;
}

void rotozoom::rotatescale_blit(float scale,
				    int angle,
				    SDL_Surface *dest,
				    SDL_Surface *src,
				    const coord & cen) const
{
  if (SDL_MUSTLOCK(dest))
    SDL_LockSurface (dest);
  if (SDL_MUSTLOCK(src))
    SDL_LockSurface (src);

  scale = 1.0f / scale; // invert the scale, as it should be.

  // both surfaces must be in 32 bpp format!
  assert (dest->format->BytesPerPixel == 4);
  assert (src->format->BytesPerPixel == 4);

  Uint32 *spix = (Uint32 *) src->pixels;

  int mw; // max width of blit-area.
  if (src->w > src->h)
	mw = (int) ceil(sqrt((double)(src->w*src->w)));
  else
	mw = (int) ceil(sqrt((double)(src->h*src->h)));

  mw  = (int) ((float) mw * 1.0f);//scale);
  
  SDL_Surface *tmpi = SDL_CreateRGBSurface  (SDL_SWSURFACE, mw, mw, src->format->BitsPerPixel,
					     src->format->Rmask, src->format->Gmask,
					     src->format->Bmask, src->format->Amask);

  SDL_Surface *tmpi2 = SDL_CreateRGBSurface  (SDL_SWSURFACE, mw, mw, src->format->BitsPerPixel,
					     src->format->Rmask, src->format->Gmask,
					     src->format->Bmask, src->format->Amask);

  Uint32 *dpix = (Uint32 *) tmpi->pixels;

  //  coord start (cen.x - mw/2, cen.y - mw/2);

  //  int ystart = ycenter - (mw / 2);
  //int xstart = xcenter - (mw / 2);
  
  float sinas=lut->sin(angle)*scale;
  float cosas=lut->cos(angle)*scale;
  
  //x' = cos(-angle)+sin(-angle)
  //y' = cos(-angle)-sin(-angle)
  float xc=(src->w / 2) - ((mw / 2)*(cosas+sinas));
  float yc=(src->h / 2) - ((mw / 2)*(cosas-sinas));

  // set destpix to start of bounding rect.
  //  dpix += start.y*dest->w +start.x;
  
  //  int row_end_add = tmpi->w - mw;
  int row_end_add = 0;

  for (int y=0;y<mw;y++)
    {
      float tx=xc;
      float ty=yc;
      for (int x=0;x<mw;x++)
        {
	  //		  printf ("putting pixel at %d %d\n", x+xstart, y+ystart);
	  //printf ("tx %f ty %f\n", tx, ty);
	  if( (tx<0.0f) ||
	      (tx>=(float)src->w) ||
	      (ty<0.0f) ||
	      (ty>=(float)src->h) )
	    { *dpix = 0; } // if if falls off, don't blit!
	  else
	    {
	      Uint32 byt = spix[(int)(tx)+(int)(ty)*src->w];
	      //				printf ("put pix val %X\n", byt);
	      //dpix[x+xstart + ((y+ystart)*dest->w)]= byt;
	      
	      *dpix= byt;
	    }
	  tx+=cosas;
	  ty-=sinas;
	  dpix++;
        }
      dpix += row_end_add;
      xc+=sinas;
      yc+=cosas;
    }
  
  if (SDL_MUSTLOCK(dest))
    SDL_UnlockSurface (dest);
  if (SDL_MUSTLOCK(src))
    SDL_UnlockSurface (src);

  SDL_Rect r;
  r.x = cen.getPX()-tmpi->w/2;
  r.y = cen.getPY()-tmpi->h/2;

  // bilin interpol
  bilinear_interpolation(tmpi, tmpi2);

  SDL_BlitSurface (tmpi2, NULL, dest, &r);

  SDL_FreeSurface(tmpi);
  SDL_FreeSurface(tmpi2);
}
