/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.rest.HttpTransportInvocationHandler;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RpcClient;
import org.jkiss.utils.rest.RpcConstants;
import org.jkiss.utils.rest.RpcException;

public class JsonRpcClient
extends RpcClient {
    private static final String DEFAULT_USER_AGENT = "JsonRpc Client";

    @NotNull
    public static <T> Builder<T> builder(@NotNull URI uri, @NotNull Class<T> cls) {
        return new Builder<T>(uri, cls);
    }

    public static final class Builder<T> {
        private final URI uri;
        private final Class<T> cls;
        private Gson gson;
        private String userAgent;

        private Builder(@NotNull URI uri, @NotNull Class<T> cls) {
            this.uri = uri;
            this.cls = cls;
            this.gson = RpcConstants.COMPACT_GSON;
            this.userAgent = JsonRpcClient.DEFAULT_USER_AGENT;
        }

        @NotNull
        public Builder<T> setGson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        public Builder<T> setUserAgent(@NotNull String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @NotNull
        public T create() {
            return JsonRpcClient.createProxy(this.cls, new JsonRpcInvocationHandler(this.cls, this.uri, this.gson, this.userAgent));
        }
    }

    private static class JsonRpcInvocationHandler
    extends HttpTransportInvocationHandler {
        private JsonRpcInvocationHandler(@NotNull Class<?> clientClass, @NotNull URI uri, @NotNull Gson gson, @NotNull String userAgent) {
            super(clientClass, uri, gson, userAgent, null);
        }

        @Override
        protected void handleHttpError(String contents) throws RpcException {
            try {
                Map map = (Map)this.gson.fromJson(contents, Map.class);
                Map error = (Map)map.get("error");
                if (error != null) {
                    Object errorClass = error.get("exceptionClass");
                    Object message = error.get("message");
                    error.get("stacktrace");
                    if (message != null) {
                        RpcException rpcException = new RpcException(message.toString(), errorClass == null ? null : errorClass.toString());
                        throw rpcException;
                    }
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
            super.handleHttpError(contents);
        }

        @Override
        protected String invokeRemoteMethod(@NotNull Method method, @Nullable RequestMapping mapping, @NotNull Map<String, JsonElement> values) {
            try {
                LinkedHashMap<String, ArrayList<JsonElement>> fullRequest = new LinkedHashMap<String, ArrayList<JsonElement>>();
                ArrayList<JsonElement> paramList = new ArrayList<JsonElement>(values.values());
                fullRequest.put(method.getName(), paramList);
                String requestString = this.gson.toJson(fullRequest);
                return super.invokeRemoteMethodOverHttp(this.uri, requestString, mapping);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
        }
    }
}

