/* store some global config values

   Written by Matthias Hensler
   Copyright WSPse 1999-2004
   eMail: matthias@wspse.de

Created: 1999/06/11
Updated: 2004/04/15, MH: make OGG default if requested on compile time
         2004/04/25, MH: presets now in mp3creat.h
         2006/03/08, MH: add "-H" to cdda2wavs commandline
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "mp3creat.h"
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif /* HAVE_SYS_PARAM_H */

#ifdef OGG_AS_DEFAULT
#define FN_PATTERN	PRE1_PATTERN
#define FN_PATTERN_MIX	PRE1_PATTERN_M
#else
#define FN_PATTERN      PRE2_PATTERN
#define FN_PATTERN_MIX  PRE2_PATTERN_M
#endif

#define DEF_CDDB_SERVER "freedb.freedb.org:8880"

#ifdef CONF_CDDB_PATH
#define DEF_CDDB_BANK   CONF_CDDB_PATH
#else    /* CONF_CDDB_PATH */
#define DEF_CDDB_BANK   "~/.cddb"
#endif   /* CONF_CDDB_PATH */

#if (defined(BSD) && BSD >= 199306)
#define DEF_CDROM_DEV	"/dev/rcd0d"
#else
#define DEF_CDROM_DEV   "/dev/cdrom"
#endif /* !(defined(BSD) && BSD >= 199306) */
#define DEF_TMP_FILE    "/tmp/WSPse-MP3Creat.wav"
#define DEF_MP3_DIR     "./"      /* default dir for mp3s */
#define DEF_M3U_DIR     "0"       /* default dir for m3us */
#ifdef OGG_AS_DEFAULT
#define DEF_MP3_INFO	PRE1_ENC_INFO
#define DEF_MP3_ENC_NF	PRE1_ENC_NF
#define DEF_MP3_ENC_OF	PRE1_ENC_OF
#else
#define DEF_MP3_INFO	PRE2_ENC_INFO
#define DEF_MP3_ENC_NF	PRE2_ENC_NF
#define DEF_MP3_ENC_OF	PRE2_ENC_OF
#endif
#define DEF_CD_RIP_NF   "cdda2wav -H -D \"%1\" -t %2 -O wav -paranoia \"%3\""
#define DEF_CD_RIP_OF   "cdda2wav -H -D \"%1\" -t %2 -O wav -paranoia -"
#define DEF_FRM_MULTI   214
#define DEF_M3U_PATTERN "%1-%3.m3u"    /* pattern for m3u-playlist: %1 = artist,
					  %2 = songtitle, %3 = album */
#define DEF_M3U_PATMIX  "%3.m3u"
#define DEF_COMMENT     "gen by WSPse-MP3c %8 [%b/%c]"
#define DEF_ILL_CHARS   "~[]()!*?\""
#define DEF_EXP_FILE    "./.mp3c-exported"
#define DEF_VERSION_STR "0.00"
#define DEF_CDDB_EMAIL  "freedb-submit@freedb.org"
#define DEF_SMTP_SERVER "localhost:smtp"
#define CDDB_GENRES     "blues,classical,country,data,folk,jazz,misc,newage,reggae,rock,soundtrack"
#define DEF_UNKNOWN_GEN "Unknown"

extern void wuuush(int);
extern void popup_error_win(char *tx);
extern BOOL select_yesno_box(char *tx);
extern int create_sub_dirs(char *filename, BOOL mode);
extern BOOL str_path_check(char *program);
extern char *copy_char_str(char *old);
extern BOOL file_is_directory(char *path);
extern char *external_cdrom_dev;
extern char *file_glob_in_name(char *name);

/*---------------------------------------------------------------------------------*/
signed char config_fancy_colors = 0;     /* 0: no color, 1: sometimes, 2: ever     */
BOOL fn_toupper = TRUE;                  /* change filename toupper before space   */
int  fn_mode = 1;                        /* mode for filename: s. file.c           */
char replace_space_ch = '_';
char *fn_pattern      = NULL;
char *fn_pattern_mix  = NULL;
char *def_cddb_server = NULL;
char *def_cddb_bank   = NULL;
char *def_cdrom_dev   = NULL;
char *def_tmp_file    = NULL;
char *def_mp3_dir     = NULL;
char *def_mp3_info    = NULL;
char *def_cd_rip_nf   = NULL;
char *def_cd_rip_of   = NULL;
char *def_mp3_enc_nf  = NULL;
char *def_mp3_enc_of  = NULL;
char *def_m3u_pattern = NULL;
char *def_m3u_patmix  = NULL;
char *def_m3u_dir     = NULL;
char *def_comment     = NULL;
char *def_ill_chars   = NULL;
char *def_exp_file    = NULL;
char *def_version_str = NULL;
char *def_cddb_email  = NULL;
char *def_smtp_server = NULL;
char *def_my_email    = NULL;
char *cddb_genres     = NULL;
char *def_unknown_gen = NULL;
int  auto_save        = 0;               /* save configuration on exit?            */
int  of_fifo_buf      = 512;             /* FIFO buffer for on-the-fly encoding    */
int  mp3_frame_mult   = DEF_FRM_MULTI;   /* Framemult. for MP3 (frame->KB)         */
BOOL def_on_fly       = FALSE;           /* encode on fly (default?)               */
BOOL eased_char_hand  = FALSE;           /* non-strict character handling?         */
char replace_slash_ch = '-';             /* character for replacing slashes        */
BOOL rip_enc_ordered  = FALSE;           /* first rip all all tracks before encode?*/
int  del_tmp_on_exit  = 1;               /* 0: no, 1: marked, 2: all               */
BOOL clear_del_on_exp = TRUE;            /* clear del flag on export               */
BOOL config_curs_dir  = TRUE;            /* use curses directory requester         */
int  def_m3u_rel_name = 2;               /* 0: not rel, 1: to main, 2: to m3u      */
BOOL config_cddb_enbl = TRUE;            /* if cddb internet access is enabled     */
BOOL config_req_hidden= FALSE;           /* show hidden files/directorys           */
BOOL config_para_mp3c = TRUE;            /* allow parallel running MP3c's          */
int  config_case_chg  = 0;               /* 0=untouched, 1=to lower, 2=to upper    */
BOOL config_open_tray = TRUE;            /* open tray after successfully encoding  */
BOOL config_ill_remove= TRUE;            /* remove illegal characters (or fn_mode) */
BOOL config_pat_prot  = TRUE;            /* protect pattern                        */
/*---------------------------------------------------------------------------------*/

void init_config()
{
  char *pat, *pat2;
  
  if(fn_pattern)      free(fn_pattern);
  if(fn_pattern_mix)  free(fn_pattern_mix);
  if(def_cddb_server) free(def_cddb_server);
  if(def_cddb_bank)   free(def_cddb_bank);
  if(def_cdrom_dev)   free(def_cdrom_dev);
  if(def_tmp_file)    free(def_tmp_file);
  if(def_mp3_dir)     free(def_mp3_dir);
  if(def_mp3_info)    free(def_mp3_info);
  if(def_cd_rip_nf)   free(def_cd_rip_nf);
  if(def_cd_rip_of)   free(def_cd_rip_of);
  if(def_mp3_enc_nf)  free(def_mp3_enc_nf);
  if(def_mp3_enc_of)  free(def_mp3_enc_of);
  if(def_m3u_pattern) free(def_m3u_pattern);
  if(def_m3u_patmix)  free(def_m3u_patmix);
  if(def_m3u_dir)     free(def_m3u_dir);
  if(def_comment)     free(def_comment);
  if(def_ill_chars)   free(def_ill_chars);
  if(def_exp_file)    free(def_exp_file);
  if(def_version_str) free(def_version_str);
  if(def_cddb_email)  free(def_cddb_email);
  if(def_smtp_server) free(def_smtp_server);
  if(def_my_email)    free(def_my_email);
  if(def_unknown_gen) free(def_unknown_gen);
 
  auto_save           = 0;
  of_fifo_buf         = 512;
  config_fancy_colors = 0;
  fn_toupper          = TRUE;
  fn_mode             = 1;
  replace_space_ch    = '_';
  mp3_frame_mult      = DEF_FRM_MULTI;
  def_on_fly          = FALSE;
  eased_char_hand     = FALSE;
  replace_slash_ch    = '-';
  rip_enc_ordered     = FALSE;
  del_tmp_on_exit     = 1;
  clear_del_on_exp    = TRUE;
  config_curs_dir     = TRUE;
  def_m3u_rel_name    = 2;
  config_cddb_enbl    = TRUE;
  config_para_mp3c    = TRUE;
  config_case_chg     = 0;
  config_open_tray    = TRUE;
  config_ill_remove   = TRUE;
  config_pat_prot     = TRUE;
  
  fn_pattern      = copy_char_str(FN_PATTERN);
  fn_pattern_mix  = copy_char_str(FN_PATTERN_MIX);
  def_cddb_server = copy_char_str(DEF_CDDB_SERVER);
  def_cddb_bank   = file_glob_in_name(copy_char_str(DEF_CDDB_BANK));

  if(external_cdrom_dev) {
    def_cdrom_dev = copy_char_str(external_cdrom_dev);
  } else {
    def_cdrom_dev = copy_char_str(DEF_CDROM_DEV);
  }

  def_tmp_file    = copy_char_str(DEF_TMP_FILE);
  def_mp3_dir     = copy_char_str(DEF_MP3_DIR);
  def_mp3_info    = copy_char_str(DEF_MP3_INFO);
  def_cd_rip_nf   = copy_char_str(DEF_CD_RIP_NF);
  def_cd_rip_of   = copy_char_str(DEF_CD_RIP_OF);
  def_mp3_enc_nf  = copy_char_str(DEF_MP3_ENC_NF);
  def_mp3_enc_of  = copy_char_str(DEF_MP3_ENC_OF);
  def_m3u_pattern = copy_char_str(DEF_M3U_PATTERN);
  def_m3u_patmix  = copy_char_str(DEF_M3U_PATMIX);
  def_m3u_dir     = copy_char_str(DEF_M3U_DIR);
  def_comment     = copy_char_str(DEF_COMMENT);
  def_ill_chars   = copy_char_str(DEF_ILL_CHARS);
  def_exp_file    = copy_char_str(DEF_EXP_FILE);
  def_version_str = copy_char_str(DEF_VERSION_STR);
  def_cddb_email  = copy_char_str(DEF_CDDB_EMAIL);
  def_unknown_gen = copy_char_str(DEF_UNKNOWN_GEN);

  if(! cddb_genres) {
    cddb_genres = copy_char_str(CDDB_GENRES);
  }

  /* find hostname and username */
  pat = getenv("HOSTNAME");
  if(! pat) {
    def_smtp_server = copy_char_str(DEF_SMTP_SERVER);
  } else {
    def_smtp_server = (char *) malloc(sizeof(char) * (strlen(pat) + 6));
    if(! def_smtp_server) {
      wuuush(1);
    }
    sprintf(def_smtp_server, "%s:smtp", pat);
  }

  if(pat) {
    def_my_email = copy_char_str(pat);
  } else {
    def_my_email = copy_char_str("localhost");
  }

  pat = getenv("LOGNAME");
  if(! pat) {
    pat = getlogin();
  }

  if(! pat) {
    pat = (char *) malloc(sizeof(char) * (strlen(def_my_email) + 9));
    if(! pat) {
      wuuush(1);
    }
    sprintf(pat, "unknown@%s", def_my_email);
    free(def_my_email);
    def_my_email = pat;
  } else {
    pat2 = (char *) malloc(sizeof(char) * (strlen(def_my_email) + strlen(pat) + 2));
    if(! pat2) {
      wuuush(1);
    }
    sprintf(pat2, "%s@%s", pat, def_my_email);
    free(def_my_email);
    def_my_email = pat2;
  }
}

void check_config()
{
  char *text;

  if(! def_cddb_bank) {
    popup_error_win(_("no CDDB-directory specified"));
  } else {
    if(access(def_cddb_bank, F_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_cddb_bank)+80));
      if(text == NULL) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("CDDB-dir \"%s\" does not exist!"), def_cddb_bank);
      popup_error_win(text);
      sprintf(text, _("Maybe you want to create \"%s\"?"), def_cddb_bank);
      if(select_yesno_box(text)) {
	create_sub_dirs(def_cddb_bank, FALSE);
      }
      free(text);
    } else if(access(def_cddb_bank, W_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_cddb_bank)+80));
      if(text == NULL) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no write permission for \"%s\""), def_cddb_bank);
      popup_error_win(text);
      free(text);
    } else {
      file_is_directory(def_cddb_bank);
    }
  }

  if(! def_mp3_dir) {
    popup_error_win(_("no MP3-directory specified"));
  } else {
    if(access(def_mp3_dir, F_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_mp3_dir)+50));
      if(text == NULL) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no dir \"%s\""), def_mp3_dir);
      popup_error_win(text);
      free(text);
    } else if(access(def_mp3_dir, W_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_mp3_dir)+100));
      if(text == NULL) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no write permission for \"%s\""), def_mp3_dir);
      popup_error_win(text);
      free(text);
    } else {
      file_is_directory(def_mp3_dir);
    }
  }

  if(! def_m3u_dir) {
    popup_error_win(_("no M3U-directory specified"));
  } else if(strcmp(def_m3u_dir, "0") != 0) {
    if(access(def_m3u_dir, F_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_m3u_dir)+50));
      if(! text) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no dir \"%s\""), def_m3u_dir);
      popup_error_win(text);
      free(text);
    } else if(access(def_m3u_dir, W_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_m3u_dir)+60));
      if(! text) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no write permission for \"%s\""), def_m3u_dir);
      popup_error_win(text);
      free(text);
    } else {
      file_is_directory(def_m3u_dir);
    }
  }
  
  if(! def_cdrom_dev) {
    popup_error_win(_("no cdrom device specified"));
  } else {
    if(access(def_cdrom_dev, R_OK) != 0) {
      text = (char *) malloc(sizeof(char) * (strlen(def_cdrom_dev)+50));
      if(text == NULL) {
	perror("malloc");
	wuuush(1);
      }
      sprintf(text, _("no permissions for \"%s\""), def_cdrom_dev);
      popup_error_win(text);
      free(text);
    }
  }

  if(! def_on_fly) {
    if(! str_path_check(def_cd_rip_nf)) {
      popup_error_win(_("ripperprg non-fly not found!"));
    }
    if(! str_path_check(def_mp3_enc_nf)) {
      popup_error_win(_("encoderprg non-fly not found!"));
    }
  } else {
    if(! str_path_check(def_cd_rip_of)) {
      popup_error_win(_("ripperprg on-fly not found!"));
    }
    if(! str_path_check(def_mp3_enc_of)) {
      popup_error_win(_("encoderprg on-fly not found!"));
    }
  }
  if(def_mp3_info && strcmp(def_mp3_info, "0") && (! str_path_check(def_mp3_info))) {
    popup_error_win(_("mp3info-prg missing!"));
  }
}

