package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the open API 2.0 Specs for Azure Data Protection service
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient(subscriptionID string) Client {
	return NewClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewClientWithBaseURI creates an instance of the Client client using a custom endpoint.  Use this when interacting
// with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return Client{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckFeatureSupport sends the check feature support request.
// Parameters:
// parameters - feature support request object
func (client Client) CheckFeatureSupport(ctx context.Context, location string, parameters BasicFeatureValidationRequestBase) (result FeatureValidationResponseBaseModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.CheckFeatureSupport")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CheckFeatureSupportPreparer(ctx, location, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.Client", "CheckFeatureSupport", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckFeatureSupportSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.Client", "CheckFeatureSupport", resp, "Failure sending request")
		return
	}

	result, err = client.CheckFeatureSupportResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.Client", "CheckFeatureSupport", resp, "Failure responding to request")
		return
	}

	return
}

// CheckFeatureSupportPreparer prepares the CheckFeatureSupport request.
func (client Client) CheckFeatureSupportPreparer(ctx context.Context, location string, parameters BasicFeatureValidationRequestBase) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/locations/{location}/checkFeatureSupport", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckFeatureSupportSender sends the CheckFeatureSupport request. The method will close the
// http.Response Body if it receives an error.
func (client Client) CheckFeatureSupportSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckFeatureSupportResponder handles the response to the CheckFeatureSupport request. The method always
// closes the http.Response Body.
func (client Client) CheckFeatureSupportResponder(resp *http.Response) (result FeatureValidationResponseBaseModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
