// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-api. DO NOT EDIT.

package registryv1alpha1api

import (
	context "context"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
)

// DisplayService provides information regarding
// UI element displaying based on the users roles.
type DisplayService interface {
	// DisplayOrganizationElements returns which organization elements should be displayed to the user.
	DisplayOrganizationElements(
		ctx context.Context,
		organizationId string,
	) (createRepository bool, createPlugin bool, createTemplate bool, settings bool, updateSettings bool, delete bool, err error)
	// DisplayRepositoryElements returns which repository elements should be displayed to the user.
	DisplayRepositoryElements(
		ctx context.Context,
		repositoryId string,
	) (settings bool, delete bool, write bool, err error)
	// DisplayPluginElements returns which plugin elements should be displayed to the user.
	DisplayPluginElements(
		ctx context.Context,
		pluginId string,
	) (createVersion bool, settings bool, delete bool, err error)
	// DisplayTemplateElements returns which template elements should be displayed to the user.
	DisplayTemplateElements(
		ctx context.Context,
		templateId string,
	) (createVersion bool, settings bool, delete bool, err error)
	// DisplayUserElements returns which user elements should be displayed to the user.
	DisplayUserElements(ctx context.Context) (delete bool, err error)
	// DisplayServerElements returns which server elements should be displayed to the user.
	DisplayServerElements(ctx context.Context) (adminPanel bool, err error)
	// ListManageableRepositoryRoles returns which roles should be displayed
	// to the user when they are managing contributors on the repository.
	ListManageableRepositoryRoles(ctx context.Context, repositoryId string) (roles []v1alpha1.RepositoryRole, err error)
	// ListManageableUserRepositoryRoles returns which roles should be displayed
	// to the user when they are managing a specific contributor on the repository.
	ListManageableUserRepositoryRoles(
		ctx context.Context,
		repositoryId string,
		userId string,
	) (roles []v1alpha1.RepositoryRole, err error)
	// ListManageablePluginRoles returns which roles should be displayed
	// to the user when they are managing contributors on the plugin.
	ListManageablePluginRoles(ctx context.Context, pluginId string) (roles []v1alpha1.PluginRole, err error)
	// ListManageableUserPluginRoles returns which roles should be displayed
	// to the user when they are managing a specific contributor on the plugin.
	ListManageableUserPluginRoles(
		ctx context.Context,
		pluginId string,
		userId string,
	) (roles []v1alpha1.PluginRole, err error)
	// ListManageableTemplateRoles returns which roles should be displayed
	// to the user when they are managing contributors on the template.
	ListManageableTemplateRoles(ctx context.Context, templateId string) (roles []v1alpha1.TemplateRole, err error)
	// ListManageableUserTemplateRoles returns which roles should be displayed
	// to the user when they are managing a specific contributor on the template.
	ListManageableUserTemplateRoles(
		ctx context.Context,
		templateId string,
		userId string,
	) (roles []v1alpha1.TemplateRole, err error)
}
