GNOME LaTeX
===========

![icon!](data/icons/org.gnome.gnome-latex.svg)

GNOME LaTeX is a [LaTeX](https://www.latex-project.org/) editor for the GNOME
desktop.

GNOME LaTeX was previously named LaTeXila. The application has been renamed in
December 2017. The first stable version with the GNOME LaTeX name is the 3.28,
and the last stable version with the old name is the 3.26.

Notable features
----------------

- Build tools: customizable buttons to compile, convert and view a document in
  one click. [Latexmk](https://personal.psu.edu/jcc8/software/latexmk-jcc/) is
  used by default, but the low-level commands such as pdflatex, dvipdf and
  bibtex can also be used
  ([screenshot 1](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-build-tools.png),
  [screenshot 2](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-build-tools-more-details.png)
  and [screenshot 3](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-build-tools-preferences.png)).

- Completion of LaTeX commands
  ([screenshot](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-completion.png)).

- Document structure: a list of chapters, sections, figures, etc. to easily
  navigate in a document
  ([screenshot](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-structure.png)).

- Symbol tables: Greek letters, arrows, etc
  ([screenshot](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-symbols.png)).

- Templates for creating a new document: there are a few default templates, and
  you can create personal templates
  ([screenshot](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-templates.png)).

- Easy projects management
  ([screenshot](https://gitlab.gnome.org/swilmet/gnome-latex-extra/-/raw/main/screenshots/screenshot-project.png)).

- Spell-checking.
- Jump to the associated position between the .tex and the PDF with Ctrl+click.
- Some menus and toolbars with the principal LaTeX commands.
- Integrated file browser.
- All common things found in a text editor.

The idea of GNOME LaTeX is to always deal directly with the LaTeX code, while
simplifying as most as possible the writing of this LaTeX code. This permits to
concentrate on the content and the structure of the document instead of being
distracted by its presentation. You can read more information about the
principles behind the GNOME LaTeX user experience in
[this article](https://informatique-libre.be/swilmet/articles/latex-editor-some-principles.pdf).

More information
----------------

[More information about GNOME LaTeX](docs/more-information.md).
