/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compress.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;

public final class FailureProvider
extends NonzaProvider<Failure> {
    private static final Logger LOGGER = Logger.getLogger(FailureProvider.class.getName());
    public static final FailureProvider INSTANCE = new FailureProvider();

    private FailureProvider() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Failure parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        Failure.CompressFailureError compressFailureError = null;
        StanzaError stanzaError = null;
        XmlEnvironment failureXmlEnvironment = XmlEnvironment.from(parser, xmlEnvironment);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String namespace;
                    String name = parser.getName();
                    block9 : switch (namespace = parser.getNamespace()) {
                        case "http://jabber.org/protocol/compress": {
                            compressFailureError = Failure.CompressFailureError.valueOf(name.replace("-", "_"));
                            if (compressFailureError == null) {
                                LOGGER.warning("Unknown element in http://jabber.org/protocol/compress: " + name);
                                break;
                            }
                            break block0;
                        }
                        case "jabber:client": 
                        case "jabber:server": {
                            switch (name) {
                                case "error": {
                                    stanzaError = PacketParserUtils.parseError(parser, failureXmlEnvironment, jxmppContext);
                                    break block9;
                                }
                            }
                            LOGGER.warning("Unknown element in " + namespace + ": " + name);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new Failure(compressFailureError, stanzaError);
                }
            }
        }
    }
}

