/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jxmpp.jid.EntityFullJid;

public abstract class AbstractDebugger
extends SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(AbstractDebugger.class.getName());
    public static boolean printInterpreted = false;
    private final ConnectionListener connListener;
    private final ReconnectionListener reconnectionListener;

    public AbstractDebugger(final XMPPConnection connection) {
        super(connection);
        this.connListener = new ConnectionListener(){

            @Override
            public void connected(XMPPConnection connection2) {
                AbstractDebugger.this.log("XMPPConnection connected (" + String.valueOf(connection2) + ")");
            }

            @Override
            public void authenticated(XMPPConnection connection2, boolean resumed) {
                String logString = "XMPPConnection authenticated (" + String.valueOf(connection2) + ")";
                if (resumed) {
                    logString = logString + " and resumed";
                }
                AbstractDebugger.this.log(logString);
            }

            @Override
            public void connectionClosed() {
                AbstractDebugger.this.log("XMPPConnection closed (" + String.valueOf(connection) + ")");
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                AbstractDebugger.this.log("XMPPConnection closed due to an exception (" + String.valueOf(connection) + ")", e);
            }
        };
        this.reconnectionListener = new ReconnectionListener(){

            @Override
            public void reconnectionFailed(Exception e) {
                AbstractDebugger.this.log("Reconnection failed due to an exception (" + String.valueOf(connection) + ")", e);
            }

            @Override
            public void reconnectingIn(int seconds) {
                AbstractDebugger.this.log("XMPPConnection (" + String.valueOf(connection) + ") will reconnect in " + seconds);
            }
        };
        if (connection instanceof AbstractXMPPConnection) {
            AbstractXMPPConnection abstractXmppConnection = (AbstractXMPPConnection)connection;
            ReconnectionManager.getInstanceFor(abstractXmppConnection).addReconnectionListener(this.reconnectionListener);
        } else {
            LOGGER.info("The connection instance " + String.valueOf(connection) + " is not an instance of AbstractXMPPConnection, thus we can not install the ReconnectionListener");
        }
    }

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    @Override
    public void outgoingStreamSink(CharSequence outgoingCharSequence) {
        this.log("SENT (" + this.connection.getConnectionCounter() + "): " + String.valueOf(outgoingCharSequence));
    }

    @Override
    public void incomingStreamSink(CharSequence incomingCharSequence) {
        this.log("RECV (" + this.connection.getConnectionCounter() + "): " + String.valueOf(incomingCharSequence));
    }

    @Override
    public void userHasLogged(EntityFullJid user) {
        String localpart = user.getLocalpart().toString();
        boolean isAnonymous = "".equals(localpart);
        String title = "User logged (" + this.connection.getConnectionCounter() + "): " + (isAnonymous ? "" : localpart) + "@" + String.valueOf(this.connection.getXMPPServiceDomain()) + ":" + this.connection.getPort();
        title = title + "/" + String.valueOf(user.getResourcepart());
        this.log(title);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public void onIncomingStreamElement(TopLevelStreamElement streamElement) {
        if (printInterpreted) {
            this.log("RCV PKT (" + this.connection.getConnectionCounter() + "): " + String.valueOf(streamElement.toXML()));
        }
    }

    @Override
    public void onOutgoingStreamElement(TopLevelStreamElement streamElement) {
    }
}

