/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import org.jivesoftware.smack.util.StringUtils;

public class ContentId {
    private final String hash;
    private final String hashType;
    private final String cid;

    private ContentId(String hash, String hashType, String cid) {
        this.hash = StringUtils.requireNotNullNorEmpty(hash, "hash must not be null nor empty");
        this.hashType = StringUtils.requireNotNullNorEmpty(hashType, "hashType must not be null nor empty");
        this.cid = cid;
    }

    public ContentId(String hash, String hashType) {
        this(hash, hashType, hashType + "+" + hash + "@bob.xmpp.org");
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashType() {
        return this.hashType;
    }

    public String toSrc() {
        return "cid:" + this.getCid();
    }

    public String getCid() {
        return this.cid;
    }

    public boolean equals(Object other) {
        if (other instanceof ContentId) {
            ContentId otherBob = (ContentId)other;
            return this.cid.equals(otherBob.cid);
        }
        return false;
    }

    public int hashCode() {
        return this.cid.hashCode();
    }

    public static ContentId fromSrc(String src) {
        String hashType = src.substring(src.lastIndexOf("cid:") + 4, src.indexOf("+"));
        String hash = src.substring(src.indexOf("+") + 1, src.indexOf("@bob.xmpp.org"));
        return new ContentId(hash, hashType);
    }

    public static ContentId fromCid(String cid) {
        String hashType = cid.substring(0, cid.indexOf("+"));
        String hash = cid.substring(cid.indexOf("+") + 1, cid.indexOf("@bob.xmpp.org"));
        return new ContentId(hash, hashType, cid);
    }
}

