/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.util.Util;

public class OpenPgpElement
implements ExtensionElement {
    public static final String ELEMENT = "openpgp";
    public static final String NAMESPACE = "urn:xmpp:openpgp:0";
    public static final QName QNAME = new QName("urn:xmpp:openpgp:0", "openpgp");
    private final String base64EncodedOpenPgpMessage;

    public OpenPgpElement(String base64EncodedOpenPgpMessage) {
        this.base64EncodedOpenPgpMessage = StringUtils.requireNotNullNorEmpty(base64EncodedOpenPgpMessage, "base64 encoded message MUST NOT be null nor empty.");
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(Base64.decode(this.base64EncodedOpenPgpMessage.getBytes(Util.UTF8)));
    }

    public String getEncryptedBase64MessageContent() {
        return this.base64EncodedOpenPgpMessage;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public QName getQName() {
        return QNAME;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.rightAngleBracket().append(this.base64EncodedOpenPgpMessage).closeElement(this);
        return xml;
    }

    public static OpenPgpElement fromStanza(Stanza stanza) {
        return stanza.getExtension(OpenPgpElement.class);
    }
}

