/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.exceptions.JBBPNumericFieldValueConversionException;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import java.util.Locale;

public strictfp final class JBBPFieldUInt
extends JBBPAbstractField
implements JBBPNumericField {
    public static final String TYPE_NAME = "uint";
    private static final long serialVersionUID = 354342324375674L;
    private final int value;

    public JBBPFieldUInt(JBBPNamedFieldInfo name, long value) {
        super(name);
        this.value = (int)value;
    }

    @Override
    public int getAsInt() {
        if (this.value >= 0) {
            return this.value;
        }
        throw new JBBPNumericFieldValueConversionException(this, "UINT 0x" + Long.toHexString((long)this.value & 0xFFFFFFFFL).toUpperCase(Locale.ENGLISH) + " can't be represented as INT");
    }

    @Override
    public double getAsDouble() {
        return this.getAsLong();
    }

    @Override
    public float getAsFloat() {
        return this.getAsLong();
    }

    @Override
    public long getAsLong() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldUInt.reverseBits((long)this.value & 0xFFFFFFFFL);
    }

    public static long reverseBits(long value) {
        return JBBPFieldInt.reverseBits((int)value) & 0xFFFFFFFFL;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }
}

