<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# hashset

```go
import "github.com/zyedidia/generic/hashset"
```

Package hashset provides an implementation of a hashset.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	g "github.com/zyedidia/generic"
	"github.com/zyedidia/generic/hashset"
)

func main() {
	set := hashset.New[string](3, g.Equals[string], g.HashString)
	set.Put("foo")
	set.Put("bar")
	set.Put("baz")

	fmt.Println(set.Has("foo"))
	fmt.Println(set.Has("quux"))

	set.Remove("foo")

	fmt.Println(set.Has("foo"))
	fmt.Println(set.Has("bar"))

	set.Clear()

	fmt.Println(set.Has("foo"))
	fmt.Println(set.Has("bar"))
}
```

#### Output

```
true
false
false
true
false
false
```

</p>
</details>

## Index

- [type Set](<#type-set>)
  - [func New[K any](capacity uint64, equals g.EqualsFn[K], hash g.HashFn[K]) *Set[K]](<#func-new>)
  - [func Of[K comparable](capacity uint64, equals g.EqualsFn[K], hash g.HashFn[K], vals ...K) *Set[K]](<#func-of>)
  - [func (s *Set[K]) Clear()](<#func-setk-clear>)
  - [func (s *Set[K]) Copy() *Set[K]](<#func-setk-copy>)
  - [func (s *Set[K]) Each(fn func(key K))](<#func-setk-each>)
  - [func (s *Set[K]) Has(val K) bool](<#func-setk-has>)
  - [func (s *Set[K]) Put(val K)](<#func-setk-put>)
  - [func (s *Set[K]) Remove(val K)](<#func-setk-remove>)
  - [func (s *Set[K]) Size() int](<#func-setk-size>)


## type [Set](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L10-L12>)

Set implements a hashset, using the hashmap as the underlying storage.

```go
type Set[K any] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L15>)

```go
func New[K any](capacity uint64, equals g.EqualsFn[K], hash g.HashFn[K]) *Set[K]
```

New returns an empty hashset.

### func [Of](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L22>)

```go
func Of[K comparable](capacity uint64, equals g.EqualsFn[K], hash g.HashFn[K], vals ...K) *Set[K]
```

Of returns a new hashset initialized with the given 'vals'

### func \(\*Set\[K\]\) [Clear](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L47>)

```go
func (s *Set[K]) Clear()
```

Clear removes all elements from the set.

### func \(\*Set\[K\]\) [Copy](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L64>)

```go
func (s *Set[K]) Copy() *Set[K]
```

Copy returns a copy of this set.

### func \(\*Set\[K\]\) [Each](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L57>)

```go
func (s *Set[K]) Each(fn func(key K))
```

Each calls 'fn' on every item in the set in no particular order.

### func \(\*Set\[K\]\) [Has](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L36>)

```go
func (s *Set[K]) Has(val K) bool
```

Has returns true only if 'val' is in the set.

### func \(\*Set\[K\]\) [Put](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L31>)

```go
func (s *Set[K]) Put(val K)
```

Put adds 'val' to the set.

### func \(\*Set\[K\]\) [Remove](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L42>)

```go
func (s *Set[K]) Remove(val K)
```

Remove removes 'val' from the set.

### func \(\*Set\[K\]\) [Size](<https://github.com/zyedidia/generic/blob/master/hashset/set.go#L52>)

```go
func (s *Set[K]) Size() int
```

Size returns the number of elements in the set.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
