<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# list

```go
import "github.com/zyedidia/generic/list"
```

Package list provides an implementation of a doubly\-linked list with a front and back. The individual nodes of the list are publicly exposed so that the user can have fine\-grained control over the list.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	"github.com/zyedidia/generic/list"
)

func main() {
	l := list.New[int]()
	l.PushBack(0)
	l.PushBack(1)
	l.PushBack(2)
	l.PushBack(3)

	l.Front.Each(func(i int) {
		fmt.Println(i)
	})
}
```

#### Output

```
0
1
2
3
```

</p>
</details>

## Index

- [type List](<#type-list>)
  - [func New[V any]() *List[V]](<#func-new>)
  - [func (l *List[V]) PushBack(v V)](<#func-listv-pushback>)
  - [func (l *List[V]) PushBackNode(n *Node[V])](<#func-listv-pushbacknode>)
  - [func (l *List[V]) PushFront(v V)](<#func-listv-pushfront>)
  - [func (l *List[V]) PushFrontNode(n *Node[V])](<#func-listv-pushfrontnode>)
  - [func (l *List[V]) Remove(n *Node[V])](<#func-listv-remove>)
- [type Node](<#type-node>)
  - [func (n *Node[V]) Each(fn func(val V))](<#func-nodev-each>)
  - [func (n *Node[V]) EachReverse(fn func(val V))](<#func-nodev-eachreverse>)


## type [List](<https://github.com/zyedidia/generic/blob/master/list/list.go#L7-L9>)

List implements a doubly\-linked list.

```go
type List[V any] struct {
    Front, Back *Node[V]
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/list/list.go#L18>)

```go
func New[V any]() *List[V]
```

New returns an empty linked list.

### func \(\*List\[V\]\) [PushBack](<https://github.com/zyedidia/generic/blob/master/list/list.go#L23>)

```go
func (l *List[V]) PushBack(v V)
```

PushBack adds 'v' to the end of the list.

### func \(\*List\[V\]\) [PushBackNode](<https://github.com/zyedidia/generic/blob/master/list/list.go#L37>)

```go
func (l *List[V]) PushBackNode(n *Node[V])
```

PushBackNode adds the node 'n' to the back of the list.

### func \(\*List\[V\]\) [PushFront](<https://github.com/zyedidia/generic/blob/master/list/list.go#L30>)

```go
func (l *List[V]) PushFront(v V)
```

PushFront adds 'v' to the beginning of the list.

### func \(\*List\[V\]\) [PushFrontNode](<https://github.com/zyedidia/generic/blob/master/list/list.go#L49>)

```go
func (l *List[V]) PushFrontNode(n *Node[V])
```

PushFrontNode adds the node 'n' to the front of the list.

### func \(\*List\[V\]\) [Remove](<https://github.com/zyedidia/generic/blob/master/list/list.go#L61>)

```go
func (l *List[V]) Remove(n *Node[V])
```

Remove removes the node 'n' from the list.

## type [Node](<https://github.com/zyedidia/generic/blob/master/list/list.go#L12-L15>)

Node is a node in the linked list.

```go
type Node[V any] struct {
    Value      V
    Prev, Next *Node[V]
}
```

### func \(\*Node\[V\]\) [Each](<https://github.com/zyedidia/generic/blob/master/list/list.go#L75>)

```go
func (n *Node[V]) Each(fn func(val V))
```

Each calls 'fn' on every element from this node onward in the list.

### func \(\*Node\[V\]\) [EachReverse](<https://github.com/zyedidia/generic/blob/master/list/list.go#L84>)

```go
func (n *Node[V]) EachReverse(fn func(val V))
```

EachReverse calls 'fn' on every element from this node backward in the list.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
