import { globalHistory } from "@reach/router";
import { useState } from "react";
function makeAdapter() {
  const adapter = {
    replace(location) {
      globalHistory.navigate(location.search || "?", {
        replace: true,
        state: location.state
      });
    },
    push(location) {
      globalHistory.navigate(location.search || "?", {
        replace: false,
        state: location.state
      });
    },
    get location() {
      return globalHistory.location;
    }
  };
  return adapter;
}
const ReachAdapter = ({ children }) => {
  const [adapter] = useState(makeAdapter);
  return children(adapter);
};
export {
  ReachAdapter
};
