/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.jna.Platform;
import java.awt.Component;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.formats.v2.SubtitleType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbc.JdbcSQLException;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAMediaDatabase
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DLNAMediaDatabase.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private String url;
    private String dbDir;
    private String dbName;
    public static final String NONAME = "###";
    private Thread scanner;
    private JdbcConnectionPool cp;
    private int dbCount;
    private final int SIZE_CODECV = 32;
    private final int SIZE_FRAMERATE = 32;
    private final int SIZE_ASPECT = 32;
    private final int SIZE_ASPECTRATIO_CONTAINER = 5;
    private final int SIZE_ASPECTRATIO_VIDEOTRACK = 5;
    private final int SIZE_AVC_LEVEL = 3;
    private final int SIZE_CONTAINER = 32;
    private final int SIZE_MODEL = 128;
    private final int SIZE_MUXINGMODE = 32;
    private final int SIZE_FRAMERATE_MODE = 16;
    private final int SIZE_LANG = 3;
    private final int SIZE_FLAVOR = 128;
    private final int SIZE_SAMPLEFREQ = 16;
    private final int SIZE_CODECA = 32;
    private final int SIZE_ALBUM = 255;
    private final int SIZE_ARTIST = 255;
    private final int SIZE_SONGNAME = 255;
    private final int SIZE_GENRE = 64;

    public DLNAMediaDatabase(String name) {
        String dir = "database";
        this.dbName = name;
        File fileDir = new File(dir);
        if (Platform.isWindows()) {
            String profileDir = configuration.getProfileDirectory();
            this.url = String.format("jdbc:h2:%s\\%s/%s", profileDir, dir, this.dbName);
            fileDir = new File(profileDir, dir);
        } else {
            this.url = "jdbc:h2:" + dir + "/" + this.dbName;
        }
        this.dbDir = fileDir.getAbsolutePath();
        logger.debug("Using database URL: " + this.url);
        logger.info("Using database located at: " + this.dbDir);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            logger.error(null, e);
        }
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.url);
        ds.setUser("sa");
        ds.setPassword("");
        this.cp = JdbcConnectionPool.create(ds);
    }

    private Connection getConnection() throws SQLException {
        return this.cp.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean force) {
        boolean force_reinit;
        this.dbCount = -1;
        String version = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
        }
        catch (SQLException se) {
            File dbFile = new File(this.dbDir + File.separator + this.dbName + ".data.db");
            File dbDirectory = new File(this.dbDir);
            if (dbFile.exists() || se.getErrorCode() == 90048) {
                FileUtils.deleteQuietly(dbDirectory);
                if (!dbDirectory.exists()) {
                    logger.debug("The cache has been deleted because it was corrupt or had the wrong version");
                }
                if (!PMS.isHeadless()) {
                    JOptionPane.showMessageDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), String.format(Messages.getString("DLNAMediaDatabase.5"), this.dbDir), Messages.getString("Dialog.Error"), 0);
                }
                logger.debug("Damaged cache can't be deleted. Stop the program and delete the folder \"" + this.dbDir + "\" manually");
                configuration.setUseCache(false);
                return;
            }
            logger.debug("Cache connection error: " + se.getMessage());
            configuration.setUseCache(false);
            return;
        }
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM FILES");
            if (rs.next()) {
                this.dbCount = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT VALUE FROM METADATA WHERE KEY = 'VERSION'");
            if (rs.next()) {
                version = rs.getString(1);
            }
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() != 42102) {
                    logger.error(null, se);
                }
                this.close(rs);
                this.close(stmt);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        boolean bl = force_reinit = !PMS.getVersion().equals(version);
        if (force || this.dbCount == -1 || force_reinit) {
            block22: {
                logger.debug("Database will be (re)initialized");
                try {
                    conn = this.getConnection();
                    this.executeUpdate(conn, "DROP TABLE FILES");
                    this.executeUpdate(conn, "DROP TABLE METADATA");
                    this.executeUpdate(conn, "DROP TABLE REGEXP_RULES");
                    this.executeUpdate(conn, "DROP TABLE AUDIOTRACKS");
                    this.executeUpdate(conn, "DROP TABLE SUBTRACKS");
                }
                catch (SQLException se) {
                    if (se.getErrorCode() == 42102) break block22;
                    logger.error(null, se);
                }
            }
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE FILES (");
                sb.append("  ID                INT AUTO_INCREMENT");
                sb.append(", FILENAME          VARCHAR2(1024)       NOT NULL");
                sb.append(", MODIFIED          TIMESTAMP            NOT NULL");
                sb.append(", TYPE              INT");
                sb.append(", DURATION          DOUBLE");
                sb.append(", BITRATE           INT");
                sb.append(", WIDTH             INT");
                sb.append(", HEIGHT            INT");
                sb.append(", SIZE              NUMERIC");
                sb.append(", CODECV            VARCHAR2(").append(32).append(")");
                sb.append(", FRAMERATE         VARCHAR2(").append(32).append(")");
                sb.append(", ASPECT            VARCHAR2(").append(32).append(")");
                sb.append(", ASPECTRATIOCONTAINER    VARCHAR2(").append(5).append(")");
                sb.append(", ASPECTRATIOVIDEOTRACK   VARCHAR2(").append(5).append(")");
                sb.append(", REFRAMES          TINYINT");
                sb.append(", AVCLEVEL          VARCHAR2(").append(3).append(")");
                sb.append(", BITSPERPIXEL      INT");
                sb.append(", THUMB             BINARY");
                sb.append(", CONTAINER         VARCHAR2(").append(32).append(")");
                sb.append(", MODEL             VARCHAR2(").append(128).append(")");
                sb.append(", EXPOSURE          INT");
                sb.append(", ORIENTATION       INT");
                sb.append(", ISO               INT");
                sb.append(", MUXINGMODE        VARCHAR2(").append(32).append(")");
                sb.append(", FRAMERATEMODE     VARCHAR2(").append(16).append(")");
                sb.append(", constraint PK1 primary key (FILENAME, MODIFIED, ID))");
                this.executeUpdate(conn, sb.toString());
                sb = new StringBuilder();
                sb.append("CREATE TABLE AUDIOTRACKS (");
                sb.append("  FILEID            INT              NOT NULL");
                sb.append(", ID                INT              NOT NULL");
                sb.append(", LANG              VARCHAR2(").append(3).append(")");
                sb.append(", FLAVOR            VARCHAR2(").append(128).append(")");
                sb.append(", NRAUDIOCHANNELS   NUMERIC");
                sb.append(", SAMPLEFREQ        VARCHAR2(").append(16).append(")");
                sb.append(", CODECA            VARCHAR2(").append(32).append(")");
                sb.append(", BITSPERSAMPLE     INT");
                sb.append(", ALBUM             VARCHAR2(").append(255).append(")");
                sb.append(", ARTIST            VARCHAR2(").append(255).append(")");
                sb.append(", SONGNAME          VARCHAR2(").append(255).append(")");
                sb.append(", GENRE             VARCHAR2(").append(64).append(")");
                sb.append(", YEAR              INT");
                sb.append(", TRACK             INT");
                sb.append(", DELAY             INT");
                sb.append(", MUXINGMODE        VARCHAR2(").append(32).append(")");
                sb.append(", BITRATE           INT");
                sb.append(", constraint PKAUDIO primary key (FILEID, ID))");
                this.executeUpdate(conn, sb.toString());
                sb = new StringBuilder();
                sb.append("CREATE TABLE SUBTRACKS (");
                sb.append("  FILEID            INT              NOT NULL");
                sb.append(", ID                INT              NOT NULL");
                sb.append(", LANG              VARCHAR2(").append(3).append(")");
                sb.append(", FLAVOR            VARCHAR2(").append(128).append(")");
                sb.append(", TYPE              INT");
                sb.append(", constraint PKSUB primary key (FILEID, ID))");
                this.executeUpdate(conn, sb.toString());
                this.executeUpdate(conn, "CREATE TABLE METADATA (KEY VARCHAR2(255) NOT NULL, VALUE VARCHAR2(255) NOT NULL)");
                this.executeUpdate(conn, "INSERT INTO METADATA VALUES ('VERSION', '" + PMS.getVersion() + "')");
                this.executeUpdate(conn, "CREATE INDEX IDXARTIST on AUDIOTRACKS (ARTIST asc);");
                this.executeUpdate(conn, "CREATE INDEX IDXALBUM on AUDIOTRACKS (ALBUM asc);");
                this.executeUpdate(conn, "CREATE INDEX IDXGENRE on AUDIOTRACKS (GENRE asc);");
                this.executeUpdate(conn, "CREATE INDEX IDXYEAR on AUDIOTRACKS (YEAR asc);");
                this.executeUpdate(conn, "CREATE TABLE REGEXP_RULES ( ID VARCHAR2(255) PRIMARY KEY, RULE VARCHAR2(255), ORDR NUMERIC);");
                this.executeUpdate(conn, "INSERT INTO REGEXP_RULES VALUES ( '###', '(?i)^\\W.+', 0 );");
                this.executeUpdate(conn, "INSERT INTO REGEXP_RULES VALUES ( '0-9', '(?i)^\\d.+', 1 );");
                String[] chars = Messages.getString("DLNAMediaDatabase.1").split(",");
                for (int i = 0; i < chars.length; ++i) {
                    this.executeUpdate(conn, "INSERT INTO REGEXP_RULES VALUES ( '" + chars[i] + "', '(?i)^" + chars[i] + ".+', " + (i + 2) + " );");
                }
                logger.debug("Database initialized");
            }
            catch (SQLException se) {
                logger.info("Error in table creation: " + se.getMessage());
            }
            finally {
                this.close(conn);
            }
        } else {
            logger.debug("Database file count: " + this.dbCount);
            logger.debug("Database version: " + version);
        }
    }

    private void executeUpdate(Connection conn, String sql) throws SQLException {
        if (conn != null) {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataExists(String name, long modified) {
        boolean found = false;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement("SELECT * FROM FILES WHERE FILENAME = ? AND MODIFIED = ?");
            stmt.setString(1, name);
            stmt.setTimestamp(2, new Timestamp(modified));
            rs = stmt.executeQuery();
            while (rs.next()) {
                found = true;
            }
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        catch (SQLException se) {
            logger.error(null, se);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DLNAMediaInfo> getData(String name, long modified) {
        ArrayList<DLNAMediaInfo> list = new ArrayList<DLNAMediaInfo>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement("SELECT * FROM FILES WHERE FILENAME = ? AND MODIFIED = ?");
            stmt.setString(1, name);
            stmt.setTimestamp(2, new Timestamp(modified));
            rs = stmt.executeQuery();
            while (rs.next()) {
                DLNAMediaInfo media = new DLNAMediaInfo();
                int id = rs.getInt("ID");
                media.setDuration(this.toDouble(rs, "DURATION"));
                media.setBitrate(rs.getInt("BITRATE"));
                media.setWidth(rs.getInt("WIDTH"));
                media.setHeight(rs.getInt("HEIGHT"));
                media.setSize(rs.getLong("SIZE"));
                media.setCodecV(rs.getString("CODECV"));
                media.setFrameRate(rs.getString("FRAMERATE"));
                media.setAspect(rs.getString("ASPECT"));
                media.setAspectRatioContainer(rs.getString("ASPECTRATIOCONTAINER"));
                media.setAspectRatioVideoTrack(rs.getString("ASPECTRATIOVIDEOTRACK"));
                media.setReferenceFrameCount(rs.getByte("REFRAMES"));
                media.setAvcLevel(rs.getString("AVCLEVEL"));
                media.setBitsPerPixel(rs.getInt("BITSPERPIXEL"));
                media.setThumb(rs.getBytes("THUMB"));
                media.setContainer(rs.getString("CONTAINER"));
                media.setModel(rs.getString("MODEL"));
                if (media.getModel() != null && !"jpg".equals(media.getContainer())) {
                    media.setExtrasAsString(media.getModel());
                }
                media.setExposure(rs.getInt("EXPOSURE"));
                media.setOrientation(rs.getInt("ORIENTATION"));
                media.setIso(rs.getInt("ISO"));
                media.setMuxingMode(rs.getString("MUXINGMODE"));
                media.setFrameRateMode(rs.getString("FRAMERATEMODE"));
                media.setMediaparsed(true);
                PreparedStatement audios = conn.prepareStatement("SELECT * FROM AUDIOTRACKS WHERE FILEID = ?");
                audios.setInt(1, id);
                ResultSet subrs = audios.executeQuery();
                while (subrs.next()) {
                    DLNAMediaAudio audio = new DLNAMediaAudio();
                    audio.setId(subrs.getInt("ID"));
                    audio.setLang(subrs.getString("LANG"));
                    audio.setFlavor(subrs.getString("FLAVOR"));
                    audio.getAudioProperties().setNumberOfChannels(subrs.getInt("NRAUDIOCHANNELS"));
                    audio.setSampleFrequency(subrs.getString("SAMPLEFREQ"));
                    audio.setCodecA(subrs.getString("CODECA"));
                    audio.setBitsperSample(subrs.getInt("BITSPERSAMPLE"));
                    audio.setAlbum(subrs.getString("ALBUM"));
                    audio.setArtist(subrs.getString("ARTIST"));
                    audio.setSongname(subrs.getString("SONGNAME"));
                    audio.setGenre(subrs.getString("GENRE"));
                    audio.setYear(subrs.getInt("YEAR"));
                    audio.setTrack(subrs.getInt("TRACK"));
                    audio.getAudioProperties().setAudioDelay(subrs.getInt("DELAY"));
                    audio.setMuxingModeAudio(subrs.getString("MUXINGMODE"));
                    audio.setBitRate(subrs.getInt("BITRATE"));
                    media.getAudioTracksList().add(audio);
                }
                subrs.close();
                audios.close();
                PreparedStatement subs = conn.prepareStatement("SELECT * FROM SUBTRACKS WHERE FILEID = ?");
                subs.setInt(1, id);
                subrs = subs.executeQuery();
                while (subrs.next()) {
                    DLNAMediaSubtitle sub = new DLNAMediaSubtitle();
                    sub.setId(subrs.getInt("ID"));
                    sub.setLang(subrs.getString("LANG"));
                    sub.setFlavor(subrs.getString("FLAVOR"));
                    sub.setType(SubtitleType.valueOfStableIndex(subrs.getInt("TYPE")));
                    media.getSubtitleTracksList().add(sub);
                }
                subrs.close();
                subs.close();
                list.add(media);
            }
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        catch (SQLException se) {
            logger.error(null, se);
            ArrayList<DLNAMediaInfo> arrayList = null;
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        return list;
    }

    private Double toDouble(ResultSet rs, String column) throws SQLException {
        Object obj = rs.getObject(column);
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertData(String name, long modified, int type, DLNAMediaInfo media) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("INSERT INTO FILES(FILENAME, MODIFIED, TYPE, DURATION, BITRATE, WIDTH, HEIGHT, SIZE, CODECV, FRAMERATE, ASPECT, ASPECTRATIOCONTAINER, ASPECTRATIOVIDEOTRACK, REFRAMES, AVCLEVEL, BITSPERPIXEL, THUMB, CONTAINER, MODEL, EXPOSURE, ORIENTATION, ISO, MUXINGMODE, FRAMERATEMODE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setString(1, name);
            ps.setTimestamp(2, new Timestamp(modified));
            ps.setInt(3, type);
            if (media != null) {
                if (media.getDuration() != null) {
                    ps.setDouble(4, media.getDurationInSeconds());
                } else {
                    ps.setNull(4, 8);
                }
                int databaseBitrate = 0;
                if (type != 2 && (databaseBitrate = media.getBitrate()) == 0) {
                    logger.debug("Could not parse the bitrate from: " + name);
                }
                ps.setInt(5, databaseBitrate);
                ps.setInt(6, media.getWidth());
                ps.setInt(7, media.getHeight());
                ps.setLong(8, media.getSize());
                ps.setString(9, StringUtils.left(media.getCodecV(), 32));
                ps.setString(10, StringUtils.left(media.getFrameRate(), 32));
                ps.setString(11, StringUtils.left(media.getAspect(), 32));
                ps.setString(12, StringUtils.left(media.getAspect(), 5));
                ps.setString(13, StringUtils.left(media.getAspect(), 5));
                ps.setByte(14, media.getReferenceFrameCount());
                ps.setString(15, StringUtils.left(media.getAvcLevel(), 3));
                ps.setInt(16, media.getBitsPerPixel());
                ps.setBytes(17, media.getThumb());
                ps.setString(18, StringUtils.left(media.getContainer(), 32));
                if (media.getExtras() != null) {
                    ps.setString(19, StringUtils.left(media.getExtrasAsString(), 128));
                } else {
                    ps.setString(19, StringUtils.left(media.getModel(), 128));
                }
                ps.setInt(20, media.getExposure());
                ps.setInt(21, media.getOrientation());
                ps.setInt(22, media.getIso());
                ps.setString(23, StringUtils.left(media.getMuxingModeAudio(), 32));
                ps.setString(24, StringUtils.left(media.getFrameRateMode(), 16));
            } else {
                ps.setString(4, null);
                ps.setInt(5, 0);
                ps.setInt(6, 0);
                ps.setInt(7, 0);
                ps.setLong(8, 0L);
                ps.setString(9, null);
                ps.setString(10, null);
                ps.setString(11, null);
                ps.setString(12, null);
                ps.setString(13, null);
                ps.setByte(14, (byte)-1);
                ps.setString(15, null);
                ps.setInt(16, 0);
                ps.setBytes(17, null);
                ps.setString(18, null);
                ps.setString(19, null);
                ps.setInt(20, 0);
                ps.setInt(21, 0);
                ps.setInt(22, 0);
                ps.setString(23, null);
                ps.setString(24, null);
            }
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            int id = -1;
            while (rs.next()) {
                id = rs.getInt(1);
            }
            rs.close();
            if (media != null && id > -1) {
                PreparedStatement insert = null;
                if (media.getAudioTracksList().size() > 0) {
                    insert = conn.prepareStatement("INSERT INTO AUDIOTRACKS VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                }
                for (DLNAMediaAudio audio : media.getAudioTracksList()) {
                    insert.clearParameters();
                    insert.setInt(1, id);
                    insert.setInt(2, audio.getId());
                    insert.setString(3, StringUtils.left(audio.getLang(), 3));
                    insert.setString(4, StringUtils.left(audio.getFlavor(), 128));
                    insert.setInt(5, audio.getAudioProperties().getNumberOfChannels());
                    insert.setString(6, StringUtils.left(audio.getSampleFrequency(), 16));
                    insert.setString(7, StringUtils.left(audio.getCodecA(), 32));
                    insert.setInt(8, audio.getBitsperSample());
                    insert.setString(9, StringUtils.left(StringUtils.trimToEmpty(audio.getAlbum()), 255));
                    insert.setString(10, StringUtils.left(StringUtils.trimToEmpty(audio.getArtist()), 255));
                    insert.setString(11, StringUtils.left(StringUtils.trimToEmpty(audio.getSongname()), 255));
                    insert.setString(12, StringUtils.left(StringUtils.trimToEmpty(audio.getGenre()), 64));
                    insert.setInt(13, audio.getYear());
                    insert.setInt(14, audio.getTrack());
                    insert.setInt(15, audio.getAudioProperties().getAudioDelay());
                    insert.setString(16, StringUtils.left(StringUtils.trimToEmpty(audio.getMuxingModeAudio()), 32));
                    insert.setInt(17, audio.getBitRate());
                    try {
                        insert.executeUpdate();
                    }
                    catch (JdbcSQLException e) {
                        if (e.getErrorCode() == 23505) {
                            logger.debug("A duplicate key error occurred while trying to store the following file's audio information in the database: " + name);
                        } else {
                            logger.debug("An error occurred while trying to store the following file's audio information in the database: " + name);
                        }
                        logger.debug("The error given by jdbc was: " + e);
                    }
                }
                if (media.getSubtitleTracksList().size() > 0) {
                    insert = conn.prepareStatement("INSERT INTO SUBTRACKS VALUES (?, ?, ?, ?, ?)");
                }
                for (DLNAMediaSubtitle sub : media.getSubtitleTracksList()) {
                    if (sub.getExternalFile() != null) continue;
                    insert.clearParameters();
                    insert.setInt(1, id);
                    insert.setInt(2, sub.getId());
                    insert.setString(3, StringUtils.left(sub.getLang(), 3));
                    insert.setString(4, StringUtils.left(sub.getFlavor(), 128));
                    insert.setInt(5, sub.getType().getStableIndex());
                    try {
                        insert.executeUpdate();
                    }
                    catch (JdbcSQLException e) {
                        if (e.getErrorCode() == 23505) {
                            logger.debug("A duplicate key error occurred while trying to store the following file's subtitle information in the database: " + name);
                        } else {
                            logger.debug("An error occurred while trying to store the following file's subtitle information in the database: " + name);
                        }
                        logger.debug("The error given by jdbc was: " + e);
                    }
                }
                this.close(insert);
            }
            this.close(ps);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() == 23001) {
                    logger.debug("Duplicate key while inserting this entry: " + name + " into the database: " + se.getMessage());
                } else {
                    logger.error(null, se);
                }
                this.close(ps);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateThumbnail(String name, long modified, int type, DLNAMediaInfo media) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("UPDATE FILES SET THUMB = ? WHERE FILENAME = ? AND MODIFIED = ?");
            ps.setString(2, name);
            ps.setTimestamp(3, new Timestamp(modified));
            if (media != null) {
                ps.setBytes(1, media.getThumb());
            } else {
                ps.setNull(1, -2);
            }
            ps.executeUpdate();
            this.close(ps);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() == 23001) {
                    logger.debug("Duplicate key while inserting this entry: " + name + " into the database: " + se.getMessage());
                } else {
                    logger.error(null, se);
                }
                this.close(ps);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getStrings(String sql) {
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String str = rs.getString(1);
                if (StringUtils.isBlank(str)) {
                    if (list.contains(NONAME)) continue;
                    list.add(NONAME);
                    continue;
                }
                if (list.contains(str)) continue;
                list.add(str);
            }
            this.close(rs);
            this.close(ps);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                logger.error(null, se);
                ArrayList<String> arrayList = null;
                this.close(rs);
                this.close(ps);
                this.close(conn);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(ps);
                this.close(conn);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("SELECT COUNT(*) FROM FILES");
            rs = ps.executeQuery();
            this.dbCount = 0;
            if (rs.next()) {
                this.dbCount = rs.getInt(1);
            }
            rs.close();
            ps.close();
            PMS.get().getFrame().setStatusLine(Messages.getString("DLNAMediaDatabase.2") + " 0%");
            int i = 0;
            int oldpercent = 0;
            if (this.dbCount > 0) {
                ps = conn.prepareStatement("SELECT FILENAME, MODIFIED, ID FROM FILES", 1003, 1008);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int newpercent;
                    String filename = rs.getString("FILENAME");
                    long modified = rs.getTimestamp("MODIFIED").getTime();
                    File file = new File(filename);
                    if (!file.exists() || file.lastModified() != modified) {
                        rs.deleteRow();
                    }
                    if ((newpercent = ++i * 100 / this.dbCount) <= oldpercent) continue;
                    PMS.get().getFrame().setStatusLine(Messages.getString("DLNAMediaDatabase.2") + newpercent + "%");
                    oldpercent = newpercent;
                }
            }
            this.close(rs);
            this.close(ps);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                logger.error(null, se);
                this.close(rs);
                this.close(ps);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(ps);
                this.close(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<File> getFiles(String sql) {
        ArrayList<File> list = new ArrayList<File>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql.toLowerCase().startsWith("select") ? sql : "SELECT FILENAME, MODIFIED FROM FILES WHERE " + sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String filename = rs.getString("FILENAME");
                long modified = rs.getTimestamp("MODIFIED").getTime();
                File file = new File(filename);
                if (!file.exists() || file.lastModified() != modified) continue;
                list.add(file);
            }
            this.close(rs);
            this.close(ps);
            this.close(conn);
        }
        catch (SQLException se) {
            try {
                logger.error(null, se);
                ArrayList<File> arrayList = null;
                this.close(rs);
                this.close(ps);
                this.close(conn);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(ps);
                this.close(conn);
                throw throwable;
            }
        }
        return list;
    }

    private void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            logger.error("error during closing:" + e.getMessage(), e);
        }
    }

    private void close(Statement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            logger.error("error during closing:" + e.getMessage(), e);
        }
    }

    private void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error("error during closing:" + e.getMessage(), e);
        }
    }

    public synchronized boolean isScanLibraryRunning() {
        return this.scanner != null && this.scanner.isAlive();
    }

    public synchronized void scanLibrary() {
        if (this.scanner == null) {
            this.scanner = new Thread((Runnable)this, "Library Scanner");
            this.scanner.start();
        } else if (this.scanner.isAlive()) {
            logger.info("Scanner is already running !");
        } else {
            this.scanner = new Thread((Runnable)this, "Library Scanner");
            this.scanner.start();
        }
    }

    public synchronized void stopScanLibrary() {
        if (this.scanner != null && this.scanner.isAlive()) {
            PMS.get().getRootFolder(null).stopScan();
        }
    }

    @Override
    public void run() {
        PMS.get().getRootFolder(null).scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        logger.info("Compacting database...");
        PMS.get().getFrame().setStatusLine(Messages.getString("DLNAMediaDatabase.3"));
        String filename = "database/backup.sql";
        try {
            Script.execute(this.url, "sa", "", filename);
            DeleteDbFiles.execute(this.dbDir, this.dbName, true);
            RunScript.execute(this.url, "sa", "", filename, null, false);
        }
        catch (SQLException se) {
            logger.error("Error in compacting database: ", se);
        }
        finally {
            File testsql = new File(filename);
            if (testsql.exists() && !testsql.delete()) {
                testsql.deleteOnExit();
            }
        }
        PMS.get().getFrame().setStatusLine(null);
    }
}

