/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.FFmpegAudio;
import net.pms.encoders.FFmpegAviSynthVideo;
import net.pms.encoders.FFmpegDVRMSRemux;
import net.pms.encoders.FFmpegVideo;
import net.pms.encoders.FFmpegWebAudio;
import net.pms.encoders.FFmpegWebVideo;
import net.pms.encoders.MEncoderAviSynth;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.MEncoderWebVideo;
import net.pms.encoders.Player;
import net.pms.encoders.RAWThumbnailer;
import net.pms.encoders.TsMuxeRAudio;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.encoders.VLCVideo;
import net.pms.encoders.VLCWebVideo;
import net.pms.encoders.VideoLanAudioStreaming;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.formats.Format;
import net.pms.io.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlayerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PlayerFactory.class);
    private static ArrayList<Player> players = new ArrayList();
    private static ArrayList<Player> allPlayers = new ArrayList();
    private static SystemUtils utils;

    private PlayerFactory() {
    }

    public static void initialize(PmsConfiguration configuration) {
        utils = PMS.get().getRegistry();
        PlayerFactory.registerPlayers(configuration);
    }

    private static void registerPlayers(PmsConfiguration configuration) {
        if (Platform.isWindows()) {
            PlayerFactory.registerPlayer(new FFmpegAviSynthVideo(configuration));
        }
        PlayerFactory.registerPlayer(new FFmpegAudio(configuration));
        PlayerFactory.registerPlayer(new MEncoderVideo(configuration));
        if (Platform.isWindows()) {
            PlayerFactory.registerPlayer(new MEncoderAviSynth(configuration));
        }
        PlayerFactory.registerPlayer(new FFmpegVideo(configuration));
        PlayerFactory.registerPlayer(new VLCVideo(configuration));
        PlayerFactory.registerPlayer(new FFmpegWebVideo(configuration));
        PlayerFactory.registerPlayer(new FFmpegWebAudio(configuration));
        PlayerFactory.registerPlayer(new MEncoderWebVideo(configuration));
        PlayerFactory.registerPlayer(new VLCWebVideo(configuration));
        PlayerFactory.registerPlayer(new TsMuxeRVideo(configuration));
        PlayerFactory.registerPlayer(new TsMuxeRAudio(configuration));
        PlayerFactory.registerPlayer(new VideoLanAudioStreaming(configuration));
        PlayerFactory.registerPlayer(new VideoLanVideoStreaming(configuration));
        if (Platform.isWindows()) {
            PlayerFactory.registerPlayer(new FFmpegDVRMSRemux(configuration));
        }
        PlayerFactory.registerPlayer(new RAWThumbnailer(configuration));
        Collections.sort(allPlayers, new PlayerSort(configuration));
        Collections.sort(players, new PlayerSort(configuration));
    }

    public static synchronized void registerPlayer(Player player) {
        boolean ok = false;
        allPlayers.add(player);
        if (player.isNative()) {
            ok = true;
        } else if (Platform.isWindows()) {
            if (player.executable() == null) {
                logger.info("Executable of transcoder profile " + player + " not defined");
                return;
            }
            File executable = new File(player.executable());
            File executable2 = new File(player.executable() + ".exe");
            if (!executable.exists() && !executable2.exists()) {
                logger.info("Executable of transcoder profile " + player + " not found");
                return;
            }
            ok = true;
            if (player.avisynth()) {
                ok = false;
                if (utils.isAvis()) {
                    ok = true;
                } else {
                    logger.info("Transcoder profile " + player + " will not be used because AviSynth was not found");
                }
            }
        } else if (!player.avisynth()) {
            ok = true;
        }
        if (ok) {
            logger.info("Registering transcoding engine: " + player);
            players.add(player);
        }
    }

    public static ArrayList<Player> getAllPlayers() {
        return allPlayers;
    }

    public static ArrayList<Player> getPlayers() {
        return players;
    }

    @Deprecated
    public static Player getPlayer(Class<? extends Player> profileClass, Format ext) {
        for (Player player : players) {
            if (!player.getClass().equals(profileClass) || player.type() != ext.getType() || player.excludeFormat(ext)) continue;
            return player;
        }
        return null;
    }

    public static Player getPlayer(DLNAResource dlna) {
        if (dlna == null) {
            logger.warn("invalid resource (null): no player found");
            return null;
        }
        logger.trace("getting player for {}", (Object)dlna.getName());
        List<String> enabledEngines = PMS.getConfiguration().getEnginesAsList();
        for (Player player : players) {
            boolean enabled = enabledEngines.contains(player.id());
            if (enabled) {
                boolean compatible = player.isCompatible(dlna);
                logger.trace("dlna: {}, player: {}, enabled: {}, compatible: {}", dlna.getName(), player.name(), enabled, compatible);
                if (!compatible) continue;
                return player;
            }
            logger.trace("dlna: {},  player: {}, enabled: {}", dlna.getName(), player.name(), false);
        }
        logger.trace("no player found for {}", (Object)dlna.getName());
        return null;
    }

    @Deprecated
    public static ArrayList<Player> getPlayers(ArrayList<Class<? extends Player>> profileClasses, int type) {
        ArrayList<Player> compatiblePlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (!profileClasses.contains(player.getClass()) || player.type() != type) continue;
            compatiblePlayers.add(player);
        }
        return compatiblePlayers;
    }

    public static ArrayList<Player> getPlayers(DLNAResource resource) {
        if (resource == null) {
            return null;
        }
        List<String> enabledEngines = PMS.getConfiguration().getEnginesAsList();
        ArrayList<Player> compatiblePlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (!enabledEngines.contains(player.id()) || !player.isCompatible(resource)) continue;
            logger.trace("Player " + player.name() + " is compatible with resource " + resource.getName());
            compatiblePlayers.add(player);
        }
        return compatiblePlayers;
    }

    @Deprecated
    public static ArrayList<Player> getEnabledPlayers(DLNAResource resource) {
        return PlayerFactory.getPlayers(resource);
    }

    private static class PlayerSort
    implements Comparator<Player> {
        private PmsConfiguration configuration;

        PlayerSort(PmsConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public int compare(Player player1, Player player2) {
            List<String> prefs = this.configuration.getEnginesAsList();
            Integer index1 = prefs.indexOf(player1.id());
            Integer index2 = prefs.indexOf(player2.id());
            if (index1 == -1) {
                index1 = 999;
            }
            if (index2 == -1) {
                index2 = 999;
            }
            return index1.compareTo(index2);
        }
    }
}

