/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.io.OutputParams;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.FileUtil;
import net.pms.util.FormLayoutUtil;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLCVideo
extends Player {
    private static final Logger logger = LoggerFactory.getLogger(VLCVideo.class);
    protected final PmsConfiguration configuration;
    public static final String ID = "vlctranscoder";
    protected JTextField scale;
    protected JCheckBox experimentalCodecs;
    protected JCheckBox audioSyncEnabled;
    protected JTextField sampleRate;
    protected JCheckBox sampleRateOverride;
    protected JTextField extraParams;

    public VLCVideo(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public String[] args() {
        return new String[0];
    }

    @Override
    public String name() {
        return "VLC Video";
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String mimeType() {
        return "video/transcode";
    }

    @Override
    public String executable() {
        return this.configuration.getVlcPath();
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isVideo(resource) && !PlayerUtil.isWebVideo(resource);
    }

    protected CodecConfig genConfig(RendererConfiguration renderer) {
        CodecConfig codecConfig = new CodecConfig();
        if (renderer.isTranscodeToWMV()) {
            logger.debug("Using XBox WMV codecs");
            codecConfig.videoCodec = "wmv2";
            codecConfig.audioCodec = "wma";
            codecConfig.container = "asf";
        } else {
            codecConfig.videoCodec = "mp2v";
            codecConfig.audioCodec = "mp2a";
            if (renderer.isTranscodeToMPEGTSAC3()) {
                logger.debug("Using standard DLNA codecs with an MPEG-PS container");
                codecConfig.container = "ts";
            } else {
                logger.debug("Using standard DLNA codecs with an MPEG-TS (default) container");
                codecConfig.container = "ps";
            }
        }
        logger.trace("Using " + codecConfig.videoCodec + ", " + codecConfig.audioCodec + ", " + codecConfig.container);
        if (this.sampleRateOverride.isSelected()) {
            codecConfig.sampleRate = Integer.valueOf(this.sampleRate.getText());
        }
        if (this.audioSyncEnabled.isSelected()) {
            codecConfig.extraTrans.put("audio-sync", "");
        }
        return codecConfig;
    }

    protected Map<String, Object> getEncodingArgs(CodecConfig codecConfig) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("vcodec", codecConfig.videoCodec);
        args.put("acodec", codecConfig.audioCodec);
        args.put("vb", "4096");
        args.put("ab", "128");
        args.put("scale", this.scale.getText());
        args.put("channels", 2);
        args.put("samplerate", codecConfig.sampleRate);
        args.put("keyint", 16);
        args.put("strict-rc", null);
        args.put("soverlay", null);
        args.put("threads", "" + this.configuration.getNumberOfCpuCores());
        args.putAll(codecConfig.extraTrans);
        return args;
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String filename = dlna.getSystemName();
        boolean isWindows = Platform.isWindows();
        this.setAudioAndSubs(filename, media, params, this.configuration);
        CodecConfig codecConfig = this.genConfig(params.mediaRenderer);
        PipeProcess tsPipe = new PipeProcess("VLC" + System.currentTimeMillis() + "." + codecConfig.container, new String[0]);
        ProcessWrapper pipe_process = tsPipe.getPipeProcess();
        pipe_process.runInNewThread();
        tsPipe.deleteLater();
        params.input_pipes[0] = tsPipe;
        params.minBufferSize = params.minFileSize;
        params.secondread_minsize = 100000;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.add("-I");
        cmdList.add("dummy");
        if (!Platform.isMac()) {
            if (this.configuration.isVideoHardwareAcceleration()) {
                logger.warn("VLC hardware acceleration support is an experimental feature. Please disable it before reporting issues.");
                cmdList.add("--ffmpeg-hw");
            } else {
                cmdList.add("--no-ffmpeg-hw");
            }
        }
        if (this.experimentalCodecs.isSelected()) {
            cmdList.add("--sout-ffmpeg-strict=-2");
        }
        if (isWindows) {
            cmdList.add("--dummy-quiet");
        }
        cmdList.add(filename);
        String disableSuffix = "track=214748361";
        if (params.aid != null) {
            if (params.aid.getLang() == null || params.aid.getLang().equals("und")) {
                cmdList.add("--audio-track=" + params.aid.getId());
            } else {
                cmdList.add("--audio-language=" + params.aid.getLang());
            }
        } else {
            cmdList.add("--audio-language=" + this.configuration.getAudioLanguages());
        }
        if (params.sid != null) {
            if (params.sid.isExternal()) {
                String externalSubtitlesFileName = null;
                if (params.sid.isExternalFileUtf16()) {
                    try {
                        File convertedSubtitles = new File(this.configuration.getTempFolder(), "utf8_" + params.sid.getExternalFile().getName());
                        FileUtil.convertFileFromUtf16ToUtf8(params.sid.getExternalFile(), convertedSubtitles);
                        externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(convertedSubtitles.getAbsolutePath());
                    }
                    catch (IOException e) {
                        logger.debug("Error converting file from UTF-16 to UTF-8", e);
                        externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(params.sid.getExternalFile().getAbsolutePath());
                    }
                } else {
                    externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(params.sid.getExternalFile().getAbsolutePath());
                }
                if (externalSubtitlesFileName != null) {
                    cmdList.add("--sub-file");
                    cmdList.add(externalSubtitlesFileName);
                }
            } else if (params.sid.getLang() != null && !params.sid.getLang().equals("und")) {
                cmdList.add("--sub-track=" + params.sid.getId());
            } else {
                cmdList.add("--sub-" + disableSuffix);
            }
        } else if (!this.configuration.isDisableSubtitles()) {
            cmdList.add("--sub-language=" + this.configuration.getSubtitlesLanguages());
        } else {
            cmdList.add("--sub-" + disableSuffix);
        }
        if (params.timeseek != 0.0) {
            cmdList.add("--start-time");
            cmdList.add(String.valueOf(params.timeseek));
        }
        String separator = "";
        StringBuilder encodingArgsBuilder = new StringBuilder();
        for (Map.Entry<String, Object> curEntry : this.getEncodingArgs(codecConfig).entrySet()) {
            encodingArgsBuilder.append(separator);
            encodingArgsBuilder.append(curEntry.getKey());
            if (curEntry.getValue() != null) {
                encodingArgsBuilder.append("=");
                encodingArgsBuilder.append(curEntry.getValue());
            }
            separator = ",";
        }
        String transcodeSpec = String.format("#transcode{%s}:standard{access=file,mux=%s,dst='%s%s'}", encodingArgsBuilder.toString(), codecConfig.container, isWindows ? "\\\\" : "", tsPipe.getInputPipe());
        cmdList.add("--sout");
        cmdList.add(transcodeSpec);
        cmdList.add("vlc://quit");
        if (!this.extraParams.getText().trim().isEmpty()) {
            cmdList.addAll(Arrays.asList(StringUtils.split(this.extraParams.getText().trim(), " ")));
        }
        Object[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, (String[])cmdArray);
        logger.trace("Finalized args: " + StringUtils.join(cmdArray, " "));
        ProcessWrapperImpl pw = new ProcessWrapperImpl((String[])cmdArray, params);
        pw.attachProcess(pipe_process);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        pw.runInNewThread();
        return pw;
    }

    @Override
    public JComponent config() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec("right:pref, 3dlu, pref:grow, 7dlu, right:pref, 3dlu, pref:grow", orientation);
        FormLayout layout = new FormLayout(colSpec, "");
        layout.setColumnGroups(new int[][]{{1, 5}, {3, 7}});
        DefaultFormBuilder mainPanel = new DefaultFormBuilder(layout);
        mainPanel.appendSeparator(Messages.getString("VlcTrans.1"));
        this.experimentalCodecs = new JCheckBox(Messages.getString("VlcTrans.3"), this.configuration.isVlcExperimentalCodecs());
        mainPanel.append((Component)this.experimentalCodecs, 3);
        this.experimentalCodecs.setContentAreaFilled(false);
        this.experimentalCodecs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VLCVideo.this.configuration.setVlcExperimentalCodecs(e.getStateChange() == 1);
            }
        });
        this.audioSyncEnabled = new JCheckBox(Messages.getString("VlcTrans.4"), this.configuration.isVlcAudioSyncEnabled());
        mainPanel.append((Component)this.audioSyncEnabled, 3);
        this.audioSyncEnabled.setContentAreaFilled(false);
        this.audioSyncEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VLCVideo.this.configuration.setVlcAudioSyncEnabled(e.getStateChange() == 1);
            }
        });
        mainPanel.nextLine();
        mainPanel.appendSeparator(Messages.getString("VlcTrans.10"));
        mainPanel.append(Messages.getString("VlcTrans.11"));
        FormLayout scaleLayout = new FormLayout("pref,3dlu,pref", "");
        DefaultFormBuilder scalePanel = new DefaultFormBuilder(scaleLayout);
        double startingScale = Double.valueOf(this.configuration.getVlcScale());
        this.scale = new JTextField(String.valueOf(startingScale));
        scalePanel.append(this.scale);
        final JSlider scaleSlider = new JSlider(0, 0, 10, (int)(startingScale * 10.0));
        scalePanel.append(scaleSlider);
        scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                String value = String.valueOf((double)scaleSlider.getValue() / 10.0);
                VLCVideo.this.scale.setText(value);
                VLCVideo.this.configuration.setVlcScale(value);
            }
        });
        this.scale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String typed = VLCVideo.this.scale.getText();
                if (!typed.matches("\\d\\.\\d")) {
                    return;
                }
                double value = Double.parseDouble(typed);
                scaleSlider.setValue((int)(value * 10.0));
                VLCVideo.this.configuration.setVlcScale(String.valueOf(value));
            }
        });
        mainPanel.append((Component)scalePanel.getPanel(), 3);
        FormLayout sampleRateLayout = new FormLayout("right:pref, 3dlu, right:pref, 3dlu, right:pref, 3dlu, left:pref", "");
        DefaultFormBuilder sampleRatePanel = new DefaultFormBuilder(sampleRateLayout);
        this.sampleRateOverride = new JCheckBox(Messages.getString("VlcTrans.17"), this.configuration.getVlcSampleRateOverride());
        sampleRatePanel.append(Messages.getString("VlcTrans.18"), (Component)this.sampleRateOverride);
        this.sampleRate = new JTextField(this.configuration.getVlcSampleRate(), 8);
        this.sampleRate.setEnabled(this.configuration.getVlcSampleRateOverride());
        this.sampleRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VLCVideo.this.configuration.setVlcSampleRate(VLCVideo.this.sampleRate.getText());
            }
        });
        sampleRatePanel.append(Messages.getString("VlcTrans.19"), (Component)this.sampleRate);
        this.sampleRateOverride.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean checked = e.getStateChange() == 1;
                VLCVideo.this.configuration.setVlcSampleRateOverride(checked);
                VLCVideo.this.sampleRate.setEnabled(checked);
            }
        });
        mainPanel.nextLine();
        mainPanel.append((Component)sampleRatePanel.getPanel(), 7);
        mainPanel.nextLine();
        this.extraParams = new JTextField();
        mainPanel.append(Messages.getString("VlcTrans.20"), (Component)this.extraParams, 5);
        return mainPanel.getPanel();
    }

    protected static class CodecConfig {
        String videoCodec;
        String audioCodec;
        String container;
        String extraParams;
        HashMap<String, Object> extraTrans = new HashMap();
        int sampleRate;

        protected CodecConfig() {
        }
    }
}

