# Copyright (C) 2025 Sebastian Pipping <sebastian@pipping.org>
# Licensed under GPL v2 or later

from importlib.resources import files
from unittest import TestCase

from resolve_march_native._clang.parser import HashHashHashOutputParser


class ParserTest(TestCase):
    def assert_flags_equal(self, basename, expected_flags):
        with open(files('resolve_march_native._clang.test')
                  / 'data'
                  / basename, "rb") as f:
            parser = HashHashHashOutputParser(f.readlines())
        self.assertEqual(list(parser.extract_flags()), expected_flags)

    def test_sandybridge_clang_19(self):
        self.assert_flags_equal('sandybridge--clang-19--explicit.txt', [
            '/usr/lib/llvm/19/bin/clang-19',
            '-cc1',
            '-triple x86_64-pc-linux-gnu',
            '-E',
            '-disable-free',
            '-clear-ast-before-backend',
            '-disable-llvm-verifier',
            '-discard-value-names',
            '-main-file-name -',
            '-mrelocation-model pic',
            '-pic-level 2',
            '-pic-is-pie',
            '-mframe-pointer=all',
            '-fmath-errno',
            '-ffp-contract=on',
            '-fno-rounding-math',
            '-mconstructor-aliases',
            '-funwind-tables=2',
            '-target-cpu sandybridge',
            '-debugger-tuning=gdb',
            '-fdebug-compilation-dir=/CENSORED/resolve-march-native',
            '-fcoverage-compilation-dir=/CENSORED/resolve-march-native',
            '-resource-dir /usr/lib/llvm/19/bin/../../../../lib/clang/19',
            '-include /usr/include/gentoo/fortify.h',
            '-include /usr/include/gentoo/maybe-stddefs.h',
            '-internal-isystem /usr/lib/llvm/19/bin/../../../../lib/clang/19/include',
            '-internal-isystem /usr/local/include',
            '-internal-isystem '
            '/usr/lib/gcc/x86_64-pc-linux-gnu/13/../../../../x86_64-pc-linux-gnu/include',
            '-internal-externc-isystem /include',
            '-internal-externc-isystem /usr/include',
            '-ferror-limit 19',
            '-stack-protector 2',
            '-fstack-clash-protection',
            '-fcf-protection=none',
            '-fgnuc-version=4.2.1',
            '-fskip-odr-check-in-gmf',
            '-D__GCC_HAVE_DWARF2_CFI_ASM=1',
            '-o -',
            '-x c',
            '-',
        ])
        self.assert_flags_equal('sandybridge--clang-19--native.txt', [
            '/usr/lib/llvm/19/bin/clang-19',
            '-cc1',
            '-triple x86_64-pc-linux-gnu',
            '-E',
            '-disable-free',
            '-clear-ast-before-backend',
            '-disable-llvm-verifier',
            '-discard-value-names',
            '-main-file-name -',
            '-mrelocation-model pic',
            '-pic-level 2',
            '-pic-is-pie',
            '-mframe-pointer=all',
            '-fmath-errno',
            '-ffp-contract=on',
            '-fno-rounding-math',
            '-mconstructor-aliases',
            '-funwind-tables=2',
            '-target-cpu sandybridge',
            '-target-feature -prfchw',
            '-target-feature -cldemote',
            '-target-feature +avx',
            '-target-feature +aes',
            '-target-feature +sahf',
            '-target-feature +pclmul',
            '-target-feature -xop',
            '-target-feature +crc32',
            '-target-feature -xsaves',
            '-target-feature -avx512fp16',
            '-target-feature -usermsr',
            '-target-feature -sm4',
            '-target-feature -egpr',
            '-target-feature +sse4.1',
            '-target-feature -avx512ifma',
            '-target-feature +xsave',
            '-target-feature +sse4.2',
            '-target-feature -tsxldtrk',
            '-target-feature -sm3',
            '-target-feature -ptwrite',
            '-target-feature -widekl',
            '-target-feature -invpcid',
            '-target-feature +64bit',
            '-target-feature -xsavec',
            '-target-feature -avx10.1-512',
            '-target-feature -avx512vpopcntdq',
            '-target-feature +cmov',
            '-target-feature -avx512vp2intersect',
            '-target-feature -avx512cd',
            '-target-feature -movbe',
            '-target-feature -avxvnniint8',
            '-target-feature -ccmp',
            '-target-feature -amx-int8',
            '-target-feature -kl',
            '-target-feature -avx10.1-256',
            '-target-feature -sha512',
            '-target-feature -avxvnni',
            '-target-feature -rtm',
            '-target-feature -adx',
            '-target-feature -avx2',
            '-target-feature -hreset',
            '-target-feature -movdiri',
            '-target-feature -serialize',
            '-target-feature -vpclmulqdq',
            '-target-feature -avx512vl',
            '-target-feature -uintr',
            '-target-feature -cf',
            '-target-feature -clflushopt',
            '-target-feature -raoint',
            '-target-feature -cmpccxadd',
            '-target-feature -bmi',
            '-target-feature -amx-tile',
            '-target-feature +sse',
            '-target-feature -gfni',
            '-target-feature -avxvnniint16',
            '-target-feature -amx-fp16',
            '-target-feature -ndd',
            '-target-feature +xsaveopt',
            '-target-feature -rdrnd',
            '-target-feature -avx512f',
            '-target-feature -amx-bf16',
            '-target-feature -avx512bf16',
            '-target-feature -avx512vnni',
            '-target-feature -push2pop2',
            '-target-feature +cx8',
            '-target-feature -avx512bw',
            '-target-feature +sse3',
            '-target-feature -pku',
            '-target-feature -fsgsbase',
            '-target-feature -clzero',
            '-target-feature -mwaitx',
            '-target-feature -lwp',
            '-target-feature -lzcnt',
            '-target-feature -sha',
            '-target-feature -movdir64b',
            '-target-feature -ppx',
            '-target-feature -wbnoinvd',
            '-target-feature -enqcmd',
            '-target-feature -avxneconvert',
            '-target-feature -tbm',
            '-target-feature -pconfig',
            '-target-feature -amx-complex',
            '-target-feature +ssse3',
            '-target-feature +cx16',
            '-target-feature -bmi2',
            '-target-feature -fma',
            '-target-feature +popcnt',
            '-target-feature -avxifma',
            '-target-feature -f16c',
            '-target-feature -avx512bitalg',
            '-target-feature -rdpru',
            '-target-feature -clwb',
            '-target-feature +mmx',
            '-target-feature +sse2',
            '-target-feature -rdseed',
            '-target-feature -avx512vbmi2',
            '-target-feature -prefetchi',
            '-target-feature -rdpid',
            '-target-feature -fma4',
            '-target-feature -avx512vbmi',
            '-target-feature -shstk',
            '-target-feature -vaes',
            '-target-feature -waitpkg',
            '-target-feature -sgx',
            '-target-feature +fxsr',
            '-target-feature -avx512dq',
            '-target-feature -sse4a',
            '-debugger-tuning=gdb',
            '-fdebug-compilation-dir=/CENSORED/resolve-march-native',
            '-fcoverage-compilation-dir=/CENSORED/resolve-march-native',
            '-resource-dir /usr/lib/llvm/19/bin/../../../../lib/clang/19',
            '-include /usr/include/gentoo/fortify.h',
            '-include /usr/include/gentoo/maybe-stddefs.h',
            '-internal-isystem /usr/lib/llvm/19/bin/../../../../lib/clang/19/include',
            '-internal-isystem /usr/local/include',
            '-internal-isystem '
            '/usr/lib/gcc/x86_64-pc-linux-gnu/13/../../../../x86_64-pc-linux-gnu/include',
            '-internal-externc-isystem /include',
            '-internal-externc-isystem /usr/include',
            '-ferror-limit 19',
            '-stack-protector 2',
            '-fstack-clash-protection',
            '-fcf-protection=none',
            '-fgnuc-version=4.2.1',
            '-fskip-odr-check-in-gmf',
            '-D__GCC_HAVE_DWARF2_CFI_ASM=1',
            '-o -',
            '-x c',
            '-',
        ])
