# RPM spec file for RedHat CentOS created by configure script.
Summary: 	Library to create and manage 64-bit disk based hash tables	
Name: 		libdbh2
Version: 	5.0.22
Release: 	1
License:	GPLv3
URL: 		http://dbh.sourceforge.net/
Source0: 	%{name}-%{version}.tar.gz
#Source0: 	http://sf.net/projects/dbh/files/%%{version}/dbh-%%{version}.tar.gz
Group: 		Development tools
BuildRoot: 	%{_tmppath}/%{name}-root

BuildRequires:	libtool >= 2.2.6
BuildRequires:	gtk-doc
BuildRequires:	pkgconfig


%description
Library to create and manage hash tables residing 
on disk. Associations are made between keys and 
values so that for a given a key the value can be 
found and loaded into memory quickly. Being disk based 
allows for large and persistent hashes. 64 bit support
allows for hashtables with sizes over 4 Gigabytes on 32
bit systems. Cuantified key generation allows for 
minimum access time on balanced multidimensional trees.

%prep
%setup -q

%build
%configure --with-examples=no --with-centos=yes
make
strip -s src/.libs/libdbh.so.2.0.5

%install
make install DESTDIR=%buildroot mandir=%{_mandir}
# create symlinks for man pages



%changelog
* Fri Nov 22 2013  <edscott@xfce.org> 5.0.22-1
- RPM release

%clean
rm -rf %buildroot

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc README TODO ChangeLog NEWS AUTHORS examples/simple_hash.c examples/filesystem.c
%{_libdir}/libdbh.so.2.0.5
%if 0%{?suse_version} == 0
%{_libdir}/libdbh.so.2
%endif

%package devel
Summary: 	Library to create and manage 64-bit disk based hash tables	
Group: 		Development tools
Requires:	libdbh2 >= 5.0.22

%description devel
Library to create and manage hash tables residing 
on disk. Associations are made between keys and 
values so that for a given a key the value can be 
found and loaded into memory quickly. Being disk based 
allows for large and persistent hashes. 64 bit support
allows for hashtables with sizes over 4 Gigabytes on 32
bit systems. Cuantified key generation allows for 
minimum access time on balanced multidimensional trees.

%files devel
%defattr(-,root,root)
%dir %{_includedir}/dbh 
%dir %{_datadir}/dbh 
%dir %{_datadir}/gtk-doc/html/dbh 
%{_includedir}/dbh/dbh.h
%{_mandir}/man3/dbh.3.gz
%{_mandir}/man3/dbh.h.3.gz
%{_mandir}/man3/dbh_close.3.gz
%{_mandir}/man3/dbh_create.3.gz
%{_mandir}/man3/dbh_destroy.3.gz
%{_mandir}/man3/dbh_erase.3.gz
%{_mandir}/man3/dbh_exit_fanout.3.gz
%{_mandir}/man3/dbh_exit_sweep.3.gz
%{_mandir}/man3/dbh_fanout.3.gz
%{_mandir}/man3/dbh_find.3.gz
%{_mandir}/man3/dbh_foreach_fanout.3.gz
%{_mandir}/man3/dbh_foreach_sweep.3.gz
%{_mandir}/man3/dbh_genkey.3.gz
%{_mandir}/man3/dbh_genkey2.3.gz
%{_mandir}/man3/dbh_load.3.gz
%{_mandir}/man3/dbh_load_address.3.gz
%{_mandir}/man3/dbh_load_child.3.gz
%{_mandir}/man3/dbh_load_parent.3.gz
%{_mandir}/man3/dbh_macros.3.gz
%{_mandir}/man3/dbh_open.3.gz
%{_mandir}/man3/dbh_open_ro.3.gz
%{_mandir}/man3/dbh_orderkey.3.gz
%{_mandir}/man3/dbh_prune.3.gz
%{_mandir}/man3/dbh_regen_fanout.3.gz
%{_mandir}/man3/dbh_regen_sweep.3.gz
%{_mandir}/man3/dbh_set_data.3.gz
%{_mandir}/man3/dbh_set_key.3.gz
%{_mandir}/man3/dbh_set_recordsize.3.gz
%{_mandir}/man3/dbh_set_size.3.gz
%{_mandir}/man3/dbh_settempdir.3.gz
%{_mandir}/man3/dbh_sweep.3.gz
%{_mandir}/man3/dbh_unerase.3.gz
%{_mandir}/man3/dbh_unprune.3.gz
%{_mandir}/man3/dbh_update.3.gz
%{_mandir}/man3/dbh_writeheader.3.gz
%{_datadir}/gtk-doc/html/dbh/DBH.html
%{_datadir}/gtk-doc/html/dbh/calc.png
%{_datadir}/gtk-doc/html/dbh/ch01.html
%{_datadir}/gtk-doc/html/dbh/home.png
%{_datadir}/gtk-doc/html/dbh/index.html
%{_datadir}/gtk-doc/html/dbh/index.sgml
%{_datadir}/gtk-doc/html/dbh/left.png
%{_datadir}/gtk-doc/html/dbh/right.png
%{_datadir}/gtk-doc/html/dbh/style.css
%{_datadir}/gtk-doc/html/dbh/up.png
%{_datadir}/dbh/Makefile.am
%{_datadir}/dbh/dbh.vim
%{_datadir}/dbh/filesystem.c
%{_datadir}/dbh/simple_hash.c
%{_libdir}/libdbh.a
%{_libdir}/libdbh.so
%if 0%{?suse_version} >= 1000
%{_libdir}/libdbh.so.2
%endif
%{_datadir}/pkgconfig/dbh2.pc


