
/***************************************************************************

    Disk Based Hash library DBH

 * Copyright (C) 2002-2016 Edscott Wilson Garcia
 * EMail: edscott@imp.mc
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation.


*************************************************************************

- bigendian machines should have -DTURN for binary file compatibility.
  if this is not needed, increased speed comes from *not* using -DTURN

For compilers:

DBH version 1.0 had 32 bit filepointers. This is incompatible with
DBH version 2.0 which has 64 bit filepointers.

Type FILEPOINTER determined by configure script to 64 bits.
DBH version 2 requires size_t to be at least 64 bits to compile.

If sizeof(size_t) is less than 64 bits, DBH version 2.0 will not compile
****************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "debug.h"
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#ifdef HAVE_LIBPTHREAD
# include <pthread.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

// for shm and parallel protection
#ifdef HAVE_SYS_MMAN_H
# ifdef PARALLEL_SAFE
#  include <sys/mman.h>
# endif
#endif

//

#ifdef HAVE_MACHINE_LIMITS_H
# include <machine/limits.h>
#else
# include <limits.h>
#endif


#include "dbh.h"
#include "dbh_private.h"
#include "dbh_functions2.h"
#ifndef COPYRIGHT
# define COPYRIGHT "DBH copyright 2000-2010 LGPL, Edscott Wilson Garcia. See http://dbh.sourceforge.net/ for source code"
#endif

#ifndef DBH_VERSION
# error "DBH_VERSION NOT DEFINED"
#endif

/*   with 19 keys out of the 256 key length maximum
     we have the full 256^8 records! thus
     no need to grow further. And this is using a decimal
     based key.
     for article, need comparisons with other databases or ways to
     solve the big dataset access problem... 
    */

#define NEW 1
#define OLD 0

#define DEFAULT_DBH_DATASIZE 1024

#define READ                    0
#define WRITE                   1
#define DOWN                    0
#define UP                      1

#define WRITEBRANCHES           1
#define DONTWRITEBRANCHES       0

#define PRESENTE  				  0
#define PRESENTE_MENOR_BOF      0
#define PRESENTE_MENOR          1
#define PRESENTE_MAYORIGUAL     2
#define ARCHIVO_VACIO           3
#define NO_PRESENTE             4

#define PARALLEL_UNSAFE		0x01
#define THREAD_UNSAFE		0x02

#define ERASED (dbh->flag&0x01)
#define TOGGLE_ERASE (dbh->flag ^= 0x01)
#define SET_UNERASED (dbh->flag &= (0xff ^ 0x01))
#define SET_ERASED (dbh->flag |= 0x01)
#define EZIP_NUMERO_MAXIMO 16777215
 

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif

/* static: 
 * This includes object symbols which will not be exported during link.*/
#include "dbh_static.i"

/* global: 
 * This includes object symbols which will be exported during link.
 * Functions in this file should be defined in dbh.h (generated from
 * dbh.h.in when configure script is run). Function definitions
 * should include comments in gtk-doc format for html documentation
 * generation.*/
#include "dbh_exported.i"
