# Contributor Code of Conduct

Guiding us in our day-to-day interactions and decision-making are the values of trust, respect, collaboration and transparency. Our community welcomes participants from around the world with different experiences, personalities, unique perspectives, and great ideas to share.

We expect this code of conduct to be honored by everyone who participates in the Fantomas community formally or informally.

This code is not exhaustive or complete, and is a living document. It serves to distill our common understanding of a collaborative, shared environment and goals. We expect it to be followed in spirit as much as in the letter, so that it can enrich all of us and the technical communities in which we participate.


## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation. 

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language.
* Being respectful of differing viewpoints and experiences.
* Gracefully accepting constructive criticism.
* Attempting collaboration before conflict.
* Focusing on what is best for the community.
* Appreciating time and effort contributed by members.
* Showing empathy towards other community members.


Examples of unacceptable behavior by participants include:

* Violence, threats of violence, or inciting others to commit self-harm.
* The use of sexualized language or imagery and unwelcome sexual attention or advances.
* Trolling, intentionally spreading misinformation, insulting/derogatory comments, and personal or political attacks, including [challenging someone’s self-identity](https://lgbtq.technology/culture.html#discussion-of-labels).
* Public or private [harassment](https://lgbtq.technology/coc.html#harassment), aggression, deliberate intimidation, or threats.
* [Feigning or exaggerating surprise](https://www.recurse.com/manual#no-feigned-surprise) when someone admits to not knowing something, or excusing a disrespectful communication as “ironic” or “joking”.
* Publishing others' private information, such as a physical or electronic address, without explicit permission. This includes any sort of “outing” of any aspect of someone’s identity without their consent.
* Abuse of the reporting process to intentionally harass or exclude others.
* Advocating for, or encouraging, any of the above behavior.
* Other conduct which could reasonably be considered inappropriate in a professional or community setting.


## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.


## Scope

This Code of Conduct applies both within spaces involving this project and in other spaces involving community members. This includes the repository, its Pull Requests and Issue tracker, its Twitter community, private email communications in the context of the project, and any events where members of the project are participating, as well as adjacent communities and venues affecting the project’s members.

Depending on the violation, the maintainers may decide that violations of this code of conduct that have happened outside of the scope of the community may deem an individual unwelcome, and take appropriate action to maintain the comfort and safety of its members.

As a project on GitHub, this project is additionally covered by the [GitHub Community Guidelines](https://help.github.com/articles/github-community-guidelines/).


## Enforcement

While this code of conduct should be adhered to by participants, we recognize that sometimes people may have a bad day, or be unaware of some of the guidelines in this code of conduct. When that happens, or if they are violating this code of conduct, you may reply to them and point out this code of conduct. Such messages may be in public or in private, whatever is most appropriate. However, regardless of whether the message is public or not, it should still adhere to the relevant parts of this code of conduct and itself should not be abusive or disrespectful. Assume good faith; it is more likely that participants are unaware of their bad behaviour than that they intentionally try to degrade the quality of the discussion. 

As a small and young project, we don’t yet have a Code of Conduct enforcement team. We encourage contributors to try to resolve issues with respectful communication - [here is an example of how to do that](https://github.com/fsprojects/fantomas/pull/649#issuecomment-599965505).

Should there be difficulties in dealing with the situation or you are uncomfortable speaking up, unacceptable behavior may be reported to conduct@fantomas.com. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident.

If you are unsure whether an incident is a violation, or whether the space where the incident took place is covered by our Code of Conduct, we encourage you to still address or report it. We would prefer to have a few extra reports where we decide to take no action than to let an incident go unnoticed and unresolved, resulting in an individual or group feeling like they can no longer participate in the community. Reports deemed as not a violation will also allow us to improve our Code of Conduct and processes surrounding it. 

Participants asked to stop any harassing behavior are expected to comply immediately. Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## License

This Code of Conduct is licensed under the [Creative Commons Attribution-ShareAlike 3.0 Unported License](https://creativecommons.org/licenses/by-sa/3.0/).

## Attribution

This Code of Conduct is informed by and adapted from multiple sources:

* [Apache Code of Conduct](https://www.apache.org/foundation/policies/conduct).
* [Auth0 Contributor Code of Conduct](https://github.com/auth0/open-source-template/blob/master/CODE-OF-CONDUCT.md).
* [Geek Feminism Wiki Anti-Harassment Policy](https://geekfeminism.wikia.org/wiki/Conference_anti-harassment/Policy).
* [GitHub Community Guidelines](https://help.github.com/en/github/site-policy/github-community-guidelines).
* [GitHub Contributor Covenant](https://www.contributor-covenant.org/).
* [LGBTQ in Technology Slack Code of Conduct](http://lgbtq.technology/coc.html).
* [Python Code of Conduct](https://www.python.org/psf/conduct/).
* [Recurse Center User’s Manual](https://www.recurse.com/manual#no-feigned-surprise).
* [Trio Code of Conduct](https://trio.readthedocs.io/en/stable/code-of-conduct.html).
