//
// $Id: Frame.h 79 2005-07-19 21:04:39Z amackenz $
// 

#ifndef __FRAME_H__
#define __FRAME_H__
using namespace std;

#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include "LineManip.h"

// For stat()
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define FILE_NAME_SIZE 256


extern long bufferSize;
class Frame
{
    private:
        long lines;  // Lines per page.
        long number;
        long actualBufferSize;
        long prevOpened;
        long totalFrames;
        long startLine;
        long totalFileLines;
        long scrollBackOffset;
        long scrollRightOffset;
        struct stat finStat;
        int executable;
        LineManip manip;
        WINDOW *win;
        bool enabled;

        vector <string> Screen;
        vector <string> ignoreList;

        char fileName[FILE_NAME_SIZE];
        FILE *fin;
        long findPos(long =0);
        void setStat(struct stat);
        long findTotalFileLines();
        bool statChanged(struct stat);

    public:
        Frame();
        ~Frame();
        // Filename, Number in queue, Total number of frames, config file name
        Frame(char* , long , long, string);
        long setScrollBack(long);
        long incrScrollBack(long = 1);
        long decrScrollBack(long = 1);
        long setScrollRight(long);
        long incrScrollRight(long = 1);
        long decrScrollRight(long = 1);
        void enable(bool);
        long maxScrollBack();
        bool read();
        void print();
        long height(){return lines-1;}; // -1 for the title.
        int resize();
};
    
#endif //__FRAME_H__
