/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.dita.index.IndexCollator;
import org.dita.index.configuration.CharRange;
import org.dita.index.configuration.ConfigEntry;

@VisibleForTesting
public class ConfigEntryImpl
implements ConfigEntry {
    private final String label;
    private final String key;
    private final List<String> members;
    private final List<CharRange> ranges = new ArrayList<CharRange>();

    public ConfigEntryImpl(String label, String key, List<String> members) {
        this.label = label;
        this.key = key;
        this.members = members;
    }

    public void addRange(CharRange range) {
        this.ranges.add(range);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<String> getGroupMembers() {
        return this.members;
    }

    @Override
    public boolean isInRange(String value, IndexCollator collator) {
        if (!value.isEmpty()) {
            for (String member : this.members) {
                if (!value.startsWith(member) && !member.startsWith(value)) continue;
                return true;
            }
            for (CharRange range : this.ranges) {
                if (!range.isInRange(value, collator)) continue;
                return true;
            }
        }
        return false;
    }
}

