/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetterFactory;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByNodeFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.impl.VcsActivityKey;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.CommitCountStageKt;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcs.log.visible.filters.VcsLogParentFilterImplKt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogCommandParameters;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogDiffHandler;
import git4idea.log.GitLogIndexer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.telemetry.GitBackendTelemetrySpan;
import io.opentelemetry.api.trace.SpanBuilder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitLogProvider
implements VcsLogProvider,
VcsIndexableLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = ref -> ref.getType() == GitRefManager.TAG ? ref.getName() : null;
    public static final Hash.Strategy<VcsRef> DONT_CONSIDER_SHA = new Hash.Strategy<VcsRef>(){

        public int hashCode(@Nullable VcsRef ref) {
            if (ref == null) {
                return 0;
            }
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@Nullable VcsRef ref1, @Nullable VcsRef ref2) {
            if (ref1 == ref2) {
                return true;
            }
            return ref1 != null && ref2 != null && ref1.getName().equals(ref2.getName()) && ref1.getType().equals((Object)ref2.getType());
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;
    @NotNull
    private final IJTracer myTracer;

    public GitLogProvider(@NotNull Project project) {
        if (project == null) {
            GitLogProvider.$$$reportNull$$$0(0);
        }
        this.myTracer = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
        this.myProject = project;
        this.myRepositoryManager = GitRepositoryManager.getInstance(project);
        this.myRefSorter = new GitRefManager(this.myProject, (RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection allDetails;
        GitRepository repository2;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(1);
        }
        if (requirements == null) {
            GitLogProvider.$$$reportNull$$$0(2);
        }
        if ((repository2 = this.getRepository(root)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogProvider.$$$reportNull$$$0(3);
            }
            return logDataImpl;
        }
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = false;
        boolean isRefreshRefs = false;
        if (requirements instanceof VcsLogProviderRequirementsEx) {
            VcsLogProviderRequirementsEx requirementsEx = (VcsLogProviderRequirementsEx)requirements;
            refresh = requirementsEx.isRefresh();
            isRefreshRefs = requirementsEx.isRefreshRefs();
        }
        VcsLogProvider.DetailedLogData data2 = GitLogUtil.collectMetadata(this.myProject, root, params);
        Set safeRefs = data2.getRefs();
        ObjectOpenCustomHashSet allRefs = new ObjectOpenCustomHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<Object> branches = Collections.emptySet();
        if (isRefreshRefs) {
            branches = this.readBranches(repository2);
            GitLogProvider.addNewElements(allRefs, branches);
        }
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh || !isRefreshRefs) {
            allDetails = data2.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<? super VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = new HashSet(data2.getCommits());
            HashSet previousTags = new HashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            HashSet safeTags = new HashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        List sortedCommits = (List)TraceKt.use((SpanBuilder)this.myTracer.spanBuilder(GitBackendTelemetrySpan.LogProvider.SortingCommits.getName()).setAttribute("rootName", root.getName()), span -> {
            List commits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
            return ContainerUtil.getFirstItems((List)commits, (int)requirements.getCommitCount());
        });
        if (LOG.isDebugEnabled()) {
            this.validateDataAndReportError(root, (Set<? extends VcsRef>)allRefs, sortedCommits, data2, branches, currentTagNames, commitsFromTags);
        }
        return new LogDataImpl((Set)allRefs, sortedCommits);
    }

    private void validateDataAndReportError(@NotNull VirtualFile root, @NotNull Set<? extends VcsRef> allRefs, @NotNull List<? extends VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<? extends VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(4);
        }
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(5);
        }
        if (sortedCommits == null) {
            GitLogProvider.$$$reportNull$$$0(6);
        }
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(7);
        }
        if (manuallyReadBranches == null) {
            GitLogProvider.$$$reportNull$$$0(8);
        }
        TraceKt.use((SpanBuilder)this.myTracer.spanBuilder(GitBackendTelemetrySpan.LogProvider.ValidatingData.getName()).setAttribute("rootName", root.getName()), __ -> {
            Set refs = ContainerUtil.map2Set((Collection)allRefs, VcsRef::getCommitHash);
            PermanentGraphImpl.newInstance((List)sortedCommits, (GraphColorGetterFactory)new GraphColorGetterByNodeFactory((hash, integer) -> 0), (head1, head2) -> {
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    Attachment attachment = new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags));
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{attachment});
                }
                return 0;
            }, (Set)refs);
            return null;
        });
    }

    private static String printErrorDetails(@NotNull VirtualFile root, @NotNull Set<? extends VcsRef> allRefs, @NotNull List<? extends VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<? extends VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(9);
        }
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(10);
        }
        if (sortedCommits == null) {
            GitLogProvider.$$$reportNull$$$0(11);
        }
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(12);
        }
        if (manuallyReadBranches == null) {
            GitLogProvider.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    @NotNull
    private static String printLogData(@NotNull VcsLogProvider.DetailedLogData firstBlockSyncData) {
        if (firstBlockSyncData == null) {
            GitLogProvider.$$$reportNull$$$0(14);
        }
        String string = String.format("Last 100 commits:\n%s\nRefs:\n%s", GitLogProvider.printCommits(firstBlockSyncData.getCommits()), GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String printCommits(@NotNull List<? extends VcsCommitMetadata> commits) {
        if (commits == null) {
            GitLogProvider.$$$reportNull$$$0(16);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits.size(), 100); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit.getId()).toShortString(), StringUtil.join((Collection)commit.getParents(), Hash::toShortString, (String)", ")));
        }
        String string = sb.toString();
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String printRefs(@NotNull Set<? extends VcsRef> refs) {
        if (refs == null) {
            GitLogProvider.$$$reportNull$$$0(18);
        }
        String string = StringUtil.join(refs, ref -> ref.getCommitHash().toShortString() + " : " + ref.getName(), (String)"\n");
        if (string == null) {
            GitLogProvider.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void addOldStillExistingTags(@NotNull Set<? super VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Collection<? extends VcsRef> previousRefs) {
        if (allRefs == null) {
            GitLogProvider.$$$reportNull$$$0(20);
        }
        if (currentTags == null) {
            GitLogProvider.$$$reportNull$$$0(21);
        }
        if (previousRefs == null) {
            GitLogProvider.$$$reportNull$$$0(22);
        }
        for (VcsRef vcsRef : previousRefs) {
            if (allRefs.contains(vcsRef) || !currentTags.contains(vcsRef.getName())) continue;
            allRefs.add((VcsRef)vcsRef);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(23);
        }
        Set set = (Set)TraceUtil.computeWithSpanThrows((SpanBuilder)this.myTracer.spanBuilder(GitBackendTelemetrySpan.LogProvider.ReadingTags.getName()).setAttribute("rootName", root.getName()), __ -> new HashSet<String>(GitBranchUtil.getAllTags(this.myProject, root)));
        if (set == null) {
            GitLogProvider.$$$reportNull$$$0(24);
        }
        return set;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<? extends T> original, Set<T> ... toRemove) {
        if (original == null) {
            GitLogProvider.$$$reportNull$$$0(25);
        }
        if (toRemove == null) {
            GitLogProvider.$$$reportNull$$$0(26);
        }
        HashSet<T> result2 = new HashSet<T>(original);
        for (Set<T> set : toRemove) {
            result2.removeAll(set);
        }
        HashSet<T> hashSet = result2;
        if (hashSet == null) {
            GitLogProvider.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    private static <T> void addNewElements(@NotNull Collection<? super T> original, @NotNull Collection<? extends T> toAdd) {
        if (original == null) {
            GitLogProvider.$$$reportNull$$$0(28);
        }
        if (toAdd == null) {
            GitLogProvider.$$$reportNull$$$0(29);
        }
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(30);
        }
        if (unmatchedTags == null) {
            GitLogProvider.$$$reportNull$$$0(31);
        }
        VcsLogProvider.DetailedLogData detailedLogData = (VcsLogProvider.DetailedLogData)TraceUtil.computeWithSpanThrows((SpanBuilder)this.myTracer.spanBuilder(GitBackendTelemetrySpan.LogProvider.LoadingCommitsOnTaggedBranch.getName()).setAttribute("rootName", root.getName()), __ -> {
            ArrayList<CallSite> params = new ArrayList<CallSite>();
            params.add((CallSite)((Object)("--max-count=" + commitCount)));
            HashSet refs = new HashSet();
            HashSet commits = new HashSet();
            VcsFileUtil.foreachChunk(new ArrayList(unmatchedTags), (int)1, tagsChunk -> {
                String[] parameters = ArrayUtilRt.toStringArray((Collection)ContainerUtil.concat((List)params, (List)tagsChunk));
                VcsLogProvider.DetailedLogData logData = GitLogUtil.collectMetadata(this.myProject, root, parameters);
                refs.addAll(logData.getRefs());
                commits.addAll(logData.getCommits());
            });
            return new LogDataImpl(refs, new ArrayList(commits));
        });
        if (detailedLogData == null) {
            GitLogProvider.$$$reportNull$$$0(32);
        }
        return detailedLogData;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(33);
        }
        if (commitConsumer == null) {
            GitLogProvider.$$$reportNull$$$0(34);
        }
        if (this.getRepository(root) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogProvider.$$$reportNull$$$0(35);
            }
            return logDataImpl;
        }
        ArrayList<String> parameters = new ArrayList<String>(GitLogUtil.LOG_ALL);
        parameters.add("--date-order");
        HashSet userRegistry = new HashSet();
        HashSet refs = new HashSet();
        GitLogUtil.readTimedCommits(this.myProject, root, parameters, (java.util.function.Consumer<? super VcsUser>)new CollectConsumer(userRegistry), (java.util.function.Consumer<? super VcsRef>)new CollectConsumer(refs), arg_0 -> commitConsumer.consume(arg_0));
        return new LogDataImpl(refs, userRegistry);
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        GitRepository repository2;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(36);
        }
        if (hashes == null) {
            GitLogProvider.$$$reportNull$$$0(37);
        }
        if (commitConsumer == null) {
            GitLogProvider.$$$reportNull$$$0(38);
        }
        if ((repository2 = this.getRepository(root)) == null) {
            return;
        }
        GitCommitRequirements requirements = new GitCommitRequirements(GitLogProvider.shouldIncludeRootChanges(repository2), GitCommitRequirements.DiffRenames.Limit.Default.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
        GitLogUtil.readFullDetailsForHashes(this.myProject, root, hashes, requirements, commitConsumer);
    }

    static boolean shouldIncludeRootChanges(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitLogProvider.$$$reportNull$$$0(39);
        }
        return !repository2.getInfo().isShallow();
    }

    public void readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(40);
        }
        if (hashes == null) {
            GitLogProvider.$$$reportNull$$$0(41);
        }
        if (consumer == null) {
            GitLogProvider.$$$reportNull$$$0(42);
        }
        GitLogUtil.collectMetadata(this.myProject, root, hashes, arg_0 -> consumer.consume(arg_0));
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitLogProvider.$$$reportNull$$$0(43);
        }
        Set set = (Set)TraceKt.use((SpanBuilder)this.myTracer.spanBuilder(GitBackendTelemetrySpan.LogProvider.ReadingBranches.getName()).setAttribute("rootName", repository2.getRoot().getName()), span -> {
            Hash hash;
            VirtualFile root = repository2.getRoot();
            repository2.update();
            GitBranchesCollection branches = repository2.getBranches();
            Collection<GitLocalBranch> localBranches = branches.getLocalBranches();
            Collection<GitRemoteBranch> remoteBranches = branches.getRemoteBranches();
            HashSet<VcsRef> refs = new HashSet<VcsRef>(localBranches.size() + remoteBranches.size());
            for (GitLocalBranch localBranch : localBranches) {
                hash = branches.getHash((GitBranch)localBranch);
                assert (hash != null);
                refs.add(this.myVcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
            }
            for (GitRemoteBranch remoteBranch : remoteBranches) {
                hash = branches.getHash((GitBranch)remoteBranch);
                assert (hash != null);
                refs.add(this.myVcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
            }
            String currentRevision = repository2.getCurrentRevision();
            if (currentRevision != null) {
                refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
            }
            return refs;
        });
        if (set == null) {
            GitLogProvider.$$$reportNull$$$0(44);
        }
        return set;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitLogProvider.$$$reportNull$$$0(45);
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            GitLogProvider.$$$reportNull$$$0(46);
        }
        return vcsLogRefManager;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> roots, @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            GitLogProvider.$$$reportNull$$$0(47);
        }
        if (refresher == null) {
            GitLogProvider.$$$reportNull$$$0(48);
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, repository2 -> TrackingUtil.trackActivity((Project)this.myProject, (ActivityKey)VcsActivityKey.INSTANCE, () -> {
            VirtualFile root = repository2.getRoot();
            if (roots.contains(root)) {
                refresher.refresh(root);
            }
        }));
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            GitLogProvider.$$$reportNull$$$0(49);
        }
        return messageBusConnection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @NotNull PermanentGraph.Options graphOptions, int maxCount) throws VcsException {
        VcsLogRangeFilter rangeFilter;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(50);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(51);
        }
        if (graphOptions == null) {
            GitLogProvider.$$$reportNull$$$0(52);
        }
        if ((rangeFilter = (VcsLogRangeFilter)filterCollection.get(VcsLogFilterCollection.RANGE_FILTER)) == null) {
            return this.getCommitsMatchingFilter(root, filterCollection, null, graphOptions, maxCount);
        }
        LinkedHashSet<TimedVcsCommit> commits = new LinkedHashSet<TimedVcsCommit>();
        if (filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER) != null || filterCollection.get(VcsLogFilterCollection.REVISION_FILTER) != null) {
            commits.addAll(this.getCommitsMatchingFilter(root, filterCollection, null, graphOptions, maxCount));
            filterCollection = VcsLogFiltersKt.without((VcsLogFilterCollection)VcsLogFiltersKt.without((VcsLogFilterCollection)filterCollection, (VcsLogFilterCollection.FilterKey)VcsLogFilterCollection.BRANCH_FILTER), (VcsLogFilterCollection.FilterKey)VcsLogFilterCollection.REVISION_FILTER);
        }
        for (VcsLogRangeFilter.RefRange range : rangeFilter.getRanges()) {
            commits.addAll(this.getCommitsMatchingFilter(root, filterCollection, range, graphOptions, maxCount));
        }
        return new ArrayList<TimedVcsCommit>(commits);
    }

    @Nullable
    public static GitLogCommandParameters getGitLogParameters(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range, @NotNull PermanentGraph.Options options, int maxCount) {
        Collection files;
        VcsLogStructureFilter structureFilter;
        VcsLogParentFilter parentFilter;
        VcsLogTextFilter textFilter;
        GitRepository repository2;
        if (project == null) {
            GitLogProvider.$$$reportNull$$$0(53);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(54);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(55);
        }
        if (options == null) {
            GitLogProvider.$$$reportNull$$$0(56);
        }
        if ((repository2 = GitLogProvider.getRepository(GitRepositoryManager.getInstance(project), root)) == null) {
            return null;
        }
        ArrayList<String> configParameters = new ArrayList<String>();
        List<String> branchLikeFilterParameters = GitLogProvider.getBranchLikeFilterParameters(repository2, filterCollection, range);
        if (branchLikeFilterParameters.isEmpty()) {
            return null;
        }
        ArrayList<String> filterParameters = new ArrayList<String>(branchLikeFilterParameters);
        VcsLogDateFilter dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER);
        if (dateFilter != null) {
            if (dateFilter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", dateFilter.getAfter().toString()));
            }
            if (dateFilter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", dateFilter.getBefore().toString()));
            }
        }
        String text2 = (textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER)) != null ? textFilter.getText() : null;
        boolean regexp = textFilter == null || textFilter.isRegex();
        boolean caseSensitive = textFilter != null && textFilter.matchesCase();
        GitLogProvider.appendTextFilterParameters(text2, regexp, caseSensitive, filterParameters);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
        if (userFilter != null) {
            List names = ContainerUtil.map((Collection)userFilter.getUsers(root), VcsUserUtil::toExactString);
            if (regexp) {
                List authors = ContainerUtil.map((Collection)names, (Function)UserNameRegex.EXTENDED_INSTANCE);
                if (GitVersionSpecialty.LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR.existsIn(project)) {
                    filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.join((Collection)authors, (String)"|")));
                } else {
                    filterParameters.addAll(ContainerUtil.map((Collection)authors, a -> GitLogProvider.prepareParameter("author", a)));
                }
            } else {
                filterParameters.addAll(ContainerUtil.map((Collection)names, a -> GitLogProvider.prepareParameter("author", StringUtil.escapeBackSlashes((String)a))));
            }
            configParameters.add("log.mailmap=false");
        }
        if (!CommitCountStageKt.isAll((int)maxCount)) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        if (options.equals(PermanentGraph.Options.FirstParent.INSTANCE)) {
            filterParameters.add("--first-parent");
        }
        if ((parentFilter = (VcsLogParentFilter)filterCollection.get(VcsLogFilterCollection.PARENT_FILTER)) != null && !VcsLogParentFilterImplKt.getMatchesAll((VcsLogParentFilter)parentFilter)) {
            if (VcsLogParentFilterImplKt.getHasLowerBound((VcsLogParentFilter)parentFilter)) {
                filterParameters.add("--min-parents=" + parentFilter.getMinParents());
            }
            if (VcsLogParentFilterImplKt.getHasUpperBound((VcsLogParentFilter)parentFilter)) {
                filterParameters.add("--max-parents=" + parentFilter.getMaxParents());
            }
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null && !(files = structureFilter.getFiles()).isEmpty()) {
            filterParameters.add("--full-history");
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (FilePath file : files) {
                filterParameters.add(VcsFileUtil.relativePath((VirtualFile)root, (FilePath)file));
            }
        }
        return new GitLogCommandParameters(configParameters, filterParameters);
    }

    @NotNull
    private List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range, @NotNull PermanentGraph.Options options, int maxCount) throws VcsException {
        GitLogCommandParameters parameters;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(57);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(58);
        }
        if (options == null) {
            GitLogProvider.$$$reportNull$$$0(59);
        }
        if ((parameters = GitLogProvider.getGitLogParameters(this.myProject, root, filterCollection, range, options, maxCount)) == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                GitLogProvider.$$$reportNull$$$0(60);
            }
            return list;
        }
        ArrayList<TimedVcsCommit> commits = new ArrayList<TimedVcsCommit>();
        GitLogUtil.readTimedCommits(this.myProject, root, parameters.getConfigParameters(), parameters.getFilterParameters(), null, null, (java.util.function.Consumer<? super TimedVcsCommit>)new CollectConsumer(commits));
        ArrayList<TimedVcsCommit> arrayList = commits;
        if (arrayList == null) {
            GitLogProvider.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public static List<String> getBranchLikeFilterParameters(@NotNull GitRepository repository2, @NotNull VcsLogFilterCollection filterCollection, @Nullable VcsLogRangeFilter.RefRange range) {
        if (repository2 == null) {
            GitLogProvider.$$$reportNull$$$0(62);
        }
        if (filterCollection == null) {
            GitLogProvider.$$$reportNull$$$0(63);
        }
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filterCollection.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter == null && revisionFilter == null && range == null) {
            return GitLogUtil.LOG_ALL;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        if (branchFilter != null) {
            ArrayList branches = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat(repository2.getBranches().getLocalBranches(), repository2.getBranches().getRemoteBranches()));
            Collection<String> branchNames = GitBranchUtil.convertBranchesToNames(branches);
            List<String> predefinedNames = Collections.singletonList("HEAD");
            for (String branchName : ContainerUtil.concat(branchNames, predefinedNames)) {
                if (!branchFilter.matches(branchName)) continue;
                result2.add(branchName);
            }
        }
        if (revisionFilter != null) {
            for (CommitId commit : revisionFilter.getHeads()) {
                if (!commit.getRoot().equals(repository2.getRoot())) continue;
                result2.add(commit.getHash().asString());
            }
        }
        if (range != null) {
            result2.add(range.getExclusiveRef() + ".." + range.getInclusiveRef());
        }
        return result2;
    }

    public static void appendTextFilterParameters(@Nullable String text2, boolean regexp, boolean caseSensitive, @NotNull List<? super String> filterParameters) {
        if (filterParameters == null) {
            GitLogProvider.$$$reportNull$$$0(64);
        }
        if (text2 != null) {
            filterParameters.add(GitLogProvider.prepareParameter("grep", text2));
        }
        filterParameters.add(regexp ? "--extended-regexp" : "--fixed-strings");
        if (!caseSensitive) {
            filterParameters.add("--regexp-ignore-case");
        }
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(65);
        }
        return GitUserRegistry.getInstance(this.myProject).getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(66);
        }
        if (commitHash == null) {
            GitLogProvider.$$$reportNull$$$0(67);
        }
        Collection<String> collection = GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
        if (collection == null) {
            GitLogProvider.$$$reportNull$$$0(68);
        }
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        GitRepository repository2;
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(69);
        }
        if ((repository2 = (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(root)) == null) {
            return null;
        }
        String currentBranchName = repository2.getCurrentBranchName();
        if (currentBranchName == null && repository2.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @NotNull
    public VcsLogDiffHandler getDiffHandler() {
        return new GitLogDiffHandler(this.myProject);
    }

    @Nullable
    public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        GitRepository repository2;
        if (ref == null) {
            GitLogProvider.$$$reportNull$$$0(70);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(71);
        }
        if ((repository2 = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            return null;
        }
        return Git.getInstance().resolveReference(repository2, ref);
    }

    @NotNull
    public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath path) {
        if (project == null) {
            GitLogProvider.$$$reportNull$$$0(72);
        }
        if (detectedRoot == null) {
            GitLogProvider.$$$reportNull$$$0(73);
        }
        if (path == null) {
            GitLogProvider.$$$reportNull$$$0(74);
        }
        return GitLogProvider.getCorrectedVcsRoot(this.myRepositoryManager, detectedRoot, path);
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.SUPPORTS_INDEXING) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.HAS_COMMITTER) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    @NotNull
    public VcsLogIndexer getIndexer() {
        return new GitLogIndexer(this.myProject, this.myRepositoryManager);
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(75);
        }
        return GitLogProvider.getRepository(this.myRepositoryManager, root);
    }

    @Nullable
    static GitRepository getRepository(@NotNull GitRepositoryManager manager2, @NotNull VirtualFile root) {
        GitRepository repository2;
        if (manager2 == null) {
            GitLogProvider.$$$reportNull$$$0(76);
        }
        if (root == null) {
            GitLogProvider.$$$reportNull$$$0(77);
        }
        if ((repository2 = (GitRepository)manager2.getRepositoryForRoot(root)) == null) {
            LOG.warn("Repository not found for root " + String.valueOf(root));
            return null;
        }
        if (repository2.isFresh()) {
            LOG.info("Fresh repository: " + String.valueOf(root));
            return null;
        }
        return repository2;
    }

    @NotNull
    public static VirtualFile getCorrectedVcsRoot(@NotNull GitRepositoryManager repositoryManager, @NotNull VirtualFile detectedRoot, @NotNull FilePath path) {
        GitSubmodule submodule;
        if (repositoryManager == null) {
            GitLogProvider.$$$reportNull$$$0(78);
        }
        if (detectedRoot == null) {
            GitLogProvider.$$$reportNull$$$0(79);
        }
        if (path == null) {
            GitLogProvider.$$$reportNull$$$0(80);
        }
        if (path.isDirectory()) {
            VirtualFile virtualFile = detectedRoot;
            if (virtualFile == null) {
                GitLogProvider.$$$reportNull$$$0(81);
            }
            return virtualFile;
        }
        GitRepository repository2 = (GitRepository)repositoryManager.getRepositoryForRootQuick(path);
        if (repository2 != null && repository2.getRoot().equals(detectedRoot) && (submodule = GitSubmoduleKt.asSubmodule(repository2)) != null) {
            VirtualFile virtualFile = submodule.getParent().getRoot();
            if (virtualFile == null) {
                GitLogProvider.$$$reportNull$$$0(82);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = detectedRoot;
        if (virtualFile == null) {
            GitLogProvider.$$$reportNull$$$0(83);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15, 17, 19, 24, 27, 32, 35, 44, 45, 46, 49, 60, 61, 68, 81, 82, 83 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 23: 
            case 30: 
            case 33: 
            case 36: 
            case 40: 
            case 50: 
            case 54: 
            case 57: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 35: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 68: 
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitLogProvider";
                break;
            }
            case 5: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedCommits";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBlockSyncData";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manuallyReadBranches";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTags";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRefs";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unmatchedTags";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 39: 
            case 43: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 51: 
            case 55: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphOptions";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterParameters";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 73: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitLogProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBlock";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "printLogData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "printCommits";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "printRefs";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readCurrentTagNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSomeCommitsOnTaggedBranches";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllHashes";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranches";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceManager";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeToRootRefreshEvents";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMatchingFilter";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrectedVcsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFirstBlock";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 35: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 68: 
            case 81: 
            case 82: 
            case 83: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateDataAndReportError";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "printErrorDetails";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printLogData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printCommits";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "printRefs";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addOldStillExistingTags";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readCurrentTagNames";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addNewElements";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadSomeCommitsOnTaggedBranches";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeRootChanges";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "readMetadata";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "readBranches";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRootRefreshEvents";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMatchingFilter";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getGitLogParameters";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getBranchLikeFilterParameters";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "appendTextFilterParameters";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentUser";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranch";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRoot";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectedVcsRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15, 17, 19, 24, 27, 32, 35, 44, 45, 46, 49, 60, 61, 68, 81, 82, 83 -> new IllegalStateException(string);
        };
    }
}

