/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternSerialization;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSchemaMapping {
    public static final ObjectName CURRENT_NAMESPACE_NAME = ObjectName.quoted((String)"@");
    private final List<Substitution> mySubstitutions = new ArrayList<Substitution>();
    private TreePattern myIntrospectionScope = TreePattern.EMPTY;
    private boolean myUseMiniCat = true;

    public boolean isIntrospected(@NotNull BasicElement e) {
        if (e == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(0);
        }
        return DataSourceSchemaMapping.matches(this.myIntrospectionScope, e);
    }

    public static boolean matches(@NotNull TreePattern scope, @NotNull ObjectPath path) {
        if (scope == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(1);
        }
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(2);
        }
        return !DataSourceSchemaMapping.match(scope.root, path).isEmpty();
    }

    public static boolean matches(@NotNull TreePattern scope, @NotNull DasObject obj) {
        if (scope == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(3);
        }
        if (obj == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(4);
        }
        return obj.getKind() == ObjectKind.ROOT || DataSourceSchemaMapping.match(scope.root, obj).isNotEmpty();
    }

    public static boolean isIntrospected(@Nullable TreePattern scope, @NotNull DasObject obj) {
        if (obj == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(5);
        }
        return scope == null || obj instanceof BasicRoot || !(obj instanceof DasNamespace) || DataSourceSchemaMapping.matches(scope, obj);
    }

    @NotNull
    public TreePattern getIntrospectionScope() {
        TreePattern treePattern = this.myIntrospectionScope;
        if (treePattern == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    public void setIntrospectionScope(@NotNull TreePattern introspectionScope) {
        if (introspectionScope == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(7);
        }
        this.myIntrospectionScope = introspectionScope;
    }

    public boolean isUseMiniCat() {
        return this.myUseMiniCat;
    }

    public void setUseMiniCat(boolean useMiniCat) {
        this.myUseMiniCat = useMiniCat;
    }

    public void put(@NotNull TreePattern where, @NotNull String snapshotId, @NotNull ObjectPath what) {
        if (where == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(8);
        }
        if (snapshotId == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(9);
        }
        if (what == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(10);
        }
        this.prune(where);
        this.mySubstitutions.add(new Substitution(where, snapshotId, what));
    }

    public void prune(@NotNull TreePattern pattern) {
        if (pattern == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(11);
        }
        ArrayList<Substitution> newSubs = new ArrayList<Substitution>();
        for (Substitution s : this.mySubstitutions) {
            TreePattern newPattern = TreePatternUtils.minus(s.where, pattern);
            if (newPattern.isEmpty()) continue;
            newSubs.add(new Substitution(newPattern, s.snapshotId, s.basePath));
        }
        this.mySubstitutions.clear();
        this.mySubstitutions.addAll(newSubs);
    }

    public void assignSubstitutions(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(12);
        }
        this.mySubstitutions.clear();
        this.mySubstitutions.addAll(mapping.mySubstitutions);
    }

    public void assign(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(13);
        }
        this.assignSubstitutions(mapping);
        this.myIntrospectionScope = mapping.myIntrospectionScope;
        this.myUseMiniCat = mapping.myUseMiniCat;
    }

    @Nullable
    public Substitution get(@NotNull ObjectPath path) {
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(14);
        }
        for (Substitution substitution : this.mySubstitutions) {
            if (!DataSourceSchemaMapping.matchesExact(substitution.where, path)) continue;
            return substitution;
        }
        return null;
    }

    @Nullable
    public Pair<String, ObjectPath> map(@NotNull ObjectPath path) {
        Substitution substitution;
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(15);
        }
        if ((substitution = this.get(path)) == null) {
            return null;
        }
        return Pair.create((Object)substitution.snapshotId, (Object)DataSourceSchemaMapping.completeBy(substitution.basePath, path));
    }

    @NotNull
    private static ObjectPath completeBy(@Nullable ObjectPath base, @NotNull ObjectPath completion) {
        if (completion == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(16);
        }
        if (base == null) {
            ObjectPath objectPath = completion;
            if (objectPath == null) {
                DataSourceSchemaMapping.$$$reportNull$$$0(17);
            }
            return objectPath;
        }
        HashSet<ObjectKind> baseKinds = new HashSet<ObjectKind>();
        ObjectPath p = base;
        while (p != null) {
            baseKinds.add(p.kind);
            p = p.parent;
        }
        return DataSourceSchemaMapping.completeBy(base, completion, baseKinds);
    }

    @NotNull
    private static ObjectPath completeBy(@NotNull ObjectPath base, @NotNull ObjectPath completion, @NotNull Set<ObjectKind> baseKinds) {
        if (base == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(18);
        }
        if (completion == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(19);
        }
        if (baseKinds == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(20);
        }
        if (baseKinds.contains(completion.kind) || completion.parent == null) {
            ObjectPath objectPath = base;
            if (objectPath == null) {
                DataSourceSchemaMapping.$$$reportNull$$$0(21);
            }
            return objectPath;
        }
        ObjectPath p = DataSourceSchemaMapping.completeBy(base, completion.parent, baseKinds);
        ObjectPath objectPath = p.kind == completion.parent.kind ? p.append(completion.name, completion.kind, completion.isQuoted(), completion.getIdentity()) : p;
        if (objectPath == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(22);
        }
        return objectPath;
    }

    public static boolean matchesExact(@NotNull TreePattern pattern, @NotNull ObjectPath path) {
        if (pattern == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(23);
        }
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(24);
        }
        return ContainerUtil.find(DataSourceSchemaMapping.match(pattern.root, path), n -> n.groups.length == 0) != null;
    }

    @NotNull
    public static Set<TreePatternNode> match(@NotNull TreePatternNode node, @NotNull ObjectPath path) {
        if (node == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(25);
        }
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(26);
        }
        Set<TreePatternNode> prev = path.parent != null ? DataSourceSchemaMapping.match(node, path.parent) : Collections.singleton(node);
        ObjectName name = TreePatternUtils.nameOf(path);
        ArrayList<TreePatternNode> matched = new ArrayList<TreePatternNode>();
        for (TreePatternNode n : prev) {
            TreePatternNode.Group group = n.getGroup(path.kind);
            if (group == null) continue;
            group.matchedChildren(name, Casing.EXACT, matched);
        }
        return new HashSet<TreePatternNode>(matched);
    }

    @NotNull
    private static JBIterable<TreePatternNode> match(@NotNull TreePatternNode node, @NotNull DasObject obj) {
        DasObject parent;
        if (node == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(27);
        }
        if (obj == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(28);
        }
        JBIterable prev = (parent = obj.getDasParent()) != null && parent.getKind() != ObjectKind.ROOT ? DataSourceSchemaMapping.match(node, parent).unique() : JBIterable.of((Object)node);
        ObjectName name = TreePatternUtils.nameOf(obj);
        Casing casing = obj instanceof BasicNamespace ? ((BasicNamespace)obj).getCasing(obj.getKind(), obj) : null;
        ArrayList<TreePatternNode> matched = new ArrayList<TreePatternNode>();
        for (TreePatternNode n : prev) {
            TreePatternNode.Group group = n.getGroup(obj.getKind());
            if (group == null) continue;
            group.matchedChildren(name, casing, matched);
            BasicNamespace nsp = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getMaybeBasicElement(obj), BasicNamespace.class);
            if (nsp == null || !nsp.isCurrent()) continue;
            group.matchedChildren(CURRENT_NAMESPACE_NAME, casing, matched);
        }
        JBIterable jBIterable = JBIterable.from(matched);
        if (jBIterable == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    @NotNull
    public static TreePattern asPattern(@NotNull ObjectPath path) {
        if (path == null) {
            DataSourceSchemaMapping.$$$reportNull$$$0(30);
        }
        TreePatternNode.Group g = null;
        ObjectPath p = path;
        while (p != null) {
            g = TreePatternUtils.create(TreePatternUtils.nameOf(p), p.kind, g);
            p = p.parent;
        }
        return new TreePattern(g);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceSchemaMapping mapping = (DataSourceSchemaMapping)o;
        return this.mySubstitutions.equals(mapping.mySubstitutions) && this.myIntrospectionScope.equals(mapping.myIntrospectionScope) && this.myUseMiniCat == mapping.myUseMiniCat;
    }

    public int hashCode() {
        return Objects.hash(this.mySubstitutions, this.myIntrospectionScope, this.myUseMiniCat);
    }

    public void serialize(HierarchicalStreamWriter writer) {
        if (!this.myIntrospectionScope.isEmpty()) {
            writer.startNode("introspection-scope");
            TreePatternSerialization.serialize(writer, this.myIntrospectionScope, true);
            writer.endNode();
        }
        if (!this.mySubstitutions.isEmpty() || !this.myUseMiniCat) {
            writer.startNode("substitutions");
            if (!this.myUseMiniCat) {
                writer.addAttribute("use-mini-cat", String.valueOf(false));
            }
            for (Substitution s : this.mySubstitutions) {
                s.serialize(writer);
            }
            writer.endNode();
        }
    }

    public void deserialize(HierarchicalStreamReader reader) {
        this.myIntrospectionScope = TreePattern.EMPTY;
        this.mySubstitutions.clear();
        this.myUseMiniCat = true;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("introspection-scope".equals(reader.getNodeName()) && reader.hasMoreChildren()) {
                reader.moveDown();
                this.myIntrospectionScope = (TreePattern)ObjectUtils.notNull((Object)TreePatternSerialization.deserialize(reader), (Object)TreePattern.EMPTY);
                reader.moveUp();
            } else if ("substitutions".equals(reader.getNodeName())) {
                this.myUseMiniCat = Boolean.parseBoolean(StringUtil.notNullize((String)reader.getAttribute("use-mini-cat"), (String)"true"));
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    ContainerUtil.addIfNotNull(this.mySubstitutions, (Object)Substitution.deserialize(reader));
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 17, 21, 22, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSchemaMapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introspectionScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseKinds";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemaMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionScope";
                break;
            }
            case 17: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBy";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIntrospected";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionScope";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prune";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assignSubstitutions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assign";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "completeBy";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchesExact";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "asPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 17, 21, 22, 29 -> new IllegalStateException(string);
        };
    }

    public static final class Substitution {
        public final TreePattern where;
        public final String snapshotId;
        @Nullable
        public final ObjectPath basePath;

        private Substitution(@NotNull TreePattern where, @NotNull String snapshotId, @Nullable ObjectPath basePath) {
            if (where == null) {
                Substitution.$$$reportNull$$$0(0);
            }
            if (snapshotId == null) {
                Substitution.$$$reportNull$$$0(1);
            }
            this.where = where;
            this.snapshotId = snapshotId;
            this.basePath = basePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Substitution that = (Substitution)o;
            return this.where.equals(that.where) && this.snapshotId.equals(that.snapshotId) && Objects.equals(this.basePath, that.basePath);
        }

        public int hashCode() {
            return Objects.hash(this.where, this.snapshotId, this.basePath);
        }

        private void serialize(HierarchicalStreamWriter writer) {
            writer.startNode("substitution");
            writer.addAttribute("snapshot-id", this.snapshotId);
            if (this.basePath != null) {
                writer.addAttribute("base-path", this.basePath.serialize());
            }
            if (!this.where.isEmpty()) {
                TreePatternSerialization.serialize(writer, this.where, true);
            }
            writer.endNode();
        }

        @Nullable
        public static Substitution deserialize(@NotNull HierarchicalStreamReader reader) {
            if (reader == null) {
                Substitution.$$$reportNull$$$0(2);
            }
            if (!"substitution".equals(reader.getNodeName())) {
                return null;
            }
            String snapshotId = reader.getAttribute("snapshot-id");
            if (snapshotId == null) {
                return null;
            }
            String basePath = reader.getAttribute("base-path");
            ObjectPath bp = basePath == null ? null : ObjectPath.deserialize((String)basePath);
            TreePattern pattern = TreePattern.EMPTY;
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                pattern = (TreePattern)ObjectUtils.chooseNotNull((Object)TreePatternSerialization.deserialize(reader), (Object)TreePattern.EMPTY);
                reader.moveUp();
            }
            return new Substitution(pattern, snapshotId, bp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "where";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "snapshotId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemaMapping$Substitution";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserialize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

