/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.List;
import java.util.PriorityQueue;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.EnvelopeDistance;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;

class BoundablePair
implements Comparable {
    private Boundable boundable1;
    private Boundable boundable2;
    private double distance;
    private ItemDistance itemDistance;

    public BoundablePair(Boundable boundable1, Boundable boundable2, ItemDistance itemDistance) {
        this.boundable1 = boundable1;
        this.boundable2 = boundable2;
        this.itemDistance = itemDistance;
        this.distance = this.distance();
    }

    public Boundable getBoundable(int i2) {
        if (i2 == 0) {
            return this.boundable1;
        }
        return this.boundable2;
    }

    public double maximumDistance() {
        return EnvelopeDistance.maximumDistance((Envelope)this.boundable1.getBounds(), (Envelope)this.boundable2.getBounds());
    }

    private double distance() {
        if (this.isLeaves()) {
            return this.itemDistance.distance((ItemBoundable)this.boundable1, (ItemBoundable)this.boundable2);
        }
        return ((Envelope)this.boundable1.getBounds()).distance((Envelope)this.boundable2.getBounds());
    }

    public double getDistance() {
        return this.distance;
    }

    public int compareTo(Object o) {
        BoundablePair nd = (BoundablePair)o;
        if (this.distance < nd.distance) {
            return -1;
        }
        if (this.distance > nd.distance) {
            return 1;
        }
        return 0;
    }

    public boolean isLeaves() {
        return !BoundablePair.isComposite(this.boundable1) && !BoundablePair.isComposite(this.boundable2);
    }

    public static boolean isComposite(Object item) {
        return item instanceof AbstractNode;
    }

    private static double area(Boundable b) {
        return ((Envelope)b.getBounds()).getArea();
    }

    public void expandToQueue(PriorityQueue priQ, double minDistance) {
        boolean isComp1 = BoundablePair.isComposite(this.boundable1);
        boolean isComp2 = BoundablePair.isComposite(this.boundable2);
        if (isComp1 && isComp2) {
            if (BoundablePair.area(this.boundable1) > BoundablePair.area(this.boundable2)) {
                this.expand(this.boundable1, this.boundable2, false, priQ, minDistance);
                return;
            }
            this.expand(this.boundable2, this.boundable1, true, priQ, minDistance);
            return;
        }
        if (isComp1) {
            this.expand(this.boundable1, this.boundable2, false, priQ, minDistance);
            return;
        }
        if (isComp2) {
            this.expand(this.boundable2, this.boundable1, true, priQ, minDistance);
            return;
        }
        throw new IllegalArgumentException("neither boundable is composite");
    }

    private void expand(Boundable bndComposite, Boundable bndOther, boolean isFlipped, PriorityQueue priQ, double minDistance) {
        List children = ((AbstractNode)bndComposite).getChildBoundables();
        for (Boundable child : children) {
            BoundablePair bp = isFlipped ? new BoundablePair(bndOther, child, this.itemDistance) : new BoundablePair(child, bndOther, this.itemDistance);
            if (!(bp.getDistance() < minDistance)) continue;
            priQ.add(bp);
        }
    }
}

