/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/highlighting/PassRunningAssert;", "", "assertMessage", "", "<init>", "(Ljava/lang/String;)V", "passIsRunning", "Ljava/lang/ThreadLocal;", "", "runPass", "Lcom/intellij/openapi/application/AccessToken;", "suppressAssertInPass", "makeTokenForcingValue", "forcedValue", "lastReport", "Ljava/util/concurrent/atomic/AtomicLong;", "maxReportInterval", "", "assertPassNotRunning", "", "intellij.platform.core"})
@ApiStatus.Internal
public final class PassRunningAssert {
    @NotNull
    private final String assertMessage;
    @NotNull
    private final ThreadLocal<Boolean> passIsRunning;
    @NotNull
    private final AtomicLong lastReport;
    private final int maxReportInterval;

    public PassRunningAssert(@NotNull String assertMessage) {
        Intrinsics.checkNotNullParameter(assertMessage, "assertMessage");
        this.assertMessage = assertMessage;
        this.passIsRunning = new ThreadLocal();
        this.lastReport = new AtomicLong(-1L);
        this.maxReportInterval = 10000;
    }

    @NotNull
    public final AccessToken runPass() {
        return this.makeTokenForcingValue(true);
    }

    @NotNull
    public final AccessToken suppressAssertInPass() {
        return this.makeTokenForcingValue(false);
    }

    private final AccessToken makeTokenForcingValue(boolean forcedValue) {
        Boolean prevValue = this.passIsRunning.get();
        this.passIsRunning.set(forcedValue);
        return new AccessToken(prevValue, this){
            final /* synthetic */ Boolean $prevValue;
            final /* synthetic */ PassRunningAssert this$0;
            {
                this.$prevValue = $prevValue;
                this.this$0 = $receiver;
            }

            public void finish() {
                if (this.$prevValue != null) {
                    PassRunningAssert.access$getPassIsRunning$p(this.this$0).set(this.$prevValue);
                } else {
                    PassRunningAssert.access$getPassIsRunning$p(this.this$0).remove();
                }
            }
        };
    }

    public final void assertPassNotRunning() {
        if (!Intrinsics.areEqual(true, this.passIsRunning.get())) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            long lastReportVal;
            long curTime = System.currentTimeMillis();
            if (curTime - (lastReportVal = this.lastReport.get()) < (long)this.maxReportInterval) {
                return;
            }
            if (!this.lastReport.compareAndSet(lastReportVal, curTime)) {
                return;
            }
        }
        Logger.getInstance(PassRunningAssert.class).error(this.assertMessage);
    }

    public static final /* synthetic */ ThreadLocal access$getPassIsRunning$p(PassRunningAssert $this) {
        return $this.passIsRunning;
    }
}

