/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManagerKt;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/util/registry/EarlyAccessRegistryManager;", "", "<init>", "()V", "fileName", "", "getFileName$annotations", "getBoolean", "", "key", "getString", "getOrLoadMap", "", "setAndFlush", "", "data", "setBoolean", "value", "setString", "syncAndFlush", "invalidate", "intellij.platform.core"})
@ApiStatus.Obsolete
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEarlyAccessRegistryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,236:1\n1#2:237\n50#3:238\n58#3:258\n58#3:259\n218#4,19:239\n218#4,19:261\n55#5:260\n*S KotlinDebug\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n*L\n125#1:238\n158#1:258\n167#1:259\n149#1:239,19\n177#1:261,19\n175#1:260\n*E\n"})
public final class EarlyAccessRegistryManager {
    @NotNull
    public static final EarlyAccessRegistryManager INSTANCE = new EarlyAccessRegistryManager();
    @NotNull
    public static final String fileName = "early-access-registry.txt";

    private EarlyAccessRegistryManager() {
    }

    public static /* synthetic */ void getFileName$annotations() {
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return Boolean.parseBoolean(this.getString(key));
    }

    @Nullable
    public final String getString(@NotNull String key) {
        String string;
        Object object;
        ConcurrentHashMap map2;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter(key, "key");
                if (((CharSequence)key).length() == 0) {
                    EarlyAccessRegistryManagerKt.access$getLOG().error("Empty key");
                    return null;
                }
                map2 = (ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
                if (!LoadingState.APP_STARTED.isOccurred()) {
                    String string2;
                    String string3 = EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map2, key);
                    if (string3 != null) {
                        String string4;
                        String it = string4 = string3;
                        boolean bl = false;
                        string2 = ((CharSequence)it).length() > 0 ? string4 : null;
                    } else {
                        string2 = null;
                    }
                    return string2;
                }
                object = ApplicationManager.getApplication();
                if (object == null) break block10;
                ComponentManager $this$serviceOrNull$iv = (ComponentManager)object;
                boolean $i$f$serviceOrNull = false;
                object = (RegistryManager)$this$serviceOrNull$iv.getService(RegistryManager.class);
                if (object != null) break block11;
            }
            return EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map2, key);
        }
        Object registryManager = object;
        try {
            string = registryManager.stringValue(key);
        }
        catch (MissingResourceException missingResourceException) {
            string = null;
        }
        String value = string;
        if (value == null) {
            return null;
        }
        map2.putIfAbsent(key, value);
        String it = string = value;
        boolean bl = false;
        return ((CharSequence)it).length() > 0 ? string : null;
    }

    @NotNull
    public final Map<String, String> getOrLoadMap() {
        return (Map)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAndFlush(@NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (!(!LoadingState.COMPONENTS_REGISTERED.isOccurred())) {
            throw new IllegalStateException("Check failed.");
        }
        ConcurrentHashMap map2 = (ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
        map2.putAll(data);
        ConcurrentHashMap concurrentHashMap = map2;
        Path configFile$iv = EarlyAccessRegistryManagerKt.access$getConfigFile();
        boolean $i$f$saveConfigFile = false;
        if (!Intrinsics.areEqual(System.getProperty("early.access.registry.disable.saving"), "true")) {
            Comparable comparable;
            void map$iv;
            List lines$iv = new ArrayList();
            Set set = map$iv.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            for (String key$iv : CollectionsKt.sorted(set)) {
                String value$iv;
                Intrinsics.checkNotNull(key$iv);
                String it = key$iv;
                boolean bl = false;
                if ((String)map2.get(it) == null) continue;
                lines$iv.add(key$iv);
                lines$iv.add(value$iv);
            }
            if (lines$iv.isEmpty()) {
                comparable = Boolean.valueOf(Files.deleteIfExists(configFile$iv));
            } else {
                Files.createDirectories(configFile$iv.getParent(), new FileAttribute[0]);
                comparable = Files.write(configFile$iv, (Iterable<? extends CharSequence>)lines$iv, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }

    public final void setBoolean(@NotNull String key, boolean value) {
        block0: {
            Intrinsics.checkNotNullParameter(key, "key");
            ((ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue()).put(key, String.valueOf(value));
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = application;
            boolean $i$f$serviceIfCreated = false;
            Object object = (RegistryManager)$this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
            if (object == null || (object = object.get(key)) == null) break block0;
            ((RegistryValue)object).setValue(value);
        }
    }

    public final void setString(@NotNull String key, @NotNull String value) {
        block0: {
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(value, "value");
            ((ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue()).put(key, value);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue(application, "getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = application;
            boolean $i$f$serviceIfCreated = false;
            Object object = (RegistryManager)$this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
            if (object == null || (object = object.get(key)) == null) break block0;
            ((RegistryValue)object).setValue(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void syncAndFlush() {
        block9: {
            ConcurrentHashMap concurrentHashMap = EarlyAccessRegistryManagerKt.access$getMap();
            if (concurrentHashMap == null) {
                return;
            }
            ConcurrentHashMap map2 = concurrentHashMap;
            boolean $i$f$serviceIfCreated = false;
            Application application = ApplicationManager.getApplication();
            RegistryManager registryManager = (RegistryManager)(application != null ? application.getServiceIfCreated(RegistryManager.class) : null);
            if (registryManager == null) {
                return;
            }
            RegistryManager registryManager2 = registryManager;
            try {
                Comparable comparable;
                void map$iv;
                ConcurrentHashMap concurrentHashMap2 = map2;
                Path configFile$iv = EarlyAccessRegistryManagerKt.access$getConfigFile();
                boolean $i$f$saveConfigFile = false;
                if (Intrinsics.areEqual(System.getProperty("early.access.registry.disable.saving"), "true")) break block9;
                List lines$iv = new ArrayList();
                Set set = map$iv.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                for (String key$iv : CollectionsKt.sorted(set)) {
                    String value$iv;
                    String string;
                    Intrinsics.checkNotNull(key$iv);
                    String it = key$iv;
                    boolean bl = false;
                    try {
                        string = registryManager2.stringValue(it);
                    }
                    catch (MissingResourceException missingResourceException) {
                        string = null;
                    }
                    if (string == null) continue;
                    lines$iv.add(key$iv);
                    lines$iv.add(value$iv);
                }
                if (lines$iv.isEmpty()) {
                    comparable = Boolean.valueOf(Files.deleteIfExists(configFile$iv));
                } else {
                    Files.createDirectories(configFile$iv.getParent(), new FileAttribute[0]);
                    comparable = Files.write(configFile$iv, (Iterable<? extends CharSequence>)lines$iv, StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
            catch (Throwable e) {
                EarlyAccessRegistryManagerKt.access$getLOG().error("cannot save early access registry", e);
            }
        }
    }

    public final void invalidate() {
        if (!(!LoadingState.COMPONENTS_REGISTERED.isOccurred())) {
            throw new IllegalStateException("Check failed.");
        }
        EarlyAccessRegistryManagerKt.access$getLazyMap$p().drop();
    }
}

