/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.workspaceSymbol;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\r\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u001e\u0010\u0013\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\tJ\u0006\u0010\u0014\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lsp/impl/workspaceSymbol/LspWorkspaceSymbolCache;", "", "LspWorkspaceSymbolCache", "()V", "lastQuery", "", "lastPsiModificationCount", "", "lastResult", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "", "Lorg/eclipse/lsp4j/SymbolInformation;", "Lorg/eclipse/lsp4j/WorkspaceSymbol;", "get", "project", "Lcom/intellij/openapi/project/Project;", "query", "update", "", "payload", "clearCache", "intellij.platform.lsp.impl"})
public final class LspWorkspaceSymbolCache {
    @NotNull
    private String lastQuery = "";
    private long lastPsiModificationCount = -1L;
    @Nullable
    private Either<List<SymbolInformation>, List<WorkspaceSymbol>> lastResult;

    @RequiresBackgroundThread
    @Nullable
    public final synchronized Either<List<SymbolInformation>, List<WorkspaceSymbol>> get(@NotNull Project project, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        ProgressManager.checkCanceled();
        long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        Either<List<SymbolInformation>, List<WorkspaceSymbol>> either = this.lastResult;
        if (either != null && Intrinsics.areEqual((Object)this.lastQuery, (Object)query) && this.lastPsiModificationCount == l2) {
            return either;
        }
        return null;
    }

    public final synchronized void update(@NotNull Project project, @NotNull String query, @NotNull Either<List<SymbolInformation>, List<WorkspaceSymbol>> payload) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        this.lastQuery = query;
        this.lastPsiModificationCount = l2;
        this.lastResult = payload;
    }

    public final synchronized void clearCache() {
        this.lastQuery = "";
        this.lastPsiModificationCount = -1L;
        this.lastResult = null;
    }
}

