/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.structure.DvTreeImplantingLayer;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.JavaCoroutines;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDeleteProvider {
    private static void deleteDataSources(@NotNull Project project, @NotNull Set<RawDataSource> dataSources) {
        String message;
        Set dbDataSources;
        int n;
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(0);
        }
        if (dataSources == null) {
            DbDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((n = (dbDataSources = DatabaseContextFun.findDbDataSources(project, (JBIterable<RawDataSource>)JBIterable.from(dataSources)).toSet()).size()) == 1) {
            DbDataSource element = (DbDataSource)dbDataSources.iterator().next();
            Iterator name = StringUtil.shortenTextWithEllipsis((String)element.getName(), (int)60, (int)26, (boolean)true);
            int usageCount = DbImplUtilCore.countUsagesAsLinkedDataSource((Project)project, (String)element.getUniqueId());
            if (usageCount > 0) {
                name = (String)((Object)name) + " (" + DbImplUtilCore.usageAsLinkedDSMessage((int)usageCount) + ")";
            }
            boolean nameContainsDataSource = StringUtil.containsIgnoreCase((String)((Object)name), (String)"DataSource") || StringUtil.containsIgnoreCase(name, (String)"Data") && StringUtil.containsIgnoreCase(name, (String)"Source");
            message = DatabaseBundle.message((String)(nameContainsDataSource ? "confirmation.text.remove.data.source.1a" : "confirmation.text.remove.data.source.1b"), (Object[])new Object[]{name});
        } else {
            StringBuilder sb = new StringBuilder("<html><body>");
            sb.append(DatabaseBundle.message((String)"confirmation.text.remove.data.source.2", (Object[])new Object[]{n}));
            sb.append("<ul>");
            for (DbDataSource o : dbDataSources) {
                sb.append("<li>").append(o.getName());
                int usageCount = DbImplUtilCore.countUsagesAsLinkedDataSource((Project)project, (String)o.getUniqueId());
                if (usageCount > 0) {
                    sb.append(" (").append(DbImplUtilCore.usageAsLinkedDSMessage((int)usageCount)).append(")");
                }
                sb.append("</li>");
            }
            sb.append("</ul></body></html>");
            message = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)CommonBundle.message((String)"title.confirmation", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DbDeleteProvider.closeAllFilesBeforeDataSourceRemoval(project, dbDataSources);
        final DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() {
                for (DbDataSource dataSource : dbDataSources) {
                    facade.getDataSourceManager(dataSource).addDataSource(dataSource.getDelegate());
                }
            }

            public void redo() {
                for (DbDataSource dataSource : dbDataSources) {
                    facade.getDataSourceManager(dataSource).removeDataSource(dataSource.getDelegate());
                }
            }
        };
        try {
            WriteCommandAction.writeCommandAction((Project)project).withName(DatabaseBundle.message((String)"command.name.remove.data.source", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> DbDeleteProvider.lambda$deleteDataSources$0((UndoableAction)action, project));
        }
        catch (UnexpectedUndoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DbDeleteProvider.$$$reportNull$$$0(3);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource = DbImplUtilCore.findDataSource((Project)project, (VirtualFile)virtualFile);
            if (!elements.contains(dataSource)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    public static JBIterable<BasicElement> getElements(JBIterable<DbElement> selection) {
        JBIterable jBIterable = selection.filter(e -> !DataImporter.isBusy(e)).transform(DbElement::getDelegate).filter(BasicElement.class);
        if (jBIterable == null) {
            DbDeleteProvider.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static void showDialogAndRun(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, final @NotNull Iterable<BasicElement> selection, final @NotNull DropQueryGenerator generator) {
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(5);
        }
        if (dataSource == null) {
            DbDeleteProvider.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            DbDeleteProvider.$$$reportNull$$$0(7);
        }
        if (generator == null) {
            DbDeleteProvider.$$$reportNull$$$0(8);
        }
        DatabaseScriptDialog dialog = new DatabaseScriptDialog(project, dataSource.getDelegateDataSource(), searchPath, DatabaseBundle.message((String)"ddl.actions.confirm.drop", (Object[])new Object[0])){

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            @NotNull
            protected ScriptingTask getTask() {
                ScriptingSingleModelTask scriptingSingleModelTask = generator.createTask(null);
                if (scriptingSingleModelTask == null) {
                    2.$$$reportNull$$$0(0);
                }
                return scriptingSingleModelTask;
            }

            @Override
            @Nullable
            protected Object applyAndGetTask(@NotNull @NotNull Continuation<? super @NotNull ScriptingTask> $completion) {
                if ($completion == null) {
                    2.$$$reportNull$$$0(1);
                }
                return JavaCoroutines.suspendJava(c2 -> c2.resume((Object)this.getTask()), $completion);
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                generator.setOptions(options);
                this.generate();
            }

            private void generate() {
                ScriptingResult res2 = generator.generate();
                this.updateText(res2);
            }

            @Override
            protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
                if (handler2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (BasicElement element : selection) {
                    BasicElement basicElement = element.getParent();
                    if (basicElement instanceof BasicLikeTable) {
                        BasicLikeTable table = (BasicLikeTable)basicElement;
                        handler2.include((BasicElement)table);
                        Family fkFamily = table.familyOf(ObjectKind.FOREIGN_KEY);
                        if (fkFamily != null && fkFamily.isNotEmpty()) {
                            for (BasicForeignKey fk : fkFamily.jbi().filter(BasicForeignKey.class)) {
                                BasicTable tab = fk.getRefTable();
                                if (tab == null) continue;
                                handler2.include((BasicElement)tab);
                            }
                        }
                    }
                    handler2.include(element);
                }
                LocalDataSource localDataSource = handler2.getDataSource();
                if (localDataSource.shouldTrackNamespaces()) {
                    ArrayList<ObjectPath> toRemove = new ArrayList<ObjectPath>();
                    generator.fillNamespacesToRemove(toRemove);
                    for (ObjectPath pair : toRemove) {
                        handler2.getScopeUpdater().toRemove(pair);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "$completion";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTask";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "applyAndGetTask";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "fillContext";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        dialog.initAndShow();
    }

    @Nullable
    public static DeleteProvider getDeleteProvider(Iterable<? extends PsiElement> c2) {
        boolean allVirtual;
        JBIterable e = JBIterable.from(c2);
        if (e.isEmpty()) {
            return null;
        }
        if (DataSourceDeleteProvider.canDeleteElements((Iterable<DbElement>)e.filter(DbElement.class))) {
            return new DataSourceDeleteProvider();
        }
        boolean bl = allVirtual = e.find(o -> !(o instanceof DbElement) || !(((DbElement)o).getDelegate() instanceof DvTreeImplantingLayer.ImplantedVirtualObject)) == null;
        if (allVirtual) {
            return new DbVirtualElementDeleteProvider();
        }
        RawDataSource ds = (RawDataSource)e.filter(DbElement.class).map(o -> o.getDataSource().getDelegate()).first();
        return ds instanceof SqlDataSource ? new DdlElementDeleteProvider() : new DbElementDeleteProvider();
    }

    private static /* synthetic */ void lambda$deleteDataSources$0(UndoableAction action, Project project) throws UnexpectedUndoException {
        action.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed(action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeAllFilesBeforeDataSourceRemoval";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRun";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class DataSourceDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DataSourceDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DataSourceDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public String getActionTitle() {
            return DatabaseBundle.message((String)"ddl.actions.remove", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DataSourceDeleteProvider.$$$reportNull$$$0(1);
            }
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dataContext);
            return CollectionFun.containsOnly(ranks, (Object)DvTreeNodeRank.TL_ROOT);
        }

        @Deprecated(forRemoval=true)
        public static boolean canDeleteElements(Iterable<DbElement> elements) {
            HashSet selection = ContainerUtil.newHashSet(elements);
            DbElement stoppingElement = (DbElement)ContainerUtil.find((Iterable)selection, o -> !(o instanceof DbDataSource) && !selection.contains(o.getDataSource()));
            if (stoppingElement != null) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DataSourceDeleteProvider.$$$reportNull$$$0(2);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<RawDataSource> selection = DatabaseContextFun.getSelectedDataSources(dataContext);
            DbDeleteProvider.deleteDataSources(project, selection.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$DataSourceDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DataSourceDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DbVirtualElementDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DbVirtualElementDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DbVirtualElementDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public String getActionTitle() {
            return DatabaseBundle.message((String)"action.DatabaseView.DropAction.text", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DbVirtualElementDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement any = (DbElement)selection.first();
            LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)(any == null ? null : any.getDataSource()));
            if (lds == null) {
                return false;
            }
            return DbVirtualElementDeleteProvider.getVirtualObjects(selection).isNotEmpty();
        }

        @NotNull
        private static JBIterable<DvTreeImplantingLayer.ImplantedVirtualObject<?>> getVirtualObjects(@NotNull JBIterable<DbElement> selection) {
            if (selection == null) {
                DbVirtualElementDeleteProvider.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = selection.filterMap(e -> {
                DvTreeImplantingLayer.ImplantedVirtualObject object;
                Object patt0$temp = e.getDelegate();
                return patt0$temp instanceof DvTreeImplantingLayer.ImplantedVirtualObject ? (object = (DvTreeImplantingLayer.ImplantedVirtualObject)patt0$temp) : null;
            });
            if (jBIterable == null) {
                DbVirtualElementDeleteProvider.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DbVirtualElementDeleteProvider.$$$reportNull$$$0(4);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement any = (DbElement)selection.first();
            LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)(any == null ? null : any.getDataSource()));
            if (lds == null) {
                return;
            }
            String path = ModelExternalData.getExternalDataPath((LocalDataSource)lds);
            if (path == null) {
                return;
            }
            JBIterable objects = DbVirtualElementDeleteProvider.getVirtualObjects(selection).collect();
            if (objects.isEmpty()) {
                return;
            }
            ModelExternalData.modify((String)path, d -> {
                for (DvTreeImplantingLayer.ImplantedVirtualObject object : objects) {
                    DbVirtualElementDeleteProvider.remove(d, object);
                }
            });
            DataSourceStorage.getProjectStorage((Project)project).updateDataSource(lds);
        }

        private static <E extends BasicElement> void remove(ModelExternalData.Data d, DvTreeImplantingLayer.ImplantedVirtualObject<E> object) {
            VmModelContextFactory.VmExtractor extractor = VmModelContextFactory.createVirtualObjectsExtractor((BasicMetaObject)object.getMetaObject());
            if (extractor == null) {
                return;
            }
            extractor.remove(d, object.extractObject(), ObjectPaths.of((DasObject)object.getDasParent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$DbVirtualElementDeleteProvider";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DbVirtualElementDeleteProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVirtualObjects";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DdlElementDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DdlElementDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DdlElementDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public String getActionTitle() {
            return DatabaseBundle.message((String)"action.DatabaseView.DropAction.text", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DdlElementDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource = any == null ? null : any.getDataSource();
            return dataSource != null && dataSource.getDelegate() instanceof SqlDataSource && any != dataSource;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DdlElementDeleteProvider.$$$reportNull$$$0(2);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement first = (DbElement)selection.first();
            if (first == null) {
                return;
            }
            DbDataSource dataSource = first.getDataSource();
            SqlDataSource sqlDs = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
            if (sqlDs == null) {
                return;
            }
            ScriptedScriptConsumer consumer = DumpToDdlDataSourceActionKt.createScriptConsumerSafe(project, sqlDs, (Function2<? super Path, ? super ScriptingResult, Unit>)((Function2)(f, r) -> Unit.INSTANCE));
            if (consumer == null) {
                return;
            }
            ArrayList targets = new ArrayList();
            WriteAction.run(() -> ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)selection.filter(o -> o.getDataSource() == dataSource).filterMap(DbImplUtilCore::getMaybeBasicElement))).filter(BasicElement.class).map(o -> {
                String tag = consumer.distribute((BasicElement)o);
                return tag == null ? null : consumer.getFile(tag);
            }).unique().filterMap(f -> VfsUtil.findFile((Path)f, (boolean)true)).filterMap(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0)).addAllTo(targets));
            DeleteHandler.deletePsiElement((PsiElement[])targets.toArray(PsiElement.EMPTY_ARRAY), (Project)project, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$DdlElementDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DdlElementDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DbElementDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DbElementDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DbElementDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public String getActionTitle() {
            return DatabaseBundle.message((String)"action.DatabaseView.DropAction.text", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            BasicModel model;
            Project project;
            if (dataContext == null) {
                DbElementDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource = any == null ? null : any.getDataSource();
            BasicModel basicModel = model = dataSource == null ? null : (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null || !ImportUtil.canConnectToAndModify((DbElement)dataSource)) {
                return false;
            }
            for (DbElement e : selection) {
                if (!e.isWritable()) {
                    return false;
                }
                if (dataSource.equals((Object)e.getDataSource())) continue;
                return false;
            }
            return DropQueryGenerator.canDeleteAnything(model, DbDeleteProvider.getElements(selection));
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DbElementDeleteProvider.$$$reportNull$$$0(2);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement first = (DbElement)selection.first();
            if (first == null) {
                return;
            }
            DbDataSource dataSource = first.getDataSource();
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            JBIterable<BasicElement> selectedElements = DbDeleteProvider.getElements(selection);
            BasicNamespace namespace = CreateObjectAction.getCurrentNamespaceOrAnotherDb((DasDataSource)dataSource, selectedElements.toSet());
            DropQueryGenerator generator = new DropQueryGenerator(project, model);
            generator.setItems((Iterable<BasicElement>)selectedElements);
            while (namespace != null && generator.getItems().contains(namespace)) {
                namespace = (BasicNamespace)ObjectUtils.tryCast((Object)namespace.getParent(), BasicNamespace.class);
            }
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(project, dataSource, ObjectPaths.searchPathOf((DasObject)namespace), selectedElements, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$DbElementDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DbElementDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DbTreeDeleteProvider
    implements DeleteProvider {
        private final DataSourceDeleteProvider myDsProvider = new DataSourceDeleteProvider();
        private final DbVirtualElementDeleteProvider myVirtualProvider = new DbVirtualElementDeleteProvider();

        public void deleteElement(@NotNull DataContext dataContext) {
            DeleteProvider delegate;
            if (dataContext == null) {
                DbTreeDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((delegate = this.getDelegate(dataContext)) != null) {
                delegate.deleteElement(dataContext);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DbTreeDeleteProvider.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            DeleteProvider delegate;
            if (dataContext == null) {
                DbTreeDeleteProvider.$$$reportNull$$$0(2);
            }
            return (delegate = this.getDelegate(dataContext)) != null && delegate.canDeleteElement(dataContext);
        }

        @Nullable
        private DeleteProvider getDelegate(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DbTreeDeleteProvider.$$$reportNull$$$0(3);
            }
            if (this.myDsProvider.canDeleteElement(dataContext)) {
                return this.myDsProvider;
            }
            DbContextElements<?> elements = DbContextElementsKt.computeContextElements(dataContext);
            if (elements == null || !elements.getOther().isEmpty()) {
                return null;
            }
            if (DbTreeDeleteProvider.isAllVirtual(elements)) {
                return this.myVirtualProvider;
            }
            if (ContainerUtil.find(elements.getDataSources(), d -> !(d instanceof LocalDataSource)) == null) {
                return new DbElementDeleteProvider();
            }
            if (ContainerUtil.find(elements.getDataSources(), d -> !(d instanceof SqlDataSource)) == null) {
                return new DdlElementDeleteProvider();
            }
            return null;
        }

        private static boolean isAllVirtual(DbContextElements<?> elements) {
            if (elements.getSelection().isEmpty()) {
                return false;
            }
            for (DbContextDataSourceElements<?> dsSel : elements.getSelection().values()) {
                BasicNode nonVirtual = (BasicNode)dsSel.expandGroups().asNodes().asIterable().find(o -> !(o instanceof DvTreeImplantingLayer.ImplantedVirtualObject));
                if (nonVirtual == null) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider$DbTreeDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DbTreeDeleteProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelegate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

