/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cloudExplorer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionDataStorageImpl;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.database.util.RunnableWithDebounce;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="CloudConnectionData", storages={@Storage(value="cloud_connection_data.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "delegate", "Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorageImpl;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getConnectionData", "Lcom/intellij/database/cloudExplorer/CloudConnectionData;", "id", "", "getConnectionsData", "", "getState", "loadState", "", "state", "initializeComponent", "removeConnectionData", "target", "update", "updateConnectionData", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nCloudConnectionDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1#2:42\n1563#3:43\n1634#3,3:44\n*S KotlinDebug\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage\n*L\n36#1:43\n36#1:44,3\n*E\n"})
public final class CloudConnectionDataStorage
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CloudConnectionDataStorageImpl delegate;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public CloudConnectionDataStorage(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.delegate = new CloudConnectionDataStorageImpl();
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CloudConnectionData getConnectionData(@NotNull String id) {
        CloudConnectionData cloudConnectionData;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            cloudConnectionData = this.delegate.getConnectionData(id);
        }
        finally {
            lock.unlock();
        }
        return cloudConnectionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CloudConnectionData> getConnectionsData() {
        List<CloudConnectionData> list;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            list = this.delegate.getConnectionsData();
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element getState() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            Element element = this.delegate.getState();
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.loadState(state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public void initializeComponent() {
        block0: {
            ExtensionPoint extensionPoint = CloudDataSourceProvider.Companion.getEP_COLLECTOR().getPoint();
            if (extensionPoint == null) break block0;
            extensionPoint.addChangeListener(this.coroutineScope, (Runnable)new RunnableWithDebounce(this.coroutineScope, this::updateConnectionData, 0L, 4, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConnectionData(@NotNull CloudConnectionData target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.removeConnectionData(target);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull CloudConnectionData target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.update(target);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateConnectionData() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Iterable iterable = CloudDataSourceProvider.Companion.getProviders();
            CloudConnectionDataStorageImpl cloudConnectionDataStorageImpl = this.delegate;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add((String)it.getFirst());
            }
            cloudConnectionDataStorageImpl.updateConnectionData(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nCloudConnectionDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,41:1\n42#2,3:42\n*S KotlinDebug\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion\n*L\n39#1:42,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudConnectionDataStorage getInstance() {
            boolean $i$f$service = false;
            Class<CloudConnectionDataStorage> serviceClass$iv = CloudConnectionDataStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CloudConnectionDataStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

